/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import net.argius.stew.io.Exporter;
import net.argius.stew.io.StringBasedSerializer;

public final class XmlExporter
extends Exporter {
    private static final String ENCODING = "utf-8";
    private static final String TAG_TABLE = "table";
    private static final String TAG_TABLE_START = "<table writer=\"" + XmlExporter.class.getName() + "\">";
    private static final String TAG_TABLE_END = "</table>";
    private static final String TAG_HEADERROW = "headerrow";
    private static final String TAG_HEADERROW_END = "</headerrow>";
    private static final String TAG_HEADERROW_START = "<headerrow>";
    private static final String TAG_HEADER = "header";
    private static final String TAG_HEADER_START = "<header";
    private static final String TAG_HEADER_END = "</header>";
    private static final String TAG_ROW = "row";
    private static final String TAG_ROW_START = "<row>";
    private static final String TAG_ROW_END = "</row>";
    private PrintWriter out;

    public XmlExporter(OutputStream outputStream) {
        super(outputStream);
        try {
            this.out = new PrintWriter(new OutputStreamWriter(outputStream, ENCODING));
            this.out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            this.out.println("<!DOCTYPE table SYSTEM \"stew-table.dtd\">");
            this.out.println(TAG_TABLE_START);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
    }

    @Override
    protected void writeHeader(Object[] objectArray) throws IOException {
        this.ensureOpen();
        this.out.println(TAG_HEADERROW_START);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            this.out.printf("<header index=\"%d\">%s</header>%n", i, XmlExporter.convertCData(String.valueOf(object)));
        }
        this.out.println(TAG_HEADERROW_END);
        this.out.flush();
    }

    @Override
    public void addRow(Object[] objectArray) throws IOException {
        this.ensureOpen();
        this.out.print(TAG_ROW_START);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            StringBasedSerializer.Element element = StringBasedSerializer.serialize(object);
            String string = element.getType();
            if (element.isNull()) {
                this.out.print("<" + string + "/>");
                continue;
            }
            this.out.print("<" + string);
            if (string.equals("object")) {
                this.out.print(" class=\"");
                this.out.print(object.getClass().getName());
                this.out.print("\"");
            } else if (string.equals("time")) {
                this.out.print(" display=\"");
                this.out.print(object);
                this.out.print("\"");
            }
            this.out.print(">");
            this.out.print(XmlExporter.convertCData(element.getValue()));
            this.out.print("</" + string + ">");
        }
        this.out.println(TAG_ROW_END);
        this.out.flush();
    }

    private static String convertCData(String string) {
        String string2 = string;
        if (string2.indexOf(60) >= 0 || string2.indexOf(62) >= 0) {
            if (string2.contains("]]>")) {
                string2 = string2.replaceAll("\\]\\]>", "]]&gt;");
            }
            return "<![CDATA[" + string2 + "]]>";
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.ensureOpen();
        try {
            if (this.out != null) {
                this.out.print(TAG_TABLE_END);
                this.out.close();
            }
        }
        finally {
            this.out = null;
            super.close();
        }
    }
}

