/*
 *  Copyright 2011 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew;

import java.util.concurrent.*;

import net.argius.logging.*;

/**
 * f[Xbh̃t@NgB
 */
public final class DaemonThreadFactory implements ThreadFactory {

    private static final Logger log = LoggerFactory.getLogger(DaemonThreadFactory.class);

    private static volatile int count;

    private static ThreadFactory instance;

    private DaemonThreadFactory() {
        // empty
    }

    /**
     * @return instance of DaemonThreadFactory
     */
    public static ThreadFactory getInstance() {
        if (instance == null) {
            instance = new DaemonThreadFactory();
        }
        return instance;
    }

    /* @see java.util.concurrent.ThreadFactory#newThread(java.lang.Runnable) */
    public Thread newThread(Runnable r) {
        final String name = String.format("ChildDaemon%d-of-%s", count++, Thread.currentThread());
        if (log.isDebugEnabled()) {
            log.debug("create thread: name=" + name);
        }
        Thread thread = new Thread(r, name);
        thread.setDaemon(true);
        return thread;
    }

    /**
     * f[XbhŃ^XNsB
     * @param r ^XN
     */
    public static void execute(Runnable r) {
        getInstance().newThread(r).start();
    }

}
