/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew;

import java.net.*;
import java.security.*;

/**
 * I[h@\B
 */
public final class DynamicLoader {

    private DynamicLoader() {
        // empty
    }

    /**
     * NX[hB
     * @param <T> Cӂ̃NX
     * @param className NX(FQCN)
     * @return [hꂽNX
     * @throws DynamicLoadingException
     */
    public static <T> Class<T> loadClass(String className) throws DynamicLoadingException {
        return loadClass(className, ClassLoader.getSystemClassLoader());
    }

    /**
     * NX[hB
     * @param <T> Cӂ̃NX
     * @param className NX(FQCN)
     * @param classLoader NX[_
     * @return [hꂽNX
     * @throws DynamicLoadingException
     */
    public static <T> Class<T> loadClass(String className, ClassLoader classLoader) throws DynamicLoadingException {
        try {
            @SuppressWarnings("unchecked")
            Class<T> c = (Class<T>)classLoader.loadClass(className);
            return c;
        } catch (Throwable th) {
            throw new DynamicLoadingException("class loading error", th);
        }
    }

    /**
     * VCX^X𐶐B
     * @param <T> Cӂ̃NX
     * @param className NX(FQCN)
     * @return VCX^X
     * @throws DynamicLoadingException
     */
    public static <T> T newInstance(String className) throws DynamicLoadingException {
        // T o = newInstance(className, DynamicLoader.class.getClassLoader());
        @SuppressWarnings("unchecked")
        T o = (T)newInstance(className, DynamicLoader.class.getClassLoader());
        return o;
    }

    /**
     * VCX^X𐶐B
     * @param <T> Cӂ̃NX
     * @param className NX(FQCN)
     * @param urls NXpXURLz
     * @return  VCX^X
     * @throws DynamicLoadingException
     */
    public static <T> T newInstance(String className, URL... urls) throws DynamicLoadingException {
        // T o = newInstance(className, getURLClassLoader(urls));
        @SuppressWarnings("unchecked")
        T o = (T)newInstance(className, getURLClassLoader(urls));
        return o;
    }

    /**
     * VCX^X𐶐B
     * @param <T> Cӂ̃NX
     * @param className NX(FQCN)
     * @param classLoader NX[_
     * @return VCX^X
     * @throws DynamicLoadingException
     */
    public static <T> T newInstance(String className, ClassLoader classLoader) throws DynamicLoadingException {
        try {
            Class<T> c = loadClass(className, classLoader);
            return c.newInstance();
        } catch (DynamicLoadingException ex) {
            throw ex;
        } catch (Throwable th) {
            throw new DynamicLoadingException("load error: " + className, th);
        }
    }

    /**
     * VCX^X𐶐B
     * @param <T> Cӂ̃NX
     * @param classObject NX
     * @return VCX^X
     * @throws DynamicLoadingException
     */
    public static <T> T newInstance(Class<T> classObject) throws DynamicLoadingException {
        try {
            return classObject.newInstance();
        } catch (Throwable th) {
            throw new DynamicLoadingException("load error: " + classObject, th);
        }
    }

    /**
     * URLClassLoader̎擾B
     * @param urls NXpXURLz
     * @return URLClassLoader
     */
    private static URLClassLoader getURLClassLoader(final URL... urls) {
        return (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction<Object>() {

            public Object run() {
                return new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
            }

        });
    }

}
