/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.logging;

/**
 * WG[o͂o͐ƂLoggerB
 */
final class StandardErrorOutputLogger extends BasicLogger {

    private final String targetClassName;

    /**
     * RXgN^B
     * @param targetClassName ΏۃNX
     */
    public StandardErrorOutputLogger(String targetClassName) {
        this.targetClassName = targetClassName;
    }

    @Override
    protected void printMessage(String levelString, Object object) {
        System.err.printf("%1$tF %1$tT.%1$tL (%2$s) %3$s [%4$s] %5$s%n",
                          System.currentTimeMillis(),
                          levelString,
                          Thread.currentThread().getName(),
                          targetClassName,
                          object);
    }

    @Override
    protected void printStackTrace(Throwable th) {
        th.printStackTrace(System.err);
    }

}
