/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.command;

import java.io.*;
import java.sql.*;
import java.util.*;

import net.argius.logging.*;
import net.argius.stew.*;
import net.argius.stew.io.*;
import net.argius.stew.ui.*;

/**
 * f[^t@Cɏo͂R}hB
 *
 * gpłR}h́A"SELECT","FIND","REPORT"̂RށB
 * 
 * o͌`́Agqɂ莩IɑIB
 * @see Exporter
 */
public final class Export extends Command {

    private static final Logger log = LoggerFactory.getLogger(Export.class);

    @Override
    public void execute(Connection conn, Parameter parameter) throws CommandException {
        if (parameter.isEmpty(3)) {
            throw new UsageException(getUsage());
        }
        // 
        int argsIndex = 2;
        final String p1 = parameter.get(argsIndex++);
        final String p2 = parameter.get(argsIndex);
        boolean withHeader = false;
        if (p2.equalsIgnoreCase("HEADER")) {
            withHeader = true;
            ++argsIndex;
        }
        final String p3 = parameter.getAll(argsIndex);
        if (log.isDebugEnabled()) {
            log.debug(String.format("file: [%s]", p1));
            log.debug("withHeader: " + withHeader);
            log.debug(String.format("command: [%s]", p3));
        }
        // s
        try {
            export(p1, withHeader, p3);
            outputMessage("i.exported");
        } catch (IOException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    /**
     * GNX|[gsB
     * @param pathName o͐t@C̃pX
     * @param withHeader wb_L
     * @param command R}h
     * @throws IOException o̓G[ꍇ
     */
    private void export(String pathName, boolean withHeader, String command) throws IOException {
        final File path = resolvePath(pathName);
        if (path.exists()) {
            throw new CommandException(getMessage("e.file-already-exists", path));
        }
        Exporter exporter = Exporter.getExporter(path);
        try {
            OutputProcessor parent = env.getOutputProcessor();
            OutputProcessor output = new ExporterOutputProcessor(exporter, parent, withHeader);
            // XXX XbhZ[tłȂ(ÃXbhs邱Ƃ͍̂Ƃ떳)
            try {
                env.setOutputProcessor(output);
                Command.invoke(env, command);
            } finally {
                env.setOutputProcessor(parent);
            }
        } finally {
            exporter.close();
        }
    }

    /**
     * Export̏o͐B
     */
    private static final class ExporterOutputProcessor implements OutputProcessor {

        private static final Logger log = LoggerFactory.getLogger(ExporterOutputProcessor.class);

        private final Exporter exporter;
        private final OutputProcessor output;
        private final boolean withHeader;

        /**
         * RXgN^B
         * @param exporter GNX|[g
         * @param output ʂ̏o͐
         * @param withHeader wb_L
         */
        public ExporterOutputProcessor(Exporter exporter, OutputProcessor output, boolean withHeader) {
            this.exporter = exporter;
            this.output = output;
            this.withHeader = withHeader;
        }

        /* @see net.argius.stew.OutputProcessor#output(java.lang.Object) */
        public void output(Object object) {
            try {
                if (object instanceof ResultSetReference) {
                    ResultSetReference ref = (ResultSetReference)object;
                    ref.setRecordCount(outputResultSet(ref.getResultSet(), ref.getOrder()));
                } else {
                    output.output(object);
                }
            } catch (IOException ex) {
                log.error("", ex);
                output.output(ex.getMessage());
            } catch (SQLException ex) {
                log.error("", ex);
                output.output(ex.getMessage());
            }
        }

        /**
         * ʃZbgo͂B
         * @param rs ʃZbg
         * @param order 
         * @return ʂ̌
         * @throws IOException o̓G[ꍇ
         * @throws SQLException SQL֘AG[ꍇ
         */
        private int outputResultSet(ResultSet rs, ColumnOrder order) throws IOException, SQLException {
            int count = 0;
            boolean needOrderChange = order.size() > 0;
            int columnCount;
            List<String> header = new ArrayList<String>();
            if (needOrderChange) {
                columnCount = order.size();
                for (int i = 0; i < columnCount; i++) {
                    header.add(order.getName(i));
                }
            } else {
                ResultSetMetaData m = rs.getMetaData();
                columnCount = m.getColumnCount();
                for (int i = 0; i < columnCount; i++) {
                    header.add(m.getColumnName(i + 1));
                }
            }
            if (withHeader) {
                exporter.addHeader(header.toArray());
            }
            while (rs.next()) {
                ++count;
                Object[] row = new Object[columnCount];
                for (int i = 0; i < columnCount; i++) {
                    int index = (needOrderChange) ? order.getOrder(i) : i + 1;
                    row[i] = rs.getObject(index);
                }
                exporter.addRow(row);
            }
            return count;
        }

        /* @see net.argius.stew.OutputProcessor#close() */
        public void close() {
            // empty
        }

    }

}