/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew;

import java.io.*;
import java.util.*;

import net.argius.logging.*;
import net.argius.stew.io.*;

/**
 * [JVXeB
 */
public final class LocalSystem {

    private static final String FILE_PROPERTIES = "stew.properties";

    private static final Logger log = LoggerFactory.getLogger(LocalSystem.class);

    private static File directory = initializeDirectory();
    private static Properties props = initializeProperties();

    private LocalSystem() {
        // empty
    }

    /**
     * VXefBNg̏B
     * @return VXefBNg
     */
    private static File initializeDirectory() {
        File directory;
        String path = System.getProperty(PropertyKey.PROPERTIES);
        if (path == null) {
            directory = new File(".stew");
        } else {
            File file = new File(path);
            if (file.isDirectory()) {
                directory = file;
            } else {
                directory = file.getParentFile();
                if (directory == null) {
                    directory = new File(".stew");
                }
            }
        }
        try {
            Path.makeDirectory(directory);
        } catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return directory;
    }

    /**
     * vpeB̏B
     * @return vpeB
     */
    private static Properties initializeProperties() {
        Properties group3 = System.getProperties();
        Properties group2 = new Properties(group3);
        try {
            group2.putAll(getFileProperties());
        } catch (IOException ex) {
            log.warn("", ex);
        }
        Properties group1 = new Properties(group2);
        if (log.isTraceEnabled()) {
            int i = 3;
            for (Properties p : new Properties[]{group3, group2}) {
                List<String> list = new ArrayList<String>(p.size());
                for (Object key : p.keySet()) {
                    list.add((String)key);
                }
                Collections.sort(list);
                Writer buffer = new StringWriter();
                PrintWriter out = new PrintWriter(buffer);
                out.println();
                out.println("--- property group " + (i--) + " ---");
                for (Iterator<String> it = list.iterator(); it.hasNext();) {
                    String key = it.next();
                    out.println(key + '=' + p.getProperty(key));
                }
                log.trace(buffer);
            }
        }
        return group1;
    }

    /**
     * vpeBt@C"stew.properties"AΓǂݍށB
     * t@C鏇͈ȉ̒ʂB
     * <ol>
     * <li>VXevpeB"net.argius.stew.properties"ŎꂽpX
     *     (pXfBNgȂAstew.propertieŝƌȂ)
     * <li>NXpX
     * <li>VXefBNg
     * </ol>
     * @return Properties
     * @throws IOException
     */
    private static Properties getFileProperties() throws IOException {
        Properties props = new Properties();
        // VXevpeB
        String path = System.getProperty(PropertyKey.PROPERTIES);
        if (path != null) {
            File file = new File(path);
            if (file.isDirectory()) {
                file = new File(file, FILE_PROPERTIES);
            }
            if (file.exists()) {
                InputStream is = new FileInputStream(file);
                try {
                    props.load(is);
                    return props;
                } finally {
                    is.close();
                }
            }
        }
        // NXpX
        String resourcePath = "/" + FILE_PROPERTIES;
        InputStream res = LocalSystem.class.getResourceAsStream(resourcePath);
        if (res != null) {
            try {
                props.load(res);
                return props;
            } finally {
                res.close();
            }
        }
        // VXefBNg
        File currentdirfile = new File(directory, FILE_PROPERTIES);
        if (currentdirfile.exists()) {
            InputStream is = new FileInputStream(currentdirfile);
            try {
                props.load(is);
                return props;
            } finally {
                is.close();
            }
        }
        return props;
    }

    /**
     * VXefBNg̎擾B
     * @return VXefBNg
     */
    public static File getDirectory() {
        return directory;
    }

    /**
     * vpeB̎擾B
     * K<code>null</code>łȂlԂB
     * @param key vpeBL[
     * @return vpeBl
     */
    public static String getProperty(String key) {
        return props.getProperty(key, "");
    }

    /**
     * vpeB̎擾B
     * @param key vpeBL[
     * @param defaultValue vpeB݂Ȃꍇ̏l
     * @return vpeBl
     */
    public static String getProperty(String key, String defaultValue) {
        return props.getProperty(key, defaultValue);
    }

    /**
     * vpeB𐮐lƂĎ擾B
     * vpeB݂Ȃꍇ <code>0</code>ԂB
     * @param key vpeBL[
     * @return vpeBl
     */
    public static int getPropertyAsInt(String key) {
        return getPropertyAsInt(key, 0);
    }

    /**
     * vpeB𐮐lƂĎ擾B
     * @param key vpeBL[
     * @param defaultValue vpeB݂Ȃꍇ̏l
     * @return vpeBl
     */
    public static int getPropertyAsInt(String key, int defaultValue) {
        try {
            String v = props.getProperty(key);
            if (v != null) {
                return Integer.decode(v);
            }
        } catch (NumberFormatException e) {
            // ignore
        } catch (IllegalArgumentException e) {
            // ignore
        }
        return defaultValue;
    }

    /**
     * vpeB̐ݒB
     * @param key L[
     * @param value l
     * @return ݒ肷Oɐݒ肳ĂliȂ<code>null</code>j
     */
    public static Object setProperty(String key, String value) {
        return props.setProperty(key, value);
    }

    /**
     * w肳ꂽL[vpeBɐݒ肳Ă邩ǂ𒲂ׂB
     * @param key vpeBL[
     * @return w肳ꂽL[vpeBɐݒ肳Ă邩ǂ
     */
    public static boolean containsKey(String key) {
        return props.getProperty(key) != null;
    }

}
