/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import net.argius.stew.ui.window.Resource;
import net.argius.stew.ui.window.ResultSetTable;
import net.argius.stew.ui.window.WindowOutputProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Menu
extends JMenuBar
implements PropertyChangeListener {
    private static List<Menu> menus = new ArrayList<Menu>();
    private List<JMenuItem> lockingTargets;
    private List<JMenuItem> unlockingTargets;
    private Map<Item, JMenuItem> menuItems;

    Menu() {
        menus.add(this);
        this.lockingTargets = new ArrayList<JMenuItem>();
        this.unlockingTargets = new ArrayList<JMenuItem>();
        this.menuItems = new LinkedHashMap<Item, JMenuItem>();
        int n = Resource.getMenuShortcutKeyMask();
        this.add(Menu.createJMenu("file", 'F', this.createJMenuItem(Item.NEW, 'N', KeyStroke.getKeyStroke(78, n)), this.createJMenuItem(Item.CLOSE, 'C', KeyStroke.getKeyStroke(87, n)), new JSeparator(), this.createJMenuItem(Item.QUIT, 'Q', KeyStroke.getKeyStroke(81, n))));
        this.add(Menu.createJMenu("edit", 'E', this.createJMenuItem(Item.CUT, 'T', KeyStroke.getKeyStroke(88, n)), this.createJMenuItem(Item.COPY, 'C', KeyStroke.getKeyStroke(67, n)), this.createJMenuItem(Item.PASTE, 'P', KeyStroke.getKeyStroke(86, n)), this.createJMenuItem(Item.SELECT_ALL, 'A', KeyStroke.getKeyStroke(65, n)), new JSeparator(), this.createJMenuItem(Item.FIND, 'F', KeyStroke.getKeyStroke(70, n)), new JSeparator(), this.createJMenuItem(Item.TOGGLE_FOCUS, 'G', KeyStroke.getKeyStroke(71, n)), this.createJMenuItem(Item.CLEAR_MESSAGE, 'M')));
        this.add(Menu.createJMenu("view", 'V', this.createJCheckBoxMenuItem(Item.STATUS_BAR, 'S', null), this.createJCheckBoxMenuItem(Item.COLUMN_NUMBER, 'C', null), this.createJCheckBoxMenuItem(Item.INFO_TREE, 'I', null), this.createJCheckBoxMenuItem(Item.ALWAYS_ON_TOP, 'T', null), new JSeparator(), this.createJMenuItem(Item.REFRESH, 'R', KeyStroke.getKeyStroke(116, 0)), new JSeparator(), this.createJMenuItem(Item.WIDEN, 'W', KeyStroke.getKeyStroke(46, n)), this.createJMenuItem(Item.NARROW, 'N', KeyStroke.getKeyStroke(44, n)), this.createJMenuItem(Item.ADJUST_COLUMN_WIDTH, 'A', KeyStroke.getKeyStroke(47, n)), this.createAutoAdjustModeItems()));
        this.add(Menu.createJMenu("command", 'C', this.createJMenuItem(Item.EXECUTE, 'X', KeyStroke.getKeyStroke(77, n)), this.createJMenuItem(Item.BREAK, 'B', KeyStroke.getKeyStroke(19, n)), new JSeparator(), this.createJMenuItem(Item.HISTORY_BACK, 'P', KeyStroke.getKeyStroke(38, n)), this.createJMenuItem(Item.HISTORY_NEXT, 'N', KeyStroke.getKeyStroke(40, n)), new JSeparator(), this.createJMenuItem(Item.CONNECT, 'C', KeyStroke.getKeyStroke(69, n)), this.createJMenuItem(Item.DISCONNECT, 'D', KeyStroke.getKeyStroke(68, n)), new JSeparator(), this.createJMenuItem(Item.ENCRYPTION_KEY, 'K'), this.createJMenuItem(Item.EDIT_CONNECTORS, 'E')));
        this.add(Menu.createJMenu("data", 'D', this.createJMenuItem(Item.SORT, 'S', KeyStroke.getKeyStroke(83, 512)), this.createJMenuItem(Item.IMPORT, 'I'), this.createJMenuItem(Item.EXPORT, 'X', KeyStroke.getKeyStroke(83, n | 0x40))));
        this.add(Menu.createJMenu("help", 'H', this.createJMenuItem(Item.HELP, 'H'), new JSeparator(), this.createJMenuItem(Item.ABOUT, 'A')));
        this.setEnabledStates(false);
    }

    static void changeKeyBinds(List<String> list) {
        Pattern pattern = Pattern.compile("\\s*([^=\\s]+)\\s*=(.*)");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (string.matches("\\s*#.*")) continue;
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                try {
                    Item item = Item.valueOf(matcher.group(1));
                    KeyStroke keyStroke = KeyStroke.getKeyStroke(matcher.group(2));
                    for (Menu menu : menus) {
                        menu.menuItems.get((Object)item).setAccelerator(keyStroke);
                    }
                    continue;
                }
                catch (Exception exception) {
                    arrayList.add(string);
                    continue;
                }
            }
            arrayList.add(string);
        }
        if (!arrayList.isEmpty()) {
            throw new IllegalArgumentException(((Object)arrayList).toString());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getSource();
        if (object instanceof JLabel && string.equals("ancestor")) {
            this.menuItems.get((Object)Item.STATUS_BAR).setSelected(((JLabel)object).isVisible());
        } else if (object instanceof ResultSetTable && string.equals("showNumber")) {
            this.menuItems.get((Object)Item.COLUMN_NUMBER).setSelected((Boolean)propertyChangeEvent.getNewValue());
        } else if (object instanceof JTree && string.equals("enabled")) {
            this.menuItems.get((Object)Item.INFO_TREE).setSelected((Boolean)propertyChangeEvent.getNewValue());
        } else if (object instanceof JFrame && string.equals("alwaysOnTop")) {
            this.menuItems.get((Object)Item.ALWAYS_ON_TOP).setSelected((Boolean)propertyChangeEvent.getNewValue());
        } else if (object instanceof WindowOutputProcessor && string.equals("autoAdjustMode")) {
            ((JCheckBoxMenuItem)this.menuItems.get(propertyChangeEvent.getNewValue())).setSelected(true);
        }
    }

    private JMenu createAutoAdjustModeItems() {
        ArrayList<JCheckBoxMenuItem> arrayList = new ArrayList<JCheckBoxMenuItem>();
        ButtonGroup buttonGroup = new ButtonGroup();
        HashMap<Item, Character> hashMap = new HashMap<Item, Character>();
        hashMap.put(Item.AUTO_ADJUST_MODE_NONE, Character.valueOf('N'));
        hashMap.put(Item.AUTO_ADJUST_MODE_HEADER, Character.valueOf('H'));
        hashMap.put(Item.AUTO_ADJUST_MODE_VALUE, Character.valueOf('V'));
        hashMap.put(Item.AUTO_ADJUST_MODE_HEADERANDVALUE, Character.valueOf('A'));
        for (final Item item : new Item[]{Item.AUTO_ADJUST_MODE_NONE, Item.AUTO_ADJUST_MODE_HEADER, Item.AUTO_ADJUST_MODE_VALUE, Item.AUTO_ADJUST_MODE_HEADERANDVALUE}) {
            char c = ((Character)hashMap.get((Object)item)).charValue();
            final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(Menu.getString(item.name(), Character.valueOf(c)));
            jCheckBoxMenuItem.setMnemonic(c);
            if (item == Item.AUTO_ADJUST_MODE_NONE) {
                jCheckBoxMenuItem.setSelected(true);
            }
            this.menuItems.put(item, jCheckBoxMenuItem);
            arrayList.add(jCheckBoxMenuItem);
            buttonGroup.add(jCheckBoxMenuItem);
            jCheckBoxMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Menu.this.fireActionPerformed(jCheckBoxMenuItem, item);
                }
            });
        }
        return Menu.createJMenu(Item.AUTO_ADJUST_MODE.name(), 'M', arrayList.toArray(new JCheckBoxMenuItem[arrayList.size()]));
    }

    void addActionListener(ActionListener actionListener) {
        assert (actionListener != null);
        this.listenerList.add(ActionListener.class, actionListener);
    }

    void removeActionListener(ActionListener actionListener) {
        assert (actionListener != null);
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    void fireActionPerformed(Object object, Item item) {
        try {
            ActionEvent actionEvent = new ActionEvent(object, 1001, item.name());
            for (ActionListener actionListener : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
                actionListener.actionPerformed(actionEvent);
            }
        }
        catch (Exception exception) {
            WindowOutputProcessor.showErrorDialog(this.getParent(), exception);
        }
    }

    void setEnabledStates(boolean bl) {
        boolean bl2 = !bl;
        for (JMenuItem object : this.lockingTargets) {
            object.setEnabled(bl2);
        }
        boolean bl3 = bl;
        for (JMenuItem jMenuItem : this.unlockingTargets) {
            jMenuItem.setEnabled(bl3);
        }
    }

    private static JMenu createJMenu(String string, char c, JComponent ... jComponentArray) {
        JMenu jMenu = new JMenu(Menu.getString(string, Character.valueOf(c)));
        jMenu.setMnemonic(c);
        for (JComponent jComponent : jComponentArray) {
            jMenu.add(jComponent);
        }
        return jMenu;
    }

    private JMenuItem createJMenuItem(Item item, char c) {
        return this.createJMenuItem(item, c, null);
    }

    private JMenuItem createJMenuItem(Item item, char c, KeyStroke keyStroke) {
        return this.bind(new JMenuItem(Menu.getString(item.name(), Character.valueOf(c)), c), item, keyStroke);
    }

    private JCheckBoxMenuItem createJCheckBoxMenuItem(Item item, char c, KeyStroke keyStroke) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(Menu.getString(item.name(), Character.valueOf(c)));
        jCheckBoxMenuItem.setMnemonic(c);
        this.bind(jCheckBoxMenuItem, item, keyStroke);
        return jCheckBoxMenuItem;
    }

    private JMenuItem bind(JMenuItem jMenuItem, final Item item, KeyStroke keyStroke) {
        this.menuItems.put(item, jMenuItem);
        jMenuItem.setName(item.name());
        jMenuItem.setIcon(Resource.getImageIcon(String.format("menu-%s.png", new Object[]{item})));
        jMenuItem.setDisabledIcon(Resource.getImageIcon(String.format("menu-disabled-%s.png", new Object[]{item})));
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        jMenuItem.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.fireActionPerformed(actionEvent.getSource(), item);
            }
        });
        switch (item) {
            case CLOSE: 
            case QUIT: 
            case CUT: 
            case COPY: 
            case PASTE: 
            case SELECT_ALL: 
            case FIND: 
            case CLEAR_MESSAGE: 
            case REFRESH: 
            case WIDEN: 
            case NARROW: 
            case ADJUST_COLUMN_WIDTH: 
            case AUTO_ADJUST_MODE: 
            case EXECUTE: 
            case HISTORY_BACK: 
            case HISTORY_NEXT: 
            case CONNECT: 
            case DISCONNECT: 
            case SORT: 
            case EXPORT: {
                this.lockingTargets.add(jMenuItem);
                break;
            }
            case BREAK: {
                this.unlockingTargets.add(jMenuItem);
                break;
            }
        }
        return jMenuItem;
    }

    private static String getString(String string, Object ... objectArray) {
        return Resource.getString("Menu." + string, objectArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Item {
        NEW,
        CLOSE,
        QUIT,
        CUT,
        COPY,
        PASTE,
        SELECT_ALL,
        FIND,
        TOGGLE_FOCUS,
        CLEAR_MESSAGE,
        STATUS_BAR,
        INFO_TREE,
        COLUMN_NUMBER,
        ALWAYS_ON_TOP,
        REFRESH,
        WIDEN,
        NARROW,
        ADJUST_COLUMN_WIDTH,
        AUTO_ADJUST_MODE,
        AUTO_ADJUST_MODE_NONE,
        AUTO_ADJUST_MODE_HEADER,
        AUTO_ADJUST_MODE_VALUE,
        AUTO_ADJUST_MODE_HEADERANDVALUE,
        EXECUTE,
        BREAK,
        HISTORY_BACK,
        HISTORY_NEXT,
        RETRIEVE_HISTORY,
        CONNECT,
        DISCONNECT,
        ENCRYPTION_KEY,
        EDIT_CONNECTORS,
        SORT,
        IMPORT,
        EXPORT,
        HELP,
        ABOUT;

    }
}

