/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.command;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.Command;
import net.argius.stew.CommandException;
import net.argius.stew.Parameter;
import net.argius.stew.UsageException;

public final class Time
extends Command {
    private static final Logger log = LoggerFactory.getLogger(Time.class);

    public void execute(Connection connection, Parameter parameter) throws CommandException {
        int n;
        if (parameter.isEmpty(2)) {
            throw new UsageException(this.getUsage());
        }
        int n2 = 2;
        String string = parameter.get(n2);
        if (Character.isDigit(string.charAt(0))) {
            int n3;
            try {
                n3 = Integer.parseInt(string);
                if (n3 < 1) {
                    throw new UsageException(this.getUsage());
                }
                ++n2;
            }
            catch (NumberFormatException numberFormatException) {
                log.warn(numberFormatException);
                n3 = 1;
            }
            n = n3;
        } else {
            n = 1;
        }
        String string2 = parameter.getAll(n2);
        try {
            if (n > 1) {
                this.tryManyTimes(connection, string2, n);
            } else {
                this.tryOnce(connection, string2);
            }
        }
        catch (SQLException sQLException) {
            throw new CommandException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryOnce(Connection connection, String string) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("tryOnce");
        }
        Statement statement = connection.createStatement();
        try {
            long l;
            long l2;
            if (Time.isSelect(string)) {
                l2 = System.currentTimeMillis();
                ResultSet resultSet = statement.executeQuery(string);
                try {
                    l = System.currentTimeMillis();
                }
                finally {
                    resultSet.close();
                }
            } else {
                l2 = System.currentTimeMillis();
                statement.executeUpdate(string);
                l = System.currentTimeMillis();
            }
            if (log.isDebugEnabled()) {
                log.debug("beginning: " + l2);
                log.debug("      end: " + l);
            }
            this.outputMessage("Time.once", Float.valueOf((float)(l - l2) / 1000.0f));
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryManyTimes(Connection connection, String string, int n) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("tryManyTimes");
        }
        Statement statement = connection.createStatement();
        try {
            long[] lArray = new long[n];
            boolean bl = Time.isSelect(string);
            for (int i = 0; i < n; ++i) {
                long l;
                long l2;
                if (log.isTraceEnabled()) {
                    log.trace("beginning: " + i);
                }
                if (bl) {
                    l2 = System.currentTimeMillis();
                    ResultSet resultSet = statement.executeQuery(string);
                    try {
                        l = System.currentTimeMillis();
                    }
                    finally {
                        resultSet.close();
                    }
                } else {
                    l2 = System.currentTimeMillis();
                    statement.executeUpdate(string);
                    l = System.currentTimeMillis();
                }
                if (log.isTraceEnabled()) {
                    log.trace("      end: " + i);
                }
                lArray[i] = l - l2;
            }
            long l = 0L;
            long l3 = 0L;
            long l4 = Long.MAX_VALUE;
            for (long l5 : lArray) {
                l += l5;
                l3 = Math.max(l5, l3);
                l4 = Math.min(l5, l4);
            }
            this.outputMessage("Time.summary", Float.valueOf((float)l / 1000.0f), Float.valueOf((float)l / 1000.0f / (float)n), Float.valueOf((float)l3 / 1000.0f), Float.valueOf((float)l4 / 1000.0f));
        }
        finally {
            statement.close();
        }
    }
}

