/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Position;
import javax.swing.undo.UndoManager;
import net.argius.stew.ui.window.ActionUtility;
import net.argius.stew.ui.window.Resource;

final class ConsoleTextArea
extends JTextArea {
    private final UndoManager undoManager = ActionUtility.setUndoAction(this);
    private int homePosition;

    ConsoleTextArea() {
        ((AbstractDocument)this.getDocument()).setDocumentFilter(new PrivateDocumentFilter(this));
        ActionUtility actionUtility = new ActionUtility(this);
        int n = Resource.getMenuShortcutKeyMask();
        InputMap inputMap = this.getInputMap();
        actionUtility.bindAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2 = ConsoleTextArea.this.getCaretPosition();
                if (n2 != (n = ConsoleTextArea.this.getEndPosition())) {
                    ConsoleTextArea.this.setCaretPosition(n);
                    return;
                }
                ConsoleTextArea.this.fireActionPerformed();
            }
        }, "commit");
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "commit");
        inputMap.put(KeyStroke.getKeyStroke(77, n), "commit");
        actionUtility.bindAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ConsoleTextArea.this.getSelectedText() == null) {
                    ConsoleTextArea.this.sendBreak();
                } else {
                    DefaultEditorKit.CopyAction copyAction = new DefaultEditorKit.CopyAction();
                    copyAction.actionPerformed(actionEvent);
                }
            }
        }, "copyOrBreak", KeyStroke.getKeyStroke(67, n));
        actionUtility.bindAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleTextArea.this.sendBreak();
            }
        }, "break", KeyStroke.getKeyStroke(66, 512));
        actionUtility.bindAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleTextArea.this.insert("\n", ConsoleTextArea.this.getCaretPosition());
            }
        }, "newLine", KeyStroke.getKeyStroke(10, n));
        actionUtility.bindAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleTextArea.this.setCaretPosition(ConsoleTextArea.this.getHomePosition());
            }
        }, "home", KeyStroke.getKeyStroke(36, 0));
    }

    void addActionListener(ActionListener actionListener) {
        assert (actionListener != null);
        this.listenerList.add(ActionListener.class, actionListener);
    }

    void removeActionListener(ActionListener actionListener) {
        assert (actionListener != null);
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    void fireActionPerformed() {
        ActionEvent actionEvent = new ActionEvent(this, 0, this.getEditableText());
        for (ActionListener actionListener : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    boolean canUndo() {
        return this.undoManager.canUndo();
    }

    boolean canRedo() {
        return this.undoManager.canRedo();
    }

    public void append(String string) {
        super.append(string);
        this.homePosition += string.length();
        this.setCaretPosition(this.getEndPosition());
    }

    void replace(String string) {
        this.replaceRange(string, this.homePosition, this.getEndPosition());
    }

    void clear() {
        this.homePosition = 0;
        this.setText("");
    }

    String getEditableText() {
        try {
            return this.getText(this.homePosition, this.getEndPosition() - this.homePosition);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException);
        }
    }

    boolean isEditablePosition(int n) {
        return n >= this.homePosition;
    }

    int getHomePosition() {
        return this.homePosition;
    }

    int getEndPosition() {
        Document document = this.getDocument();
        Position position = document.getEndPosition();
        return position.getOffset() - 1;
    }

    void resetHomePosition() {
        this.undoManager.discardAllEdits();
        this.homePosition = this.getEndPosition();
    }

    void sendBreak() {
        this.append(Resource.getString("ConsoleTextArea.breakprompt", new Object[0]) + " ");
        this.resetHomePosition();
        this.validate();
    }

    public void updateUI() {
        if (this.getCaret() == null) {
            super.updateUI();
        } else {
            int n = this.getCaretPosition();
            super.updateUI();
            this.setCaretPosition(n);
        }
    }

    private static final class PrivateDocumentFilter
    extends DocumentFilter {
        private final ConsoleTextArea consoleTextArea;

        PrivateDocumentFilter(ConsoleTextArea consoleTextArea) {
            this.consoleTextArea = consoleTextArea;
        }

        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (this.consoleTextArea.isEditablePosition(n)) {
                super.insertString(filterBypass, n, string, attributeSet);
            }
        }

        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            if (this.consoleTextArea.isEditablePosition(n)) {
                super.remove(filterBypass, n, n2);
            }
        }

        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (this.consoleTextArea.isEditablePosition(n)) {
                super.replace(filterBypass, n, n2, string, attributeSet);
            }
        }
    }
}

