using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using StarEngine.Core;

namespace StarEngine.Tests.Core
{
    [TestFixture]
    public class ToneTest
    {
        [Test]
        public void TestMethods()
        {
            Tone t1 = new Tone(12, 34, 56);
            Tone t2 = new Tone(78, 90, 123, 45);
            Assert.AreEqual(12, t1.Red);
            Assert.AreEqual(34, t1.Green);
            Assert.AreEqual(56, t1.Blue);
            Assert.AreEqual(255, t1.Saturation);
            Assert.AreEqual(45, t2.Saturation);
            Assert.AreEqual("Tone(Red:12,Green:34,Blue:56,Saturation:255)", t1.ToString());
            Assert.AreEqual(new Tone(12, 34, 56).GetHashCode(), t1.GetHashCode());
        }

        [Test]
        public void TestOperators()
        {
            Tone t1 = new Tone(12, 34, 56);
            Tone t2 = new Tone(78, 90, 123, 45);
            Assert.IsTrue(new Tone(12, 34, 56) == t1);
            Assert.IsTrue(new Tone(78, 90, 123, 45) == t2);
            Assert.IsTrue(t1 != t2);
        }
    }
}
