using System;
using System.Collections.Generic;
using System.Text;
using Ruby;
using VALUE = System.Int32;

namespace StarEngine.Ruby
{
    internal static class SERubyConsts
    {
        public const string ModuleName = "StarEngine";

        private static Dictionary<string, VALUE> Cache = new Dictionary<string,int>();

        public static VALUE ForName(string name)
        {
            if (!Cache.ContainsKey(name))
                if (name.StartsWith("::"))
                    Cache[name] = RUBY.rb_eval_string(name);
                else
                    Cache[name] = RUBY.rb_eval_string(ModuleName + "::" + name);
            return Cache[name];
        }

        public static VALUE mStarEngine
        {
            get
            {
                if (_mStarEngine == RUBY.Qnil)
                    _mStarEngine = RUBY.rb_define_module(ModuleName);
                return _mStarEngine;
            }
        }
        private static VALUE _mStarEngine = RUBY.Qnil;
    }
}
