import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.sqlite.event.UpdateHook;
import org.sqlite.jdbc.JdbcConnection;

public class UpdateHookExample {

    @org.junit.Test
    public void example() throws ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.Driver");
        final String url = "jdbc:sqlite:mem:";
        final JdbcConnection conn = (JdbcConnection) DriverManager.getConnection(url);
        try {
            // new update hook
            final UpdateHook hook
                    = new UpdateHook() {
                            @Override
                            protected void xUpdate(int action, String dbName, String tableName, long rowId) {
                                System.out.printf("Called xUpdate(%d, '%s', '%s', %d)\n", action, dbName, tableName, rowId);
                            }
                        };
            // set update hook
            conn.setUpdateHook(hook);
            // begin transaction
            conn.setAutoCommit(false);
            
            final Statement stmt = conn.createStatement();
            String sql
                    = "CREATE TEMPORARY TABLE IF NOT EXISTS temp_tbl_1("
                        + "  ID INTEGER PRIMARY KEY AUTOINCREMENT"
                        + ", VALUE TEXT"
                    + ")";
            stmt.executeUpdate(sql);

            sql = "INSERT INTO temp_tbl_1 VALUES(1, 'One')";
            stmt.executeUpdate(sql);
            stmt.close();
            
            // rollback transaction
            conn.rollback();

            // clear update hook
            conn.clearUpdateHook();

        } finally {
            conn.close();
        }
    }

    public static void main(String[] args) throws Exception {
        new UpdateHookExample().example();
    }
}
