/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.io;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import org.sqlite.Blob;
import org.sqlite.io.Closeable;
import org.sqlite.io.WrappedIOException;

public class BlobOutputStream
extends OutputStream {
    private final Closeable owner;
    private final Blob blob;
    private long pos;
    private boolean isClosed = false;

    public BlobOutputStream(Closeable owner, Blob blob, long pos) throws SQLException {
        if (pos < 1L) {
            throw new SQLException("Should pos is greater than or equal to 1.", "90J08");
        }
        this.owner = owner;
        this.blob = blob;
        this.pos = pos - 1L;
    }

    public void close() {
        this.isClosed = true;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.validateStreamOpen();
        try {
            if (off == 0) {
                this.blob.write(b, len, (int)this.pos);
            } else {
                byte[] buff = new byte[len];
                System.arraycopy(buff, 0, b, off, len);
                this.blob.write(buff, len, (int)this.pos);
            }
            this.pos += (long)len;
        }
        catch (SQLException ex) {
            throw new WrappedIOException(ex);
        }
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    private void validateStreamOpen() throws IOException {
        if (this.isClosed || this.owner.isClosed()) {
            throw new IOException("Stream is already closed.");
        }
    }
}

