import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.sqlite.event.RollbackHook;
import org.sqlite.jdbc.JdbcConnection;

public class RollbackHookExample {

    @org.junit.Test
    public void example() throws ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.Driver");
        final String url = "jdbc:sqlite:mem:";
        final JdbcConnection conn = (JdbcConnection) DriverManager.getConnection(url);
        try {
            // new rollback hook
            final RollbackHook hook
                    = new RollbackHook() {
                            @Override
                            protected void xRollback() {
                                System.out.println("Called xRollback()");
                            }
                        };

            // set rollback hook
            conn.setRollbackHook(hook);
            // begin transaction
            conn.setAutoCommit(false);
            
            final Statement stmt = conn.createStatement();
            String sql
                    = "CREATE TEMPORARY TABLE IF NOT EXISTS temp_tbl_1("
                        + "  ID INTEGER PRIMARY KEY AUTOINCREMENT"
                        + ", VALUE TEXT"
                    + ")";
            stmt.executeUpdate(sql);

            sql = "INSERT INTO temp_tbl_1 VALUES(1, 'One')";
            stmt.executeUpdate(sql);
            stmt.close();
            
            // rollback transaction
            conn.rollback();

            // clear rollback hook
            conn.clearRollbackHook();

        } finally {
            conn.close();
        }
    }

    public static void main(String[] args) throws Exception {
        new RollbackHookExample().example();
    }
}
