/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.impl;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.MultipleMailBuilder;
import com.ozacc.mail.impl.AbstractXMLMailBuilder;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XMLMailBuilderImpl
extends AbstractXMLMailBuilder
implements MultipleMailBuilder {
    private static Log log = LogFactory.getLog((Class)XMLMailBuilderImpl.class);

    public Mail buildMail(String classPath) throws MailBuildException {
        Document doc = this.retrieveDocument(classPath);
        return this.buildMail(doc.getDocumentElement());
    }

    public Mail buildMail(File file) throws MailBuildException {
        Document doc = this.retrieveDocument(file);
        return this.buildMail(doc.getDocumentElement());
    }

    private Document retrieveDocument(String classPath) throws MailBuildException {
        try {
            return this.getDocumentFromClassPath(classPath);
        }
        catch (SAXException e) {
            throw new MailBuildException("XML\u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MailBuildException("XML\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    private Document retrieveDocument(File file) throws MailBuildException {
        try {
            return this.getDocumentFromFile(file);
        }
        catch (SAXException e) {
            throw new MailBuildException("XML\u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MailBuildException("XML\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    protected Mail buildMail(Element root) {
        Mail mail = new Mail();
        this.setReturnPath(root, mail);
        this.setFrom(root, mail);
        this.setRecipients(root, mail);
        this.setReplyTo(root, mail);
        this.setSubject(root, mail);
        this.setText(root, mail);
        this.setHtml(root, mail);
        return mail;
    }

    public Mail buildMail(String classPath, String mailId) throws MailBuildException {
        if (mailId == null || "".equals(mailId)) {
            throw new IllegalArgumentException("\u30e1\u30fc\u30ebID\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        Document doc = this.retrieveDocument(classPath);
        if ("-//OZACC//DTD MAIL//EN".equals(doc.getDoctype().getPublicId())) {
            throw new MailBuildException("\u6307\u5b9a\u3055\u308c\u305f\u30af\u30e9\u30b9\u30d1\u30b9\u306eXML\u306f\u30b7\u30f3\u30b0\u30eb\u30e1\u30fc\u30eb\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u3067\u3059\u3002[classPath='" + classPath + "']");
        }
        Element mailElem = doc.getElementById(mailId);
        return this.buildMail(mailElem);
    }

    public Mail buildMail(File file, String mailId) throws MailBuildException {
        if (mailId == null || "".equals(mailId)) {
            throw new IllegalArgumentException("\u30e1\u30fc\u30ebID\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        Document doc = this.retrieveDocument(file);
        if ("-//OZACC//DTD MAIL//EN".equals(doc.getDoctype().getPublicId())) {
            throw new MailBuildException("\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u306eXML\u306f\u30b7\u30f3\u30b0\u30eb\u30e1\u30fc\u30eb\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u3067\u3059\u3002[filePath='" + file.getAbsolutePath() + "']");
        }
        return this.buildMail(doc, mailId);
    }

    protected Mail buildMail(Document doc, String mailId) throws FactoryConfigurationError {
        Element mailElem = doc.getElementById(mailId);
        if (mailElem == null) {
            throw new MailBuildException("\u6307\u5b9a\u3055\u308c\u305fID[" + mailId + "]\u306e\u30e1\u30fc\u30eb\u30c7\u30fc\u30bf\u306f\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        }
        log.debug((Object)mailElem);
        return this.buildMail(mailElem);
    }
}

