/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.impl;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailAuthenticationException;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.MailException;
import com.ozacc.mail.MailSendException;
import com.ozacc.mail.NotConnectedException;
import com.ozacc.mail.SendMailPro;
import com.ozacc.mail.impl.MimeMessageBuilder;
import com.ozacc.mail.impl.OMLMimeMessage;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendMailProImpl
implements SendMailPro {
    public static final String DEFAULT_PROTOCOL = "smtp";
    public static final int DEFAULT_PORT = -1;
    public static final String DEFAULT_HOST = "localhost";
    public static final String JIS_CHARSET = "ISO-2022-JP";
    private static final String RETURN_PATH_KEY = "mail.smtp.from";
    private static Log log = LogFactory.getLog((Class)SendMailProImpl.class);
    private static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    private static final int DEFAULT_READ_TIMEOUT = 5000;
    private String protocol = "smtp";
    private String host = "localhost";
    private int port = -1;
    private String username;
    private String password;
    private String charset = "ISO-2022-JP";
    private String returnPath;
    private Session session;
    private Transport transport;
    private boolean connected;
    private String messageId;
    protected int connectionTimeout = 5000;
    protected int readTimeout = 5000;

    public SendMailProImpl() {
    }

    public SendMailProImpl(String host) {
        this();
        this.setHost(host);
    }

    public synchronized void connect() throws MailException {
        if (this.session == null) {
            this.initSession();
        }
        this.putOnReturnPath(this.returnPath);
        try {
            log.debug((Object)("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u306b\u63a5\u7d9a\u3057\u307e\u3059\u3002"));
            this.transport = this.session.getTransport(this.protocol);
            this.transport.connect(this.host, this.port, this.username, this.password);
        }
        catch (AuthenticationFailedException ex) {
            log.error((Object)("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u3078\u306e\u63a5\u7d9a\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002"), (Throwable)ex);
            throw new MailAuthenticationException(ex);
        }
        catch (MessagingException ex) {
            log.error((Object)("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u3078\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002"), (Throwable)ex);
            throw new MailSendException("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u3078\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
        }
        log.debug((Object)("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u306b\u63a5\u7d9a\u3057\u307e\u3057\u305f\u3002"));
        this.connected = true;
    }

    private void initSession() {
        Properties prop = this.initProperties();
        this.session = Session.getInstance((Properties)prop);
    }

    protected Properties initProperties() {
        Properties prop = new Properties();
        prop.put("mail.smtp.connectiontimeout", String.valueOf(this.connectionTimeout));
        prop.put("mail.smtp.timeout", String.valueOf(this.readTimeout));
        if (this.username != null && !"".equals(this.username) && this.password != null && !"".equals(this.password)) {
            prop.put("mail.smtp.auth", "true");
        }
        return prop;
    }

    public synchronized void disconnect() throws MailException {
        if (this.connected) {
            try {
                log.debug((Object)("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u3068\u306e\u63a5\u7d9a\u3092\u5207\u65ad\u3057\u307e\u3059\u3002"));
                this.transport.close();
                this.connected = false;
                log.debug((Object)("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u3068\u306e\u63a5\u7d9a\u3092\u5207\u65ad\u3057\u307e\u3057\u305f\u3002"));
            }
            catch (MessagingException ex) {
                log.error((Object)("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u3068\u306e\u63a5\u7d9a\u5207\u65ad\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002"), (Throwable)ex);
                throw new MailException("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u3068\u306e\u63a5\u7d9a\u5207\u65ad\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            }
            finally {
                this.releaseReturnPath(false);
            }
        } else {
            log.warn((Object)("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u3068\u306e\u63a5\u7d9a\u304c\u78ba\u7acb\u3055\u308c\u3066\u3044\u306a\u3044\u72b6\u614b\u3067\u3001\u63a5\u7d9a\u306e\u5207\u65ad\u304c\u30ea\u30af\u30a8\u30b9\u30c8\u3055\u308c\u307e\u3057\u305f\u3002"));
        }
    }

    private void putOnReturnPath(String returnPath) {
        if (returnPath != null) {
            this.session.getProperties().put(RETURN_PATH_KEY, returnPath);
            log.debug((Object)("Return-Path[" + returnPath + "]\u3092\u8a2d\u5b9a\u3057\u307e\u3057\u305f\u3002"));
        }
    }

    private void releaseReturnPath(boolean setGlobalReturnPathAgain) {
        this.session.getProperties().remove(RETURN_PATH_KEY);
        log.debug((Object)"Return-Path\u8a2d\u5b9a\u3092\u30af\u30ea\u30a2\u3057\u307e\u3057\u305f\u3002");
        if (setGlobalReturnPathAgain && this.returnPath != null) {
            this.putOnReturnPath(this.returnPath);
        }
    }

    public void send(MimeMessage mimeMessage) throws MailException {
        Address[] addresses;
        try {
            addresses = mimeMessage.getAllRecipients();
        }
        catch (MessagingException ex) {
            log.error((Object)"\u30e1\u30fc\u30eb\u306e\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)ex);
            throw new MailSendException("\u30e1\u30fc\u30eb\u306e\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
        }
        this.processSend(mimeMessage, addresses);
    }

    private void processSend(MimeMessage mimeMessage, Address[] addresses) {
        if (!this.connected) {
            log.error((Object)"SMTP\u30b5\u30fc\u30d0\u3078\u306e\u63a5\u7d9a\u304c\u78ba\u7acb\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            throw new NotConnectedException("SMTP\u30b5\u30fc\u30d0\u3078\u306e\u63a5\u7d9a\u304c\u78ba\u7acb\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        try {
            mimeMessage.setSentDate(new Date());
            mimeMessage.saveChanges();
            log.debug((Object)"\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3057\u307e\u3059\u3002");
            this.transport.sendMessage((Message)mimeMessage, addresses);
            log.debug((Object)"\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3057\u307e\u3057\u305f\u3002");
        }
        catch (MessagingException ex) {
            log.error((Object)"\u30e1\u30fc\u30eb\u306e\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)ex);
            throw new MailSendException("\u30e1\u30fc\u30eb\u306e\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
        }
    }

    public void send(Mail mail) throws MailException {
        if (mail.getReturnPath() != null) {
            this.sendMailWithReturnPath(mail);
        } else {
            this.sendMail(mail);
        }
    }

    private void sendMail(Mail mail) throws MailException {
        MimeMessage message = this.createMimeMessage();
        if (this.isMessageIdCustomized()) {
            mail.addHeader("Message-ID", ((OMLMimeMessage)message).getMessageId());
        }
        MimeMessageBuilder builder = new MimeMessageBuilder(message, this.charset);
        try {
            builder.buildMimeMessage(mail);
        }
        catch (UnsupportedEncodingException e) {
            throw new MailBuildException("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u306a\u3044\u6587\u5b57\u30b3\u30fc\u30c9\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002", e);
        }
        catch (MessagingException e) {
            throw new MailBuildException("MimeMessage\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
        if (mail.getEnvelopeTo().length > 0) {
            log.debug((Object)"\u30e1\u30fc\u30eb\u306fenvelope-to\u30a2\u30c9\u30ec\u30b9\u306b\u9001\u4fe1\u3055\u308c\u307e\u3059\u3002");
            this.processSend(message, (Address[])mail.getEnvelopeTo());
        } else {
            this.send(message);
        }
    }

    private synchronized void sendMailWithReturnPath(Mail mail) throws MailException {
        this.putOnReturnPath(mail.getReturnPath().getAddress());
        this.sendMail(mail);
        this.releaseReturnPath(true);
    }

    public MimeMessage createMimeMessage() {
        if (this.isMessageIdCustomized()) {
            return new OMLMimeMessage(this.session, this.messageId);
        }
        return new MimeMessage(this.session);
    }

    private boolean isMessageIdCustomized() {
        return this.messageId != null;
    }

    protected Session getSession() {
        return this.session;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getReturnPath() {
        return this.returnPath;
    }

    public void setReturnPath(String returnPath) {
        this.returnPath = returnPath;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setMessageId(String messageId) {
        if (messageId == null || messageId.length() < 1) {
            return;
        }
        String[] parts = messageId.split("@");
        if (parts.length > 2) {
            throw new IllegalArgumentException("messageId\u30d7\u30ed\u30d1\u30c6\u30a3\u306b'@'\u3092\u8907\u6570\u542b\u3080\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002[" + messageId + "]");
        }
        this.messageId = messageId;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }
}

