/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.impl;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.MultipleMailBuilder;
import com.ozacc.mail.VelocityMultipleMailBuilder;
import com.ozacc.mail.impl.DTDEntityResolver;
import com.ozacc.mail.impl.VelocityLogSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.log.LogSystem;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.xml.sax.EntityResolver;

public class JDomXMLMailBuilder
implements MultipleMailBuilder,
VelocityMultipleMailBuilder {
    private static Log log;
    private static String CACHE_KEY_SEPARATOR;
    private static String DEFAULT_MAIL_ID;
    protected LogSystem velocityLogSystem = new VelocityLogSystem();
    private boolean cacheEnabled = false;
    protected Map templateCache = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ozacc.mail.impl.JDomXMLMailBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        CACHE_KEY_SEPARATOR = "#";
        DEFAULT_MAIL_ID = "DEFAULT";
    }

    public Mail buildMail(String classPath) throws MailBuildException {
        Document doc = this.getDocumentFromClassPath(classPath);
        return this.build(doc.getRootElement());
    }

    public Mail buildMail(String classPath, VelocityContext context) throws MailBuildException {
        String templateXmlText;
        String cacheKey = String.valueOf(classPath) + CACHE_KEY_SEPARATOR + DEFAULT_MAIL_ID;
        if (!this.hasTemplateCache(cacheKey)) {
            Document doc = this.getDocumentFromClassPath(classPath);
            templateXmlText = this.cacheTemplateText(doc, cacheKey);
        } else {
            templateXmlText = this.getTemplateCache(cacheKey);
        }
        try {
            return this.build(templateXmlText, context);
        }
        catch (Exception e) {
            throw new MailBuildException("\u30e1\u30fc\u30eb\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    public Mail buildMail(File file) throws MailBuildException {
        Document doc = this.getDocumentFromFile(file);
        return this.build(doc.getRootElement());
    }

    public Mail buildMail(File file, VelocityContext context) throws MailBuildException {
        String templateXmlText;
        String cacheKey = String.valueOf(file.getAbsolutePath()) + CACHE_KEY_SEPARATOR + DEFAULT_MAIL_ID;
        if (!this.hasTemplateCache(cacheKey)) {
            Document doc = this.getDocumentFromFile(file);
            templateXmlText = this.cacheTemplateText(doc, cacheKey);
        } else {
            templateXmlText = this.getTemplateCache(cacheKey);
        }
        try {
            return this.build(templateXmlText, context);
        }
        catch (Exception e) {
            throw new MailBuildException("\u30e1\u30fc\u30eb\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    private String cacheTemplateText(Document doc, String cacheKey) {
        XMLOutputter output = new XMLOutputter();
        String templateXmlText = "<!DOCTYPE mail PUBLIC \"-//OZACC//DTD MAIL//EN\" \"http://www.ozacc.com/library/dtd/ozacc-mail.dtd\">\n" + output.outputString(doc.getRootElement());
        log.debug((Object)("\u4ee5\u4e0b\u306eXML\u30c7\u30fc\u30bf\u3092\u30ad\u30e3\u30c3\u30b7\u30e5\u3057\u307e\u3059\u3002\n" + templateXmlText));
        this.putTemplateCache(cacheKey, templateXmlText);
        return templateXmlText;
    }

    protected Document getDocumentFromClassPath(String classPath) throws MailBuildException {
        Document doc;
        InputStream is = this.getClass().getResourceAsStream(classPath);
        SAXBuilder builder = new SAXBuilder(true);
        builder.setEntityResolver((EntityResolver)new DTDEntityResolver());
        try {
            try {
                doc = builder.build(is);
            }
            catch (JDOMException e) {
                throw new MailBuildException("XML\u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new MailBuildException("XML\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return doc;
    }

    protected Document getDocumentFromFile(File file) {
        Document doc;
        SAXBuilder builder = new SAXBuilder(true);
        builder.setEntityResolver((EntityResolver)new DTDEntityResolver());
        try {
            doc = builder.build(file);
        }
        catch (JDOMException e) {
            throw new MailBuildException("XML\u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MailBuildException("XML\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
        return doc;
    }

    protected Mail build(Element mailElement) {
        Mail mail = new Mail();
        this.setFrom(mailElement, mail);
        this.setRecipients(mailElement, mail);
        this.setSubject(mailElement, mail);
        this.setBody(mailElement, mail);
        this.setReplyTo(mailElement, mail);
        this.setReturnPath(mailElement, mail);
        this.setHtml(mailElement, mail);
        return mail;
    }

    protected Mail build(String templateText, VelocityContext context) throws Exception, ParseErrorException, MethodInvocationException, ResourceNotFoundException, IOException, JDOMException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u30bd\u30fc\u30b9XML\u30c7\u30fc\u30bf\n" + templateText));
        }
        Velocity.setProperty((String)"runtime.log.logsystem", (Object)this.velocityLogSystem);
        Velocity.init();
        StringWriter w = new StringWriter();
        Velocity.evaluate((Context)context, (Writer)w, (String)"XML Mail Data", (String)templateText);
        if (log.isDebugEnabled()) {
            log.debug((Object)("VelocityContext\u3068\u30de\u30fc\u30b8\u5f8c\u306eXML\u30c7\u30fc\u30bf\n" + w.toString()));
        }
        StringReader reader = new StringReader(w.toString());
        SAXBuilder builder = new SAXBuilder(true);
        builder.setEntityResolver((EntityResolver)new DTDEntityResolver());
        Document mergedDoc = builder.build((Reader)reader);
        return this.build(mergedDoc.getRootElement());
    }

    protected void setReturnPath(Element root, Mail mail) {
        Element returnPathElem = root.getChild("returnPath");
        if (returnPathElem != null && returnPathElem.getAttributeValue("email") != null) {
            mail.setReturnPath(returnPathElem.getAttributeValue("email"));
        }
    }

    protected void setReplyTo(Element root, Mail mail) {
        Element replyToElem = root.getChild("replyTo");
        if (replyToElem != null && replyToElem.getAttributeValue("email") != null) {
            mail.setReplyTo(replyToElem.getAttributeValue("email"));
        }
    }

    protected void setBody(Element root, Mail mail) {
        Element bodyElem = root.getChild("body");
        if (bodyElem != null) {
            mail.setText(bodyElem.getTextTrim());
        }
    }

    protected void setHtml(Element root, Mail mail) {
        Element htmlElem = root.getChild("html");
        if (htmlElem != null) {
            mail.setHtmlText(htmlElem.getTextTrim());
        }
    }

    protected void setSubject(Element root, Mail mail) {
        Element subjectElem = root.getChild("subject");
        if (subjectElem != null) {
            mail.setSubject(subjectElem.getTextTrim());
        }
    }

    protected void setRecipients(Element root, Mail mail) {
        Element recipientsElem = root.getChild("recipients");
        if (recipientsElem == null) {
            return;
        }
        List recipientElemList = recipientsElem.getChildren();
        int i = 0;
        int max = recipientElemList.size();
        while (i < max) {
            Element e = (Element)recipientElemList.get(i);
            if ("to".equals(e.getName())) {
                if (e.getAttributeValue("email") != null) {
                    if (e.getAttributeValue("name") != null) {
                        mail.addTo(e.getAttributeValue("email"), e.getAttributeValue("name"));
                    } else {
                        mail.addTo(e.getAttributeValue("email"));
                    }
                }
            } else if ("cc".equals(e.getName())) {
                if (e.getAttributeValue("email") != null) {
                    if (e.getAttributeValue("name") != null) {
                        mail.addCc(e.getAttributeValue("email"), e.getAttributeValue("name"));
                    } else {
                        mail.addCc(e.getAttributeValue("email"));
                    }
                }
            } else if (e.getAttributeValue("email") != null) {
                mail.addBcc(e.getAttributeValue("email"));
            }
            ++i;
        }
    }

    protected void setFrom(Element root, Mail mail) {
        Element fromElem = root.getChild("from");
        if (fromElem != null && fromElem.getAttributeValue("email") != null) {
            if (fromElem.getAttributeValue("name") != null) {
                mail.setFrom(fromElem.getAttributeValue("email"), fromElem.getAttributeValue("name"));
            } else {
                mail.setFrom(fromElem.getAttributeValue("email"));
            }
        }
    }

    public synchronized void clearCache() {
        log.debug((Object)"\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u30ad\u30e3\u30c3\u30b7\u30e5\u3092\u30af\u30ea\u30a2\u3057\u307e\u3059\u3002");
        this.templateCache.clear();
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        if (!cacheEnabled) {
            this.clearCache();
        }
        this.cacheEnabled = cacheEnabled;
    }

    protected boolean hasTemplateCache(String key) {
        if (this.cacheEnabled) {
            return this.templateCache.containsKey(key);
        }
        return false;
    }

    protected void putTemplateCache(String key, String templateXmlText) {
        if (this.cacheEnabled) {
            log.debug((Object)("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u3092\u30ad\u30e3\u30c3\u30b7\u30e5\u3057\u307e\u3059\u3002[key='" + key + "']"));
            this.templateCache.put(key, templateXmlText);
        }
    }

    protected String getTemplateCache(String key) {
        if (this.hasTemplateCache(key)) {
            log.debug((Object)("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u30ad\u30e3\u30c3\u30b7\u30e5\u3092\u8fd4\u3057\u307e\u3059\u3002[key='" + key + "']"));
            return (String)this.templateCache.get(key);
        }
        return null;
    }

    public Mail buildMail(String classPath, VelocityContext context, String mailId) throws MailBuildException {
        String templateXmlText;
        if (mailId == null || "".equals(mailId)) {
            throw new IllegalArgumentException("\u30e1\u30fc\u30ebID\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        String cacheKey = String.valueOf(classPath) + CACHE_KEY_SEPARATOR + mailId;
        if (!this.hasTemplateCache(cacheKey)) {
            Document doc = this.getDocumentFromClassPath(classPath);
            templateXmlText = this.getAndCacheTemplateText(doc, mailId, cacheKey);
        } else {
            templateXmlText = this.getTemplateCache(cacheKey);
        }
        try {
            return this.build(templateXmlText, context);
        }
        catch (Exception e) {
            throw new MailBuildException("\u30e1\u30fc\u30eb\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    private String getAndCacheTemplateText(Document doc, String mailId, String cacheKey) throws MailBuildException {
        Element mailElem = this.getElementById(doc, mailId);
        XMLOutputter output = new XMLOutputter();
        String templateXmlText = output.outputString(mailElem);
        this.putTemplateCache(cacheKey, templateXmlText);
        return templateXmlText;
    }

    public Mail buildMail(File file, VelocityContext context, String mailId) throws MailBuildException {
        String templateXmlText;
        if (mailId == null || "".equals(mailId)) {
            throw new IllegalArgumentException("\u30e1\u30fc\u30ebID\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        String cacheKey = String.valueOf(file.getAbsolutePath()) + CACHE_KEY_SEPARATOR + mailId;
        if (!this.hasTemplateCache(cacheKey)) {
            Document doc = this.getDocumentFromFile(file);
            templateXmlText = this.getAndCacheTemplateText(doc, mailId, cacheKey);
        } else {
            templateXmlText = this.getTemplateCache(cacheKey);
        }
        try {
            return this.build(templateXmlText, context);
        }
        catch (Exception e) {
            throw new MailBuildException("\u30e1\u30fc\u30eb\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    public Mail buildMail(String classPath, String mailId) throws MailBuildException {
        Document doc = this.getDocumentFromClassPath(classPath);
        Element mailElem = this.getElementById(doc, mailId);
        return this.build(mailElem);
    }

    public Mail buildMail(File file, String mailId) throws MailBuildException {
        Document doc = this.getDocumentFromFile(file);
        Element mailElem = this.getElementById(doc, mailId);
        return this.build(mailElem);
    }

    private Element getElementById(Document doc, String id) {
        Element mailsElem = doc.getRootElement();
        List mailElemList = mailsElem.getChildren("mail");
        Iterator itr = mailElemList.iterator();
        while (itr.hasNext()) {
            Element mailElem = (Element)itr.next();
            String mailId = mailElem.getAttributeValue("id");
            if (!mailId.equals(id)) continue;
            return mailElem;
        }
        throw new MailBuildException("\u6307\u5b9a\u3055\u308c\u305fID[" + id + "]\u306e\u30e1\u30fc\u30eb\u30c7\u30fc\u30bf\u306f\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
    }
}

