/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.blog.feed.support.impl;

import com.ozacc.blog.feed.Channel;
import com.ozacc.blog.feed.Item;
import com.ozacc.blog.feed.ParseException;
import com.ozacc.blog.feed.impl.ChannelImpl;
import com.ozacc.blog.feed.impl.ItemImpl;
import com.ozacc.blog.feed.support.XmlInputStreamParser;
import com.sun.syndication.feed.synd.SyndCategory;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RomeXmlInputSreamParserImpl
implements XmlInputStreamParser {
    private static Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ozacc.blog.feed.support.impl.RomeXmlInputSreamParserImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public Channel parseXmlInputStream(InputStream is) throws ParseException {
        SyndFeed feed;
        SyndFeedInput input = new SyndFeedInput();
        try {
            feed = input.build((Reader)new XmlReader(is));
        }
        catch (IOException e) {
            throw new ParseException("XML\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("\u5bfe\u5fdc\u3057\u3066\u3044\u306a\u3044\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u306e\u30d5\u30a3\u30fc\u30c9\u3067\u3059\u3002", e);
        }
        catch (FeedException e) {
            throw new ParseException("\u30d5\u30a3\u30fc\u30c9\u306e\u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
        return this.buildChannelFromSyndFeed(feed);
    }

    protected Channel buildChannelFromSyndFeed(SyndFeed feed) {
        ChannelImpl channel = new ChannelImpl();
        channel.setCreator(feed.getAuthor());
        channel.setDate(feed.getPublishedDate());
        channel.setDescription(feed.getDescription());
        channel.setLanguage(feed.getLanguage());
        try {
            channel.setLink(new URL(feed.getLink()));
        }
        catch (MalformedURLException e) {
            log.warn((Object)"\u30d5\u30a3\u30fc\u30c9URL\u304c\u4e0d\u6b63\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u3002", (Throwable)e);
        }
        channel.setTitle(feed.getTitle());
        List cats = feed.getCategories();
        if (cats.size() > 0) {
            SyndCategory cat = (SyndCategory)cats.get(0);
            channel.setSubject(cat.getName());
        }
        List entries = feed.getEntries();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            SyndEntry entry = (SyndEntry)iter.next();
            channel.addItem(this.toItem(entry));
        }
        return channel;
    }

    protected Item toItem(SyndEntry entry) {
        ItemImpl item = new ItemImpl();
        item.setCreator(entry.getAuthor());
        item.setDate(entry.getPublishedDate());
        item.setTitle(entry.getTitle());
        try {
            item.setLink(new URL(entry.getLink()));
        }
        catch (MalformedURLException e) {
            log.warn((Object)"\u30d5\u30a3\u30fc\u30c9\u30a2\u30a4\u30c6\u30e0\u306eURL\u304c\u4e0d\u6b63\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u3002", (Throwable)e);
        }
        List cats = entry.getCategories();
        if (cats.size() > 0) {
            SyndCategory cat = (SyndCategory)cats.get(0);
            item.setSubject(cat.getName());
        }
        SyndContent content = entry.getDescription();
        String desc = content.getValue();
        item.setDescription(desc);
        return item;
    }
}

