package com.ozacc.blog.util;

/**
 * 
 * @since 1.2.7
 * @author Tomohiro Otsuka
 * @version $Id: XmlUtils.java 180 2005-07-22 09:26:25Z otsuka $
 */
public class XmlUtils {

	private XmlUtils() {}

	public static String escapeXml(String str) {
		if (str == null) {
			return null;
		}
		StringBuffer buf = new StringBuffer();
		for (int i = 0, num = str.length(); i < num; i++) {
			char c = str.charAt(i);
			switch (c) {
				case '&':
					buf.append("&amp;");
					break;
				case '<':
					buf.append("&lt;");
					break;
				case '>':
					buf.append("&gt;");
					break;
				case '"':
					buf.append("&quot;");
					break;
				default:
					buf.append(c);
					break;
			}
		}
		return buf.toString();
	}
}