package com.ozacc.blog.trackback.support;

import javax.servlet.http.HttpServletRequest;

import com.ozacc.blog.trackback.TrackBackPing;

/**
 * 受信トラックバックの文字コード検出インターフェース。
 * 
 * @author Tomohiro Otsuka
 * @version $Id: CharsetResolver.java 180 2005-07-22 09:26:25Z otsuka $
 */
public interface CharsetResolver {

	/**
	 * 指定された TrackBackPing と HttpServletRequest の情報から、
	 * トラックバックに使用されている文字コードを検出します。
	 * 検出できなかった場合はnullを返します。
	 * <p>
	 * 引数で渡される TrackBackPing インスタンスは、
	 * 実際に受信した TrackBackPing インスタンスのクローンなので、
	 * このメソッド内で修正しても他に影響を与えることはありません。
	 * 
	 * @param ping
	 * @param request
	 * @return トラックバックに使用されている文字コード。検出できなかった場合は null。
	 */
	String resolveCharset(TrackBackPing ping, HttpServletRequest request);

}