package com.ozacc.blog.ping;

/**
 * AsyncUpdatePingClientで非同期に更新Pingを送信した結果を処理するコールバックハンドラ。
 * 
 * @see AsyncUpdatePingClient
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: UpdatePingCallbackHandler.java 180 2005-07-22 09:26:25Z otsuka $
 */
public interface UpdatePingCallbackHandler {

	/**
	 * 非同期の更新Ping成功時に実行されるメソッド。
	 * 
	 * @param message サーバからのメッセージ
	 * @param pingUrl 更新Ping受付URL
	 */
	void handleResult(String message, String pingUrl);

	/**
	 * 非同期の更新Ping失敗時に実行されるメソッド。
	 * 
	 * @param ex UpdatePingException 実行時にスローされた例外
	 * @param pingUrl 更新Ping受付URL
	 */
	void handleError(UpdatePingException ex, String pingUrl);

}