package com.ozacc.blog.ping;

import java.io.Serializable;
import java.util.Vector;

/**
 * 更新Ping。
 * <p>
 * Blog名とBlog URL以外をパラメータとして追加したい場合は、
 * まずコンストラクタを呼び出した後に <code>addParameter()</code>
 * メソッドを使用します。
 * <pre>UpdatePing ping = new UpdatePing(myBlogName, myBlogUrl);
 *ping.addParameter(pingKey);
 *
 *updatePingClient.ping(pingUrl, ping);</pre>
 * 
 * @author Tomohiro Otsuka
 * @version $Id: UpdatePing.java 180 2005-07-22 09:26:25Z otsuka $
 */
public class UpdatePing implements Serializable {

	private Vector params;

	/**
	 * コンストラクタ。
	 */
	public UpdatePing() {
		params = new Vector();
	}

	/**
	 * コンストラクタ。
	 * 
	 * @param name Blog名
	 * @param url Blog URL
	 */
	public UpdatePing(String name, String url) {
		this();
		params.add(name);
		params.add(url);
	}

	/**
	 * 更新PingパラメータのVectorインスタンスを返します。
	 * 
	 * @return 更新PingパラメータのVectorインスタンス
	 */
	public Vector getParameters() {
		return params;
	}

	/**
	 * パラメータを追加します。
	 * 
	 * @param value 追加するパラメータ
	 */
	public void addParameter(String value) {
		params.add(value);
	}

	/**
	 * 全パラメータをクリアします。
	 */
	public void clearParameters() {
		params.clear();
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("[UpdatePing ");
		buf.append("blogName='" + params.get(0) + "', ");
		buf.append("url='" + params.get(1) + "']");

		return buf.toString();
	}
}