package com.ozacc.blog.ping;

/**
 * 更新Pingの送信を非同期で実行するクライアントのインターフェース。
 * <p>
 * 非同期呼び出しでは、実行結果を処理する AsyncCallbackHandler インターフェースを実装したクラスのインスタンスを引数に指定します。
 * 
 * @see UpdatePingCallbackHandler
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: AsyncUpdatePingClient.java 180 2005-07-22 09:26:25Z otsuka $
 */
public interface AsyncUpdatePingClient {

	/**
	 * 更新Pingを送信します。
	 * 送信は非同期で実行され、実行結果はAsyncCallbackHandlerインスタンスが処理します。
	 * <p>
	 * 更新Pingのパラメータには、UpdatePingオブジェクトを使用するので、
	 * Blog名とBlog URL以外に送信する必要がある場合は、UpdatePingにパラメータを追加してください。
	 * 
	 * @param pingUrl 更新Ping受付URL
	 * @param ping 更新Ping
	 * @param handler AsyncCallbackHandlerインターフェースの実装オブジェクト
	 */
	void ping(String pingUrl, UpdatePing ping, UpdatePingCallbackHandler handler);

	/**
	 * 複数のURLに対し、バッチ処理的に更新Pingを送信します。
	 * <p>
	 * 複数URLへの送信に対して、AsyncCallbackHandlerは同一インスタンスが利用されるので、
	 * スレッドセーフな作りになっている必要があります。
	 * 
	 * @param pingUrls 更新Ping受付URLの配列
	 * @param ping 更新Ping
	 * @param handler AsyncCallbackHandlerインターフェースの実装オブジェクト
	 */
	void ping(String[] pingUrls, UpdatePing ping, UpdatePingCallbackHandler handler);

	/**
	 * 更新 Ping を送信します。
	 * 送信は非同期で実行され、実行結果は AsyncCallbackHandler インスタンスが処理します。
	 * 
	 * @param pingUrl 更新Ping受付URL
	 * @param blogName 自分のBlog名
	 * @param blogUrl 自分のBlog URL
	 * @param handler AsyncCallbackHandlerインターフェースの実装オブジェクト
	 */
	void ping(String pingUrl, String blogName, String blogUrl, UpdatePingCallbackHandler handler);

}