package com.ozacc.blog.feed.support;

import java.io.InputStream;

import com.ozacc.blog.feed.Channel;
import com.ozacc.blog.feed.ParseException;

/**
 * RSSのXMLデータを示すInputSreamからChannelを生成するコールバック・インターフェース。
 * 
 * @see DOMXmlInputStreamParserImpl
 * @since 1.2
 * @author Tomohiro Otsuka
 * @version $Id: XmlInputStreamParser.java 197 2005-08-10 01:43:23Z otsuka $
 */
public interface XmlInputStreamParser {

	/**
	 * RSSのXMLデータを示すInputSreamをパースし、Channelインスタンスを生成して返します。
	 * 
	 * @param is RSSのXMLデータを示すInputSream
	 * @return 生成したChannelインスタンス
	 * @throws ParseException RSS XMLのパースに失敗した場合
	 */
	Channel parseXmlInputStream(InputStream is) throws ParseException;

}