package com.ozacc.blog.feed.impl;

import com.ozacc.blog.feed.Channel;
import com.ozacc.blog.feed.Item;
import com.ozacc.blog.util.DateFormat;


/**
 * Atom Feedの生成クラス。
 * 
 * @since 1.2.8
 * @author Tomohiro Otsuka
 * @version $Id: Atom_0_3_Builder.java 197 2005-08-10 01:43:23Z otsuka $
 */
public class Atom_0_3_Builder {

	public static String buildAtom(Channel c, String charset) {
		ChannelWrapper channel = new ChannelWrapper(c);
		StringBuffer buf = new StringBuffer(1000);
		buf.append("<?xml version=\"1.0\" encoding=\"").append(charset).append("\"?>\n");
		buf.append("<feed xmlns=\"http://purl.org/atom/ns#\" xml:lang=\"").append(channel.getLanguage()).append("\" version=\"0.3\">\n");
		buf.append("  <title>").append(channel.getTitle()).append("</title>\n");
		buf.append("  <tagline>").append(channel.getDescription()).append("</tagline>\n");
		if (channel.getLink() != null ) {
			buf.append("  <link rel=\"alternate\" type=\"text/html\" href=\"").append(channel.getLink().toString()).append("\" />\n");
		}
		if (channel.getDate() != null) {
			buf.append("  <modified>").append(DateFormat.format(channel.getDate())).append("</modified>\n");
		}
		buf.append("  <author>\n");
		buf.append("    <name>").append(channel.getCreator()).append("</name>\n");
		buf.append("  </author>\n");
		//buf.append("  <copyright>Copyright ").append(channel.getCreator()).append("</copyright>\n");
		//buf.append("  <generator>ozacc-blog library</generator>\n");
		for (int i = 0; i < channel.getItems().length; i++) {
			Item item = channel.getItems()[i];
			buildEntryElement(buf, item);
		}
		buf.append("</feed>\n");
		return buf.toString();
	}
	
	/**
	 * @param buf
	 * @param item 
	 */
	private static void buildEntryElement(StringBuffer buf, Item item) {
		buf.append("  <entry>\n");
		buf.append("    <title>").append(item.getTitle()).append("</title>\n");
		buf.append("    <link rel=\"alternate\" type=\"text/html\" href=\"").append(item.getLink()).append("\" />\n");
		if (item.getCreator() != null) {
			buf.append("    <author>\n");
			buf.append("      <name>").append(item.getCreator()).append("</name>\n");
			buf.append("    </author>\n");
		}
		buf.append("    <id>").append(item.getLink().toString()).append("</id>\n");
		buf.append("    <issued>").append(DateFormat.format(item.getDate())).append("</issued>\n");
		buf.append("    <modified>").append(DateFormat.format(item.getDate())).append("</modified>\n");
		buf.append("    <summary>").append(item.getDescription()).append("</summary>\n");
		buf.append("  </entry>\n");
	}

}
