package com.ozacc.blog.feed;

/**
 * フィードフォーマットを示すEnumクラス。
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: FeedFormat.java 197 2005-08-10 01:43:23Z otsuka $
 */
public class FeedFormat {

	/** RSS 1.0 */
	public static final FeedFormat RSS_1_0 = new FeedFormat("RSS 1.0");

	/** RSS 2.0 */
	public static final FeedFormat RSS_2_0 = new FeedFormat("RSS 2.0");

	/** ATOM 0.3 */
	public static final FeedFormat ATOM_0_3 = new FeedFormat("ATOM 0.3");

	private String format;

	/**
	 * Privateコンストラクタ。
	 * 
	 * @param version
	 */
	private FeedFormat(String version) {
		this.format = version;
	}

	/**
	 * フォーマットを示す文字列を返します。「RSS 1.0」、「RSS 2.0」といったフォーマットです。<br>
	 * ATOMの場合は「ATOM 0.3」を返します。
	 * 
	 * @return フィードフォーマット
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return format;
	}

}