package com.ozacc.blog.feed;

import java.net.URL;

/**
 * RSS Channelインターフェース。
 * <p>
 * Blogで使用される場合、通常そのBlogのメタデータを示します。
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: Channel.java 197 2005-08-10 01:43:23Z otsuka $
 */
public interface Channel extends DublinCoreMetadata {

	/**
	 * このChannelに属するItemを返します。
	 * 
	 * @return Channelに属するItemの配列
	 */
	Item[] getItems();

	/**
	 * 指定されたItemを追加します。
	 * 
	 * @param item 追加するItem
	 */
	void addItem(Item item);

	/**
	 * サイトのタイトルを返します。
	 * 
	 * @return サイトのタイトル
	 */
	String getTitle();

	void setTitle(String title);

	/**
	 * サイトのURLを返します。<br>
	 * 通常、BlogのトップページURLです。
	 * 
	 * @return サイトのURL
	 */
	URL getLink();

	void setLink(URL url);

	/**
	 * サイトの説明を返します。
	 * 
	 * @return サイトの説明
	 */
	String getDescription();

	void setDescription(String description);

	/**
	 * このChannelに属する新しいItemインスタンスを生成します。
	 * 
	 * @return 新しいItemインスタンス
	 */
	Item newItem();

}