/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.impl;

import java.util.Random;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;

public class OMLMimeMessage
extends MimeMessage {
    private static Random random = new Random();
    private String domainPartOfMessageId;
    private String messageId;

    public OMLMimeMessage(Session session, String domainPartOfMessageId) {
        super(session);
        String[] parts = domainPartOfMessageId.split("@");
        if (parts.length == 1) {
            this.domainPartOfMessageId = "@" + domainPartOfMessageId;
        } else if (parts.length == 2) {
            this.domainPartOfMessageId = parts[0].length() > 0 && !parts[0].startsWith(".") ? "." + domainPartOfMessageId : domainPartOfMessageId;
        }
        this.messageId = this.generateRandomMessageId();
    }

    protected void updateHeaders() throws MessagingException {
        super.updateHeaders();
        this.setHeader("Message-ID", this.messageId);
    }

    protected String generateRandomMessageId() {
        StringBuffer buf = new StringBuffer();
        buf.append("<");
        buf.append(System.currentTimeMillis()).append(".");
        int i = 0;
        while (i < 16) {
            long num = Math.abs(random.nextInt(10));
            buf.append(num);
            ++i;
        }
        buf.append(this.domainPartOfMessageId);
        buf.append(">");
        return buf.toString();
    }

    public String getMessageId() {
        return this.messageId;
    }
}

