package com.ozacc.mail.impl;

import java.util.Random;

import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;

/**
 * Message-IdإåޥǽMimeMessageΥ֥饹
 * 
 * @since 1.1
 * 
 * @author Tomohiro Otsuka
 * @version $Id: OMLMimeMessage.java,v 1.3.2.2 2005/01/29 23:09:00 otsuka Exp $
 */
public class OMLMimeMessage extends MimeMessage {

	private static Random random = new Random();

	private String domainPartOfMessageId;

	private String messageId;

	/**
	 * 󥹥ȥ饯
	 * 
	 * @param session 
	 * @param domainPartOfMessageId Message-IdإåΥɥᥤʬ˻Ѥʸ
	 */
	public OMLMimeMessage(Session session, String domainPartOfMessageId) {
		super(session);

		String[] parts = domainPartOfMessageId.split("@");
		if (parts.length == 1) {
			this.domainPartOfMessageId = "@" + domainPartOfMessageId;
		} else if (parts.length == 2) {
			if (parts[0].length() > 0 && !parts[0].startsWith(".")) {
				this.domainPartOfMessageId = "." + domainPartOfMessageId;
			} else {
				this.domainPartOfMessageId = domainPartOfMessageId;
			}
		}
		messageId = generateRandomMessageId();
	}

	/**
	 * Message-Idإå򤳤ǥåȤޤ
	 * <p>
	 * ͥڡ<br>
	 * <a href="http://java.sun.com/products/javamail/FAQ.html#msgid">http://java.sun.com/products/javamail/FAQ.html#msgid</a>
	 * 
	 * @see javax.mail.internet.MimeMessage#updateHeaders()
	 */
	protected void updateHeaders() throws MessagingException {
		super.updateHeaders();
		setHeader("Message-ID", messageId);
	}

	/**
	 * ॹ + 16 + messageIdץѥƥϢ뤷ʸ֤ޤ
	 * 
	 * @return ॹ + 16 + messageIdץѥƥϢ뤷ʸ
	 */
	protected String generateRandomMessageId() {
		StringBuffer buf = new StringBuffer();
		buf.append(System.currentTimeMillis()).append(".");
		for (int i = 0; i < 16; i++) {
			long num = Math.abs(random.nextInt(10));
			buf.append(num);
		}
		buf.append(domainPartOfMessageId);
		return buf.toString();
	}

	/**
	 * 줿Message-Id֤ޤ
	 * 
	 * @return 줿Message-Id
	 */
	public String getMessageId() {
		return messageId;
	}
}