package com.ozacc.mail;

import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.FileTypeMap;
import javax.activation.URLDataSource;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

import com.ozacc.mail.impl.ByteArrayDataSource;
import com.ozacc.mail.impl.Cp932;

/**
 * ᡼롣
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: Mail.java,v 1.10.2.6 2005/02/05 09:25:25 otsuka Exp $
 */
public class Mail {

	/** <code>ISO-2022-JP</code> */
	public static final String JIS_CHARSET = "ISO-2022-JP";

	public static final String DOCTYPE_PUBLIC = "-//OZACC//DTD MAIL//EN";

	public static final String DOCTYPE_SYSTEM = "http://www.ozacc.com/library/dtd/ozacc-mail.dtd";

	public static final String DOCTYPE_PUBLIC_MULTIPLE = "-//OZACC//DTD MULTIPLE MAILS//EN";

	public static final String DOCTYPE_SYSTEM_MULTIPLE = "http://www.ozacc.com/library/dtd/ozacc-multiple-mails.dtd";

	private String charset = JIS_CHARSET;

	protected String text;

	protected InternetAddress from;

	protected String subject;

	protected List to;

	protected List cc;

	protected List bcc;

	protected List envelopeTo;

	protected InternetAddress returnPath;

	protected InternetAddress replyTo;

	protected String importance;

	protected Map headers;

	protected String htmlText;

	protected List attachmentFiles;

	/**
	 * 󥹥ȥ饯
	 */
	public Mail() {}

	/**
	 * 󥹥ȥ饯
	 * 亹пͤ̾򥨥󥳡ɤ˻Ѥʸɤꤷޤ
	 * ǥեȤ<code>ISO-2022-JP</code>Ǥ
	 * <p>
	 * ܸĶѤ̾ѹɬפϤޤ
	 * 
	 * @param charset 󥳡ɤ˻Ѥʸ
	 */
	public Mail(String charset) {
		this();
		this.charset = charset;
	}

	/**
	 * ԡ󥹥ȥ饯
	 * ԡ(shallow copy)Ǥ
	 * 
	 * @since 1.0.2
	 * 
	 * @param original ԡMail󥹥
	 */
	public Mail(Mail original) {
		this.bcc = original.bcc;
		this.cc = original.cc;
		this.charset = original.charset;
		this.from = original.from;
		this.importance = original.importance;
		this.replyTo = original.replyTo;
		this.returnPath = original.returnPath;
		this.subject = original.subject;
		this.text = original.text;
		this.to = original.to;
		this.headers = original.headers;
		this.htmlText = original.htmlText;
		this.attachmentFiles = original.attachmentFiles;
		this.envelopeTo = original.envelopeTo;
	}

	/**
	 * 󥳡ɤ˻Ѥʸɤ֤ޤ
	 * 
	 * @return 󥳡ɤ˻Ѥʸ
	 */
	public String getCharset() {
		return charset;
	}

	/**
	 * ᡼ν٤򥻥åȤޤ
	 * ǻǽͤϡhighסnormalסlowפΤ줫Ǥ
	 * 
	 * @param importance ᡼ν١highסnormalסlowפΤ줫
	 * @throws IllegalArgumentException ǽͰʳꤵ줿
	 * 
	 * @see Mail.Importance
	 */
	public void setImportance(String importance) throws IllegalArgumentException {
		if ("high".equals(importance) || "normal".equals(importance) || "low".equals(importance)) {
			this.importance = importance;
		} else {
			throw new IllegalArgumentException("'" + importance + "'ϡ᡼٤ˤϻǤʤͤǤ");
		}
	}

	/**
	 * ᡼ν٤֤ޤ
	 * ͤϡhighסnormalסlowפΤ줫Ǥ
	 * 
	 * @return ᡼ν١highסnormalסlowפΤ줫
	 */
	public String getImportance() {
		return importance;
	}

	/**
	 * ᡼襢ɥ쥹ɲäޤ
	 * 
	 * @param address 襢ɥ쥹
	 */
	public void addTo(InternetAddress address) {
		if (to == null) {
			to = new ArrayList();
		}
		to.add(address);
	}

	/**
	 * ᡼襢ɥ쥹ɲäޤ
	 * 
	 * @param email 襢ɥ쥹
	 * @throws IllegalArgumentException ʥեޥåȤΥɥ쥹ꤵ줿
	 */
	public void addTo(String email) throws IllegalArgumentException {
		try {
			addTo(new InternetAddress(email));
		} catch (AddressException e) {
			throw new IllegalArgumentException(e.getMessage());
		}
	}

	/**
	 * ᡼̾ȥɥ쥹ɲäޤ
	 * ̾JIS_CHARSETǥ󥳡ɤޤ
	 * 
	 * @param email 襢ɥ쥹
	 * @param name ̾
	 * @throws IllegalArgumentException ʥեޥåȤΥɥ쥹ꤵ줿
	 */
	public void addTo(String email, String name) throws IllegalArgumentException {
		if (charset.equals(JIS_CHARSET)) {
			name = Cp932.toJIS(name);
		}
		try {
			addTo(new InternetAddress(email, name, charset));
		} catch (UnsupportedEncodingException e) {
			throw new IllegalArgumentException(e.getMessage());
		}
	}

	/**
	 * ᡼襢ɥ쥹֤ޤ
	 * 襢ɥ쥹⥻åȤƤʤȤ϶֤ޤ
	 * 
	 * @return 襢ɥ쥹
	 */
	public InternetAddress[] getTo() {
		if (to == null) {
			return new InternetAddress[0];
		}
		return (InternetAddress[])to.toArray(new InternetAddress[to.size()]);
	}

	/**
	 * CCɥ쥹ɲäޤ
	 * 
	 * @param address CCΥɥ쥹
	 */
	public void addCc(InternetAddress address) {
		if (cc == null) {
			cc = new ArrayList();
		}
		cc.add(address);
	}

	/**
	 * CCɥ쥹ɲäޤ
	 * 
	 * @param email CCΥɥ쥹
	 * @throws IllegalArgumentException ʥեޥåȤΥɥ쥹ꤵ줿
	 */
	public void addCc(String email) throws IllegalArgumentException {
		try {
			addCc(new InternetAddress(email));
		} catch (AddressException e) {
			throw new IllegalArgumentException(e.getMessage());
		}
	}

	/**
	 * CCΰ̾ȥɥ쥹ɲäޤ
	 * ̾JIS_CHARSETǥ󥳡ɤޤ
	 * 
	 * @param email CCΥɥ쥹
	 * @param name CCΰ̾
	 * @throws IllegalArgumentException ʥեޥåȤΥɥ쥹ꤵ줿
	 */
	public void addCc(String email, String name) throws IllegalArgumentException {
		if (charset.equals(JIS_CHARSET)) {
			name = Cp932.toJIS(name);
		}
		try {
			addCc(new InternetAddress(email, name, charset));
		} catch (UnsupportedEncodingException e) {
			throw new IllegalArgumentException(e.getMessage());
		}
	}

	/**
	 * ᡼CCɥ쥹֤ޤ
	 * CCɥ쥹⥻åȤƤʤȤ϶֤ޤ
	 * 
	 * @return CCɥ쥹
	 */
	public InternetAddress[] getCc() {
		if (cc == null) {
			return new InternetAddress[0];
		}
		return (InternetAddress[])cc.toArray(new InternetAddress[cc.size()]);
	}

	/**
	 * BCCɥ쥹ɲäޤ
	 * 
	 * @param address BCCΥɥ쥹
	 */
	public void addBcc(InternetAddress address) {
		if (bcc == null) {
			bcc = new ArrayList();
		}
		bcc.add(address);
	}

	/**
	 * BCCɥ쥹ɲäޤ
	 * 
	 * @param email BCCΥɥ쥹
	 * @throws IllegalArgumentException ʥեޥåȤΥɥ쥹ꤵ줿
	 */
	public void addBcc(String email) throws IllegalArgumentException {
		try {
			addBcc(new InternetAddress(email));
		} catch (AddressException e) {
			throw new IllegalArgumentException(e.getMessage());
		}
	}

	/**
	 * ᡼BCCɥ쥹֤ޤ
	 * BCCɥ쥹⥻åȤƤʤȤ϶֤ޤ
	 * 
	 * @return BCCɥ쥹
	 */
	public InternetAddress[] getBcc() {
		if (bcc == null) {
			return new InternetAddress[0];
		}
		return (InternetAddress[])bcc.toArray(new InternetAddress[bcc.size()]);
	}

	/**
	 * ᡼κпͥɥ쥹򥻥åȤޤ
	 * 
	 * @param address пͥɥ쥹
	 */
	public void setFrom(InternetAddress address) {
		from = address;
	}

	/**
	 * ᡼κпͥɥ쥹򥻥åȤޤ
	 * 
	 * @param email пͥɥ쥹
	 * @throws IllegalArgumentException ʥեޥåȤΥɥ쥹ꤵ줿
	 */
	public void setFrom(String email) throws IllegalArgumentException {
		try {
			setFrom(new InternetAddress(email));
		} catch (AddressException e) {
			throw new IllegalArgumentException(e.getMessage());
		}
	}

	/**
	 * ᡼κп̾ȥɥ쥹򥻥åȤޤ
	 * ̾JIS_CHARSETǥ󥳡ɤޤ
	 * 
	 * @param email пͥɥ쥹
	 * @param name п̾
	 * @throws IllegalArgumentException ʥեޥåȤΥɥ쥹ꤵ줿
	 */
	public void setFrom(String email, String name) throws IllegalArgumentException {
		if (charset.equals(JIS_CHARSET)) {
			name = Cp932.toJIS(name);
		}
		try {
			setFrom(new InternetAddress(email, name, charset));
		} catch (UnsupportedEncodingException e) {
			throw new IllegalArgumentException(e.getMessage());
		}
	}

	/**
	 * ᡼κпͥɥ쥹֤ޤåȤƤʤnull֤ޤ
	 * 
	 * @return ᡼κпͥɥ쥹
	 */
	public InternetAddress getFrom() {
		return from;
	}

	/**
	 * Return-Pathɥ쥹򥻥åȤޤ
	 * 
	 * @param address Return-Pathɥ쥹
	 */
	public void setReturnPath(InternetAddress address) {
		returnPath = address;
	}

	/**
	 * Return-Pathɥ쥹򥻥åȤޤ
	 * 
	 * @param email Return-Pathɥ쥹
	 * @throws IllegalArgumentException ʥեޥåȤΥɥ쥹ꤵ줿
	 */
	public void setReturnPath(String email) throws IllegalArgumentException {
		try {
			setReturnPath(new InternetAddress(email));
		} catch (AddressException e) {
			throw new IllegalArgumentException(e.getMessage());
		}
	}

	/**
	 * Return-Pathɥ쥹֤ޤ
	 * 
	 * @return Return-Pathɥ쥹
	 */
	public InternetAddress getReturnPath() {
		return returnPath;
	}

	/**
	 * ֿ襢ɥ쥹򥻥åȤޤ
	 * 
	 * @param address ֿ襢ɥ쥹
	 */
	public void setReplyTo(InternetAddress address) {
		replyTo = address;
	}

	/**
	 * ֿ襢ɥ쥹򥻥åȤޤ
	 * 
	 * @param email ֿ襢ɥ쥹
	 * @throws IllegalArgumentException ʥեޥåȤΥɥ쥹ꤵ줿
	 */
	public void setReplyTo(String email) throws IllegalArgumentException {
		try {
			setReplyTo(new InternetAddress(email));
		} catch (AddressException e) {
			throw new IllegalArgumentException(e.getMessage());
		}
	}

	/**
	 * ᡼ֿ襢ɥ쥹֤ޤåȤƤʤnull֤ޤ
	 * 
	 * @return ֿ襢ɥ쥹
	 */
	public InternetAddress getReplyTo() {
		return replyTo;
	}

	/**
	 * ᡼η֤̾ޤåȤƤʤ϶ʸ֤ޤ
	 * 
	 * @return ᡼η̾
	 */
	public String getSubject() {
		if (subject == null) {
			return "";
		}
		return subject;
	}

	/**
	 * ᡼η̾򥻥åȤޤ
	 * 
	 * @param subject ᡼η̾
	 */
	public void setSubject(String subject) {
		this.subject = subject;
	}

	/**
	 * ᡼ʸ֤ޤ
	 * ʸåȤƤʤ϶ʸ֤ޤ
	 * 
	 * @return ᡼ʸ
	 */
	public String getText() {
		if (text == null) {
			return "";
		}
		return text;
	}

	/**
	 * ᡼ʸ򥻥åȤޤ
	 * 
	 * @param text ᡼ʸ
	 */
	public void setText(String text) {
		this.text = text;
	}

	/**
	 * ᡼إåǤդΥإåեɤɲäޤ
	 * ǤեإåϡX-key: valueפΥեޥåȤǥ᡼إåȤ߹ޤޤ<br>
	 * Ʊإå̾ͤϾ񤭤ޤ
	 *  
	 * @param name Ǥեإå̾Ƭ"X-"ǻϤޤäƤʤСưŪͿޤ
	 * @param value Ǥեإå
	 */
	public void addXHeader(String name, String value) {
		if (headers == null) {
			headers = new HashMap();
		}
		if (name.startsWith("X-")) {
			headers.put(name, value);
		} else {
			headers.put("X-" + name, value);
		}
	}

	/**
	 * ᡼إåǤդΥإåեɤɲäޤ<br>
	 * Ʊإå̾ͤϾ񤭤ޤ
	 * 
	 * @since 1.2
	 * @param name Ǥեإå̾
	 * @param value Ǥեإå
	 */
	public void addHeader(String name, String value) {
		if (headers == null) {
			headers = new HashMap();
		}
		headers.put(name, value);
	}

	/**
	 * ᡼Ǥեإå̾ͤMap󥹥󥹤֤ޤ
	 * Ǥեإå⥻åȤƤʤȤnull֤ޤ
	 * <p>
	 * Map󥹥󥹤ؤνϤǤޤ(unmodifiableMapˤʤäƤޤ)
	 * 
	 * @return ᡼Ǥեإå̾ͤMap󥹥󥹡ޤnull
	 */
	public Map getHeaders() {
		if (headers == null) {
			return null;
		}
		return Collections.unmodifiableMap(headers);
	}

	/**
	 * ᡼ƤϤޤ<br>
	 * ᡼Υ˻եޥåȤǽϤޤ
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buf = new StringBuffer(1000);
		buf.append("Mail\n");
		buf.append("Return-Path: ").append(returnPath).append("\n");
		buf.append("From: ").append(from != null ? from.toUnicodeString() : null).append("\n");
		buf.append("To: ").append(arrayToCommaDelimitedString(to)).append("\n");
		buf.append("Cc: ").append(arrayToCommaDelimitedString(cc)).append("\n");
		buf.append("Bcc: ").append(arrayToCommaDelimitedString(bcc)).append("\n");
		buf.append("Subject: ").append(subject).append("\n");

		if (headers != null) {
			for (Iterator itr = headers.keySet().iterator(); itr.hasNext();) {
				String header = (String)itr.next();
				String value = (String)headers.get(header);
				buf.append(header).append(": ").append(value).append("\n");
			}
		}

		buf.append("\n");
		buf.append(text);

		if (htmlText != null) {
			buf.append("\n\n-----\n\n");
			buf.append(htmlText);
		}

		return buf.toString();
	}

	/**
	 * ꤵ줿ꥹȤǤ򥳥޶ڤʸѴޤ
	 * nullꤵ줿ϡnullʸ֤ޤ
	 * 
	 * @param list
	 * @return ꥹǤΥ޶ڤʸ
	 */
	protected String arrayToCommaDelimitedString(List list) {
		if (list == null) {
			return "null";
		} else {
			StringBuffer sb = new StringBuffer();
			for (int i = 0, num = list.size(); i < num; i++) {
				if (i > 0) {
					sb.append(", ");
				}
				sb.append(((InternetAddress)list.get(i)).toUnicodeString());
			}
			return sb.toString();
		}
	}

	/**
	 * åȤƤ襢ɥ쥹(Toɥ쥹)ƥꥢޤ
	 *
	 * @since 1.0.2
	 */
	public void clearTo() {
		to = null;
	}

	/**
	 * åȤƤCCɥ쥹ƥꥢޤ
	 *
	 * @since 1.0.2
	 */
	public void clearCc() {
		cc = null;
	}

	/**
	 * åȤƤBCCɥ쥹ƥꥢޤ
	 *
	 * @since 1.0.2
	 */
	public void clearBcc() {
		bcc = null;
	}

	/**
	 * HTMLʸ򥻥åȤޤ
	 * 
	 * @since 1.1
	 * 
	 * @param htmlText HTMLʸ
	 */
	public void setHtmlText(String htmlText) {
		this.htmlText = htmlText;
	}

	/**
	 * HTMLʸ֤ޤ
	 * 
	 * @since 1.1
	 * 
	 * @return HTMLʸޤnull
	 */
	public String getHtmlText() {
		return htmlText;
	}

	/**
	 * ꤵ줿եźդޤ
	 * źեե̾ˤϡꤵ줿ե̾Ѥޤ
	 * Υե̾ŬڤʳĥҤդƤɬפޤ
	 * 
	 * @since 1.1
	 * 
	 * @param file źեե
	 */
	public void addFile(File file) {
		if (attachmentFiles == null) {
			initAttachmentFiles();
		}
		addFile(file, file.getName());
	}

	/**
	 * ꤵ줿եźդޤ
	 * ꤹե̾ˤŬڤʳĥҤդƤɬפޤ
	 * 
	 * @since 1.1
	 * 
	 * @param file źեե
	 * @param fileName ե̾
	 */
	public void addFile(File file, String fileName) {
		if (attachmentFiles == null) {
			initAttachmentFiles();
		}
		attachmentFiles.add(new AttachmentFile(fileName, file));
	}

	/**
	 * ꤵ줿URLΥեźդޤ
	 * ꤹե̾ˤŬڤʳĥҤդƤɬפޤ
	 * 
	 * @since 1.1
	 * 
	 * @param url źեե
	 * @param fileName ե̾
	 */
	public void addFile(URL url, String fileName) {
		if (attachmentFiles == null) {
			initAttachmentFiles();
		}
		attachmentFiles.add(new AttachmentFile(fileName, url));
	}

	/**
	 * ꤵ줿InputStreamեȤźդޤ
	 * ꤹե̾ˤŬڤʳĥҤդƤɬפޤ
	 * 
	 * @since 1.1
	 * 
	 * @param is źեեInputStream
	 * @param fileName ե̾
	 */
	public void addFile(InputStream is, String fileName) {
		if (attachmentFiles == null) {
			initAttachmentFiles();
		}
		attachmentFiles.add(new AttachmentFile(fileName, is));
	}

	/**
	 * attachmentFilesץѥƥ
	 */
	private void initAttachmentFiles() {
		attachmentFiles = new ArrayList();
	}

	/**
	 * źեե֤ޤ
	 * źեե뤬åȤƤʤϡ֤ޤ
	 * 
	 * @since 1.1
	 * 
	 * @return źեե󡣤ޤ϶
	 */
	public AttachmentFile[] getAttachmentFiles() {
		if (attachmentFiles == null) {
			return new AttachmentFile[0];
		}
		return (AttachmentFile[])attachmentFiles
				.toArray(new AttachmentFile[attachmentFiles.size()]);
	}

	/**
	 * HTMLʸåȤƤ뤫ɤȽꤷޤ
	 * 
	 * @since 1.1
	 * 
	 * @return HTMLʸåȤƤ true
	 */
	public boolean isHtmlMail() {
		return (htmlText != null);
	}

	/**
	 * ե뤬źդƤ뤫ɤȽꤷޤ
	 * 
	 * @since 1.1
	 * 
	 * @return ե뤬źդƤ true
	 */
	public boolean isFileAttached() {
		return attachmentFiles != null && attachmentFiles.size() > 0;
	}

	/**
	 * ޥѡȡ᡼뤫ɤȽꤷޤ<br>
	 * HTMLʸåȤƤ뤫ե뤬źդƤ true ֤ޤ
	 * <p>
	 * : ȽꤵޥѡȤϡ̩ʰ̣ǤΥޥѡȤǤϤޤ
	 * 
	 * @since 1.1
	 * 
	 * @return ޥѡȡ᡼ξ true
	 */
	public boolean isMultipartMail() {
		return isHtmlMail() || isFileAttached();
	}

	/**
	 * åȤƤźեեƥꥢޤ
	 * 
	 * @since 1.1
	 */
	public void clearFile() {
		initAttachmentFiles();
	}

	/**
	 * envelope-toΰ襢ɥ쥹ɲäޤ
	 * <p>
	 * envelope-toɥ쥹åȤƤ硢envelope-toΥɥ쥹ˤΤߥ᡼
	 * ToCcBccɥ쥹ˤϼºݤˤޤ
	 * 
	 * @since 1.2
	 * @param address
	 */
	public void addEnvelopeTo(InternetAddress address) {
		if (envelopeTo == null) {
			envelopeTo = new ArrayList();
		}
		envelopeTo.add(address);
	}

	/**
	 * envelope-toΰ襢ɥ쥹ɲäޤ
	 * <p>
	 * envelope-toɥ쥹åȤƤ硢envelope-toΥɥ쥹ˤΤߥ᡼
	 * ToCcBccɥ쥹ˤϼºݤˤޤ
	 * 
	 * @since 1.2
	 * @param email
	 * @throws IllegalArgumentException ʥեޥåȤΥɥ쥹ꤵ줿
	 */
	public void addEnvelopeTo(String email) {
		try {
			addEnvelopeTo(new InternetAddress(email));
		} catch (AddressException e) {
			throw new IllegalArgumentException(e.getMessage());
		}
	}

	/**
	 * envelope-toΰ襢ɥ쥹ɲäޤ
	 * <p>
	 * envelope-toɥ쥹åȤƤ硢envelope-toΥɥ쥹ˤΤߥ᡼
	 * ToCcBccɥ쥹ˤϼºݤˤޤ
	 * 
	 * @since 1.2
	 * @param addresses
	 */
	public void addEnvelopeTo(InternetAddress[] addresses) {
		for (int i = 0; i < addresses.length; i++) {
			addEnvelopeTo(addresses[i]);
		}
	}

	/**
	 * envelope-toΰ襢ɥ쥹ɲäޤ
	 * <p>
	 * envelope-toɥ쥹åȤƤ硢envelope-toΥɥ쥹ˤΤߥ᡼
	 * ToCcBccɥ쥹ˤϼºݤˤޤ
	 * 
	 * @since 1.2
	 * @param emails
	 * @throws IllegalArgumentException ʥեޥåȤΥɥ쥹ꤵ줿
	 */
	public void addEnvelopeTo(String[] emails) {
		for (int i = 0; i < emails.length; i++) {
			addEnvelopeTo(emails[i]);
		}
	}

	/**
	 * åȤƤenvelope-toɥ쥹ƥꥢޤ
	 *
	 * @since 1.2
	 */
	public void clearEnvelopeTo() {
		envelopeTo = null;
	}

	/**
	 * envelope-toɥ쥹֤ޤ
	 * envelope-toɥ쥹⥻åȤƤʤȤ϶֤ޤ
	 * 
	 * @since 1.2
	 * @return envelope-toɥ쥹
	 */
	public InternetAddress[] getEnvelopeTo() {
		if (envelopeTo == null) {
			return new InternetAddress[0];
		}
		return (InternetAddress[])envelopeTo.toArray(new InternetAddress[envelopeTo.size()]);
	}

	/**
	 * źեե롣
	 * <p>
	 * ᡼(ReceivedMail)źեեϡ<code>getFile()</code>᥽åɤǼޤ
	 * <code>getInputStream()</code><code>getUrl()</code>᥽åɤnull֤ޤ
	 * ᡼ФƤϡ<code>ReceivedMail.getFiles()</code>᥽åɤȤźեե
	 * <code>File</code>󥹥뤳ȤǤޤ
	 * 
	 * @since 1.1
	 * @author Tomohiro Otsuka
	 * @version $Id: Mail.java,v 1.10.2.6 2005/02/05 09:25:25 otsuka Exp $
	 */
	public class AttachmentFile {

		private String name;

		private File file;

		private InputStream is;

		private URL url;

		/**
		 * ե̾ȥեꤷơΥ饹Υ󥿥󥹤ޤ
		 * ե̾ˤŬڤʳĥҤդƤɬפޤ
		 * 
		 * @param name ᡼ɽե̾
		 * @param file źեե
		 */
		public AttachmentFile(String name, File file) {
			this.name = name;
			this.file = file;
		}

		/**
		 * ե̾InputStreamꤷơΥ饹Υ󥿥󥹤ޤ
		 * ե̾ˤŬڤʳĥҤդƤɬפޤ
		 * 
		 * @param name ᡼ɽե̾
		 * @param is źեեInputStream
		 */
		public AttachmentFile(String name, InputStream is) {
			this.name = name;
			this.is = is;
		}

		/**
		 * ե̾ȥեURLꤷơΥ饹Υ󥿥󥹤ޤ
		 * ե̾ˤŬڤʳĥҤդƤɬפޤ
		 * 
		 * @param name ᡼ɽե̾
		 * @param url źեեΥURL
		 */
		public AttachmentFile(String name, URL url) {
			this.name = name;
			this.url = url;
		}

		/**
		 * źեեDataSource󥹥󥹤֤ޤ
		 * 
		 * @return źեեDataSource󥹥
		 */
		public DataSource getDataSource() {
			if (file != null) {
				return new FileDataSource(file);
			}

			if (url != null) {
				return new URLDataSource(url);
			}

			// InputStreamDataSource
			String contentType = FileTypeMap.getDefaultFileTypeMap().getContentType(name);
			return new ByteArrayDataSource(is, contentType);
		}

		/**
		 * źեե֤̾ޤ
		 * 
		 * @return źեե̾
		 */
		public String getName() {
			return name;
		}

		/**
		 * @return åȤ줿ե롣ޤnull
		 */
		public File getFile() {
			return file;
		}

		/**
		 * @return åȤ줿InputStreamޤnull
		 */
		public InputStream getInputStream() {
			return is;
		}

		/**
		 * @return åȤ줿URLޤnull
		 */
		public URL getUrl() {
			return url;
		}
	}

	/**
	 * ᡼ν١Τߤ
	 * 
	 * @author Tomohiro Otsuka
	 * @version $Id: Mail.java,v 1.10.2.6 2005/02/05 09:25:25 otsuka Exp $
	 */
	public static class Importance {

		/** ١ֹ */
		public static final String HIGH = "high";

		/** ١ */
		public static final String NORMAL = "normal";

		/** ١ */
		public static final String LOW = "low";

	}
}