package com.ozacc.mail.mailet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.ozacc.mail.fetch.FetchMailPro;
import com.ozacc.mail.fetch.ReceivedMail;

/**
 * ᡼μMailetεưԤ饹
 * 
 * @since 1.2
 * @author Tomohiro Otsuka
 * @version $Id: MailetRunner.java,v 1.1.2.3 2005/01/23 06:47:01 otsuka Exp $
 */
public class MailetRunner {

	private List mailetWrapperList;

	private FetchMailPro fetchMailPro;

	/**
	 * 󥹥ȥ饯
	 */
	public MailetRunner() {
		mailetWrapperList = new ArrayList();
	}

	/**
	 * ᡼MailetεưԤޤ
	 */
	public void run() {
		fetchMailPro.connect();
		try {
			int count = fetchMailPro.getMailCount();
			for (int i = 1; i <= count; i++) {
				ReceivedMail mail = fetchMailPro.getMail(i);
				processMail(mail);
			}
		} finally {
			if (fetchMailPro.isConnected()) {
				fetchMailPro.disconnect();
			}
		}
	}

	/**
	 * ꤵ줿᡼ФMailetŬѤޤ
	 * 
	 * @param mail MailetUnitϤ᡼
	 */
	private void processMail(ReceivedMail mail) {
		for (Iterator itr = mailetWrapperList.iterator(); itr.hasNext();) {
			MailetWrapper mailetWrapper = (MailetWrapper)itr.next();
			mailetWrapper.execute(mail);
		}
	}

	/**
	 * ᡼μ˻ѤFetchMailPro󥿡եμ󥹥󥹤򥻥åȤޤ
	 * 
	 * @param fetchMailPro FetchMailPro󥿡եμ󥹥
	 */
	public void setFetchMailPro(FetchMailPro fetchMailPro) {
		this.fetchMailPro = fetchMailPro;
	}

	/**
	 * ¹ԤMailetMailetWrapperꥹȤ򥻥åȤޤ
	 * 
	 * @param mailetWrapperList ¹ԤMailetMailetWrapperꥹ
	 */
	public void setMailetWrapperList(List mailetWrapperList) {
		this.mailetWrapperList = mailetWrapperList;
	}
}