package com.ozacc.mail.impl;

import java.io.File;

import javax.mail.internet.InternetAddress;

import junit.framework.TestCase;

import org.apache.log4j.BasicConfigurator;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.MultipleMailBuilder;

/**
 * 
 * @since 1.0.1
 * @author Tomohiro Otsuka
 * @version $Id: XMLMailBuilderImplTest.java,v 1.6.2.1 2005/01/21 22:17:27 otsuka Exp $
 */
public class XMLMailBuilderImplTest extends TestCase {

	private MultipleMailBuilder builder;

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		BasicConfigurator.configure();

		builder = new XMLMailBuilderImpl();
	}

	/**
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
		BasicConfigurator.resetConfiguration();
	}

	public final void testBuildMailCDATA() throws Exception {
		String classPath = "/com/ozacc/mail/test-mail6-cdata.xml";

		String expectedBody = "CDATAΥƥȤǤ";

		Mail result = builder.buildMail(classPath);

		assertEquals(expectedBody, result.getText());
	}

	public final void testBuildMultipartMailFromFile() throws Exception {
		String path = "src/test/com/ozacc/mail/test-mail1.xml";
		File file = new File(path);

		String subject = "XMLMailBuilderΥƥȥ";
		String text = "Ԥޤ\nԤޤ\nƥȤ";
		String htmlText = "<html><body>HTMLƥ</body></html>";

		InternetAddress from = new InternetAddress("from@example.com", "п");
		InternetAddress returnPath = new InternetAddress("return@example.com");
		InternetAddress replyTo = new InternetAddress("reply@example.com");

		InternetAddress to1 = new InternetAddress("to1@example.com", "1");
		InternetAddress to2 = new InternetAddress("to2@example.com");

		InternetAddress cc1 = new InternetAddress("cc1@example.com", "CC1");
		InternetAddress cc2 = new InternetAddress("cc2@example.com");

		InternetAddress bcc = new InternetAddress("bcc@example.com");

		Mail result = builder.buildMail(file);

		System.out.println(result);

		assertEquals(subject, result.getSubject());
		assertEquals(text, result.getText());

		assertTrue(result.isMultipartMail());
		assertTrue(result.isHtmlMail());
		assertEquals(htmlText, result.getHtmlText());

		assertEquals(from, result.getFrom());
		assertEquals(returnPath, result.getReturnPath());
		assertEquals(replyTo, result.getReplyTo());

		InternetAddress[] tos = result.getTo();
		assertEquals(2, tos.length);
		assertEquals(to1, tos[0]);
		assertEquals(to2, tos[1]);

		InternetAddress[] ccs = result.getCc();
		assertEquals(2, ccs.length);
		assertEquals(cc1, ccs[0]);
		assertEquals(cc2, ccs[1]);

		InternetAddress[] bccs = result.getBcc();
		assertEquals(1, bccs.length);
		assertEquals(bcc, bccs[0]);
	}

	/*
	 * Class under test for Mail buildMail(String)
	 */
	public final void testBuildMailFromClassPath() throws Exception {
		String classPath = "/com/ozacc/mail/test-mail1.xml";

		String subject = "XMLMailBuilderΥƥȥ";
		String text = "Ԥޤ\nԤޤ\nƥȤ";

		InternetAddress from = new InternetAddress("from@example.com", "п");
		InternetAddress returnPath = new InternetAddress("return@example.com");
		InternetAddress replyTo = new InternetAddress("reply@example.com");

		InternetAddress to1 = new InternetAddress("to1@example.com", "1");
		InternetAddress to2 = new InternetAddress("to2@example.com");

		InternetAddress cc1 = new InternetAddress("cc1@example.com", "CC1");
		InternetAddress cc2 = new InternetAddress("cc2@example.com");

		InternetAddress bcc = new InternetAddress("bcc@example.com");

		Mail result = builder.buildMail(classPath);

		assertEquals(subject, result.getSubject());
		assertEquals(text, result.getText());

		assertEquals(from, result.getFrom());
		assertEquals(returnPath, result.getReturnPath());
		assertEquals(replyTo, result.getReplyTo());

		InternetAddress[] tos = result.getTo();
		assertEquals(2, tos.length);
		assertEquals(to1, tos[0]);
		assertEquals(to2, tos[1]);

		InternetAddress[] ccs = result.getCc();
		assertEquals(2, ccs.length);
		assertEquals(cc1, ccs[0]);
		assertEquals(cc2, ccs[1]);

		InternetAddress[] bccs = result.getBcc();
		assertEquals(1, bccs.length);
		assertEquals(bcc, bccs[0]);
	}

	/*
	 * Class under test for Mail buildMail(File)
	 */
	public final void testBuildMailFile() throws Exception {
		String path = "src/test/com/ozacc/mail/test-mail1.xml";
		File file = new File(path);

		String subject = "XMLMailBuilderΥƥȥ";
		String text = "Ԥޤ\nԤޤ\nƥȤ";

		InternetAddress from = new InternetAddress("from@example.com", "п");
		InternetAddress returnPath = new InternetAddress("return@example.com");
		InternetAddress replyTo = new InternetAddress("reply@example.com");

		InternetAddress to1 = new InternetAddress("to1@example.com", "1");
		InternetAddress to2 = new InternetAddress("to2@example.com");

		InternetAddress cc1 = new InternetAddress("cc1@example.com", "CC1");
		InternetAddress cc2 = new InternetAddress("cc2@example.com");

		InternetAddress bcc = new InternetAddress("bcc@example.com");

		Mail result = builder.buildMail(file);

		assertEquals(subject, result.getSubject());
		assertEquals(text, result.getText());

		assertEquals(from, result.getFrom());
		assertEquals(returnPath, result.getReturnPath());
		assertEquals(replyTo, result.getReplyTo());

		InternetAddress[] tos = result.getTo();
		assertEquals(2, tos.length);
		assertEquals(to1, tos[0]);
		assertEquals(to2, tos[1]);

		InternetAddress[] ccs = result.getCc();
		assertEquals(2, ccs.length);
		assertEquals(cc1, ccs[0]);
		assertEquals(cc2, ccs[1]);

		InternetAddress[] bccs = result.getBcc();
		assertEquals(1, bccs.length);
		assertEquals(bcc, bccs[0]);
	}

	public void testBuildMailFromMultipleMailsTemplate() throws Exception {
		String path = "src/test/com/ozacc/mail/test-mail7-multiple.xml";
		File file = new File(path);

		Mail result1 = builder.buildMail(file, "first");
		assertEquals("1", result1.getText());

		Mail result2 = builder.buildMail(file, "second");
		assertEquals("2", result2.getText());

		try {
			Mail result3 = builder.buildMail(file, "");
		} catch (MailBuildException expected) {
			
		}
	}
}