package com.ozacc.mail.fetch;

import java.util.Date;
import java.util.Iterator;

import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

import com.ozacc.mail.Mail;

/**
 * ᡼롣
 * <p>
 * <code>FetchMail</code><code>FetchMailPro</code>μ饹Ǽ᡼뤬
 * 󥿡ͥåȥ᡼ȤƤλͤƤʤإå(FromToʤ)ͤåȤƤ硢
 * Υإå˳<code>ReceivedMail</code>󥹥󥹤Υץѥƥˤϲ⥻åȤޤ
 * 
 * @since 1.2
 * @author Tomohiro Otsuka
 * @version $Id: ReceivedMail.java,v 1.1.2.5 2005/01/18 07:23:54 otsuka Exp $
 */
public class ReceivedMail extends Mail {

	private Date date;

	private String messageId;

	private int size;

	private MimeMessage message;

	/**
	 * 󥹥ȥ饯
	 */
	public ReceivedMail() {
		super();
	}

	/**
	 * 󥹥ȥ饯
	 * 
	 * @param charset 
	 */
	public ReceivedMail(String charset) {
		super(charset);
	}

	/**
	 * ԡ󥹥ȥ饯
	 * 
	 * @param original 
	 */
	public ReceivedMail(Mail original) {
		super(original);
	}

	/**
	 * ֤ޤ
	 * <p>
	 * : ᡼μǤϤޤ
	 * 
	 * @return 
	 */
	public Date getDate() {
		return date;
	}

	/**
	 * 򥻥åȤޤ
	 * 
	 * @param date 
	 */
	public void setDate(Date date) {
		this.date = date;
	}

	/**
	 * &lt;&gt;դåID֤ޤ
	 * 
	 * @return &lt;&gt;դåID
	 */
	public String getMessageId() {
		return messageId;
	}

	/**
	 * åID֤ޤ&lt;&gt;դޤ
	 * 
	 * @return åID
	 */
	public String getMessageIdOnly() {
		return messageId.substring(1, messageId.length() - 1);
	}

	/**
	 * åID򥻥åȤޤ
	 * 
	 * @param messageId åID
	 */
	public void setMessageId(String messageId) {
		this.messageId = messageId;
	}

	/**
	 * ᡼ƤϤޤ<br>
	 * ᡼Υ˻եޥåȤǽϤޤ
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buf = new StringBuffer(1000);
		buf.append("Mail\n");
		buf.append("Return-Path: ").append(returnPath).append("\n");
		buf.append("Message-ID: ").append(messageId).append("\n");
		buf.append("Date: ").append(date).append("\n");
		buf.append("From: ").append(from != null ? from.toUnicodeString() : null).append("\n");
		buf.append("To: ").append(arrayToCommaDelimitedString(to)).append("\n");
		buf.append("Cc: ").append(arrayToCommaDelimitedString(cc)).append("\n");
		buf.append("Bcc: ").append(arrayToCommaDelimitedString(bcc)).append("\n");
		buf.append("Reply-To: ").append(replyTo != null ? replyTo.toUnicodeString() : null).append(
				"\n");
		buf.append("Subject: ").append(subject).append("\n");

		if (xHeaders != null) {
			for (Iterator itr = xHeaders.keySet().iterator(); itr.hasNext();) {
				String header = (String)itr.next();
				String value = (String)xHeaders.get(header);
				buf.append(header).append(": ").append(value).append("\n");
			}
		}

		buf.append("\n");
		buf.append(text);

		if (htmlText != null) {
			buf.append("\n\n-----\n\n");
			buf.append(htmlText);
		}

		if (isFileAttached()) {
			buf.append("\n\nAttachments\n");
			for (int i = 0, num = attachmentFiles.size(); i < num; i++) {
				AttachmentFile f = (AttachmentFile)attachmentFiles.get(i);
				buf.append("[").append(i).append("] ").append(f.getName()).append("\n");
			}
		}

		return buf.toString();
	}

	/**
	 * @return Returns the message.
	 */
	public MimeMessage getMessage() {
		return message;
	}

	/**
	 * @param message The message to set.
	 */
	public void setMessage(MimeMessage message) {
		this.message = message;
	}

	/**
	 * ᡼륵ФȤ³ǻˡΥ᡼᡼륵Фޤ
	 * Ǥ褦꤬Ǥ true ֤ޤ
	 * <p>
	 * Υ᥽åɤϡ<code>FetchMailPro</code>Υ᥽åɤˤäƼ줿
	 * <code>ReceivedMail</code>󥹥󥹤ǤΤͭǤ
	 * ޤ<code>FetchMailPro</code>󥹥󥹤᡼륵Ф
	 * ³Ƥ֤ǤθƤӽФΤͭǤ<br>
	 * ξ郎ʤˤΥ᥽åɤƤӽФ줿
	 * false ֤ޤ
	 * 
	 * TODO: ޤưƤʤ
	 * 
	 * @see FetchMailPro
	 * @param delete 褦ꤹ true
	 * @return ꤬˹Ԥ줿 true
	 */
	public boolean setDelete(boolean delete) {
		if (message != null) {
			try {
				message.setFlag(Flags.Flag.DELETED, delete);
			} catch (MessagingException e) {
				return false;
			}
			return true;
		}
		return false;
	}

	/**
	 * @return Returns the size.
	 */
	public int getSize() {
		return size;
	}

	/**
	 * @param size The size to set.
	 */
	public void setSize(int size) {
		this.size = size;
	}
}