/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.blog.trackback;

import com.ozacc.blog.trackback.TrackBackPing;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TrackBackUtils {
    private static Log log;
    private static final String DEFAULT_CHARSET = "UTF-8";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ozacc.blog.trackback.TrackBackUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    private TrackBackUtils() {
    }

    public static TrackBackPing getTrackBackPingFromRequest(HttpServletRequest request) {
        if (log.isDebugEnabled()) {
            TrackBackUtils.logReceivedRequest(request);
        }
        String encoding = request.getCharacterEncoding();
        log.debug((Object)("characterEncoding='" + encoding + "'"));
        String charset = request.getParameter("charset");
        if (charset == null || charset.length() == 0) {
            charset = DEFAULT_CHARSET;
        }
        String url = request.getParameter("url");
        String excerpt = request.getParameter("excerpt");
        String blogName = request.getParameter("blog_name");
        String title = request.getParameter("title");
        if (url.indexOf("blog.goo.ne.jp") != -1) {
            charset = "EUC-JP";
            log.debug((Object)"goo blog\u304b\u3089\u306e\u30c8\u30e9\u30c3\u30af\u30d0\u30c3\u30af\u3002charset\u3092EUC\u306b\u30bb\u30c3\u30c8\u3057\u307e\u3059\u3002");
        }
        if (encoding == null || encoding.length() == 0) {
            try {
                excerpt = TrackBackUtils.convertCharset(charset, excerpt);
                blogName = TrackBackUtils.convertCharset(charset, blogName);
                title = TrackBackUtils.convertCharset(charset, title);
                url = TrackBackUtils.convertCharset(charset, url);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        TrackBackPing ping = new TrackBackPing(title, excerpt, url, blogName);
        ping.setCharset(charset);
        return ping;
    }

    private static void logReceivedRequest(HttpServletRequest request) {
        StringBuffer buf = new StringBuffer();
        buf.append("\u53d7\u4fe1\u3057\u305f\u30ea\u30af\u30a8\u30b9\u30c8\u306e\u30d8\u30c3\u30c0\u3068\u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u4e00\u89a7\u3092\u51fa\u529b\u3057\u307e\u3059\u3002");
        buf.append("----------------------------------------\n");
        buf.append("\u30ea\u30af\u30a8\u30b9\u30c8\u30d8\u30c3\u30c0\n");
        buf.append("----------------------------------------\n");
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String headerName = (String)headers.nextElement();
            String headerValue = request.getHeader(headerName);
            buf.append(headerName).append("='").append(headerValue).append("'\n");
        }
        buf.append("----------------------------------------\n");
        buf.append("\u30ea\u30af\u30a8\u30b9\u30c8\u30d1\u30e9\u30e1\u30fc\u30bf\n");
        buf.append("----------------------------------------\n");
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String paramName = (String)params.nextElement();
            String paramValue = request.getParameter(paramName);
            buf.append(paramName).append("='").append(paramValue).append("'\n");
        }
        buf.append("----------------------------------------\n");
        log.debug((Object)buf.toString());
    }

    private static String convertCharset(String charset, String str) throws UnsupportedEncodingException {
        log.debug((Object)("\u6587\u5b57\u30b3\u30fc\u30c9\u3092\u5909\u63db\u3057\u307e\u3059\u3002[string='" + str + "', charset='" + charset + "']"));
        String result = new String(str.getBytes("8859_1"), charset);
        log.debug((Object)("\u6587\u5b57\u30b3\u30fc\u30c9\u3092\u5909\u63db\u3057\u307e\u3057\u305f\u3002[string='" + result + "', charset='" + charset + "']"));
        return result;
    }

    public static String getSuccessResponse() {
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buf.append("<response>\n");
        buf.append("<error>0</error>\n");
        buf.append("</response>");
        return buf.toString();
    }

    public static String getErrorResponse(String message) {
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buf.append("<response>\n");
        buf.append("<error>1</error>\n");
        buf.append("<message>").append(message).append("</message>\n");
        buf.append("</response>");
        return buf.toString();
    }

    public static boolean isRSSMode(HttpServletRequest request) {
        if ("GET".equalsIgnoreCase(request.getMethod())) {
            String mode = request.getParameter("__mode");
            return "rss".equals(mode);
        }
        return false;
    }
}

