package com.ozacc.mail.mock;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.MailException;
import com.ozacc.mail.SendMail;
import com.ozacc.mail.impl.MimeMessageBuilder;

/**
 * SendMailImpl饹Mock<br>
 * ¸SMTPФꤷƤ⡢ºݤˤޤ
 * ǥХå⡼ɤͭˤȡ᡼륿ߥ󥰤ǥ󥽡᡼ƤϤޤ
 * <p>
 * Mail󥹥󥹤 addExpectedMail() ˥åȤ verify() ᥽åɤ¹Ԥȡsend() 줿Mail󥹥󥹤ƤΥץѥƥ(XHeader)פʤAssertionFailedExceptionޤ
 * <p>
 * 㤨Сsend() 줿Mail󥹥󥹤Fromɥ쥹ȷ̾å¾ΥץѥƥϥåʤϡMockMail󥹥󥹤Ѥޤ
 * <pre>Mail sentMail = new Mail();
 *sentMail.setFrom("from@example.com");
 *sentMail.setSubject("̾");
 *sentMail.addTo("to@example.com");
 *sentMail.setText("ưŪʸ");
 *
 *Mail expectedMail = new Mail();
 *expectedMail.setFrom("from@example.com");
 *expectedMail.setSubject("̾");
 *
 *MockMail mockMail = new MockMail();
 *mockMail.setFrom("from@example.com");
 *mockMail.setSubject("̾");
 *
 *MockSendMail sendMail = new MockSendMail();
 *sendMail.addExpectedMail(expectedMail);
 *sendMail.send(sentMail);
 *sendMail.verify(); //  AssertionFailedException
 *
 *sendMail = new MockSendMail();
 *sendMail.addExpectedMail(mockMail);
 *sendMail.send(sentMail);
 *sendMail.verify(); // </pre>
 * <p>
 * <strong>:</strong> źեեоݤˤʤޤ
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: MockSendMail.java,v 1.12 2004/10/31 04:34:08 otsuka Exp $
 */
public class MockSendMail implements SendMail {

	/** ǥեȤΥץȥ롣smtp */
	public static final String DEFAULT_PROTOCOL = "smtp";

	/** ǥեȤΥݡȡ-1 */
	public static final int DEFAULT_PORT = -1;

	/** ǥեȤSMTPСlocalhost */
	public static final String DEFAULT_HOST = "localhost";

	/** ISO-2022-JP */
	public static final String JIS_CHARSET = "ISO-2022-JP";

	private static final String RETURN_PATH_KEY = "mail.smtp.from";

	private String protocol = DEFAULT_PROTOCOL;

	private String host = DEFAULT_HOST;

	private int port = DEFAULT_PORT;

	private String username;

	private String password;

	private String charset = JIS_CHARSET;

	private String returnPath;

	private List sentMails;

	private List mimeMessages;

	private List expectedMails;

	private boolean debug;

	/**
	 * 󥹥ȥ饯
	 */
	public MockSendMail() {
		super();
		initialize();
	}

	/**
	 * MockSendMail󥹥󥹤ޤ
	 */
	public void initialize() {
		sentMails = new ArrayList();
		expectedMails = new ArrayList();
		mimeMessages = new ArrayList();
	}

	/**
	 * 줿᡼MimeMessage󥹥󥹤֤ޤ
	 * Ǥ
	 * 
	 * @return ᡼MimeMessage󥹥
	 */
	public MimeMessage[] getMimeMessages() {
		return (MimeMessage[])mimeMessages.toArray(new MimeMessage[mimeMessages.size()]);
	}

	/**
	 * 줿Mail󥹥󥹤֤ޤǤ
	 * 
	 * @return ᡼Mail󥹥
	 */
	public Mail[] getSentMails() {
		return (Mail[])sentMails.toArray(new Mail[sentMails.size()]);
	}

	/**
	 * ǥХå⡼ɤͭˤʤäƤ뤫Ƚꤷޤ
	 * 
	 * @return Returns ͭˤʤäƤ true
	 */
	public boolean isDebug() {
		return debug;
	}

	/**
	 * ǥХå⡼(󥽡˥)ͭˤޤ
	 * ǥեȤ̵Ǥ
	 * 
	 * @param debug ǥХå⡼ɤͭˤ true
	 */
	public void setDebug(boolean debug) {
		this.debug = debug;
	}

	/**
	 * ǥХå⡼ɤͭΤȤꤵ줿å򥳥󥽡˽Ϥޤ
	 * 
	 * @param message 󥽡Ϥå
	 */
	private void debug(String message) {
		if (debug) {
			System.out.println("[" + Thread.currentThread().getName() + "] DEBUG "
					+ getClass().getName() + " - " + message);
		}
	}

	/**
	 * 
	 * @param expectedMail
	 */
	public void addExpectedMail(Mail expectedMail) {
		expectedMails.add(expectedMail);
	}

	/**
	 * 
	 * @param expectedMails
	 */
	public void addExpectedMail(Mail[] expectedMails) {
		for (int i = 0; i < expectedMails.length; i++) {
			addExpectedMail(expectedMails[i]);
		}
	}

	/**
	 * 
	 * @throws AssertionFailedException
	 */
	public void verify() throws AssertionFailedException {
		debug("======================================================");
		debug("                      verify()                        ");
		debug("======================================================");

		// ᡼ο
		int numOfExpectedMails = expectedMails.size();
		int numOfSentMails = sentMails.size();
		if (numOfExpectedMails != numOfSentMails) {
			throw new AssertionFailedException("ԥ᡼<" + numOfExpectedMails + ">᡼<"
					+ numOfSentMails + ">פޤǤ");
		}

		debug("ԥ᡼᡼ϰפޤ[" + numOfExpectedMails + "]");

		// ᡼Ƥ
		for (int i = 0; i < numOfExpectedMails; i++) {
			Mail expected = (Mail)expectedMails.get(i);
			Mail sent = (Mail)sentMails.get(i);
			debug((i + 1) + "ܤΥå򳫻Ϥޤ("
					+ ((expected instanceof MockMail) ? "MockMail" : "Mail") + " - Mail)");
			checkEquality(expected, sent, i + 1);
			debug((i + 1) + "ܤδԥ᡼᡼Ƥϰפޤ");
		}

		debug("verifyץޤ");
		debug("======================================================");
	}

	/**
	 * @param expected
	 * @param sent 
	 * @throws AssertionFailedException
	 */
	public void checkEquality(Mail expected, Mail sent, int num) throws AssertionFailedException {
		boolean mockMode = (expected instanceof MockMail);

		// ޥѡȥ᡼ξ
		if (expected.isMultipartMail()) {

			// HTML
			if (!mockMode) {
				if ((expected.getHtmlText() == null && sent.getHtmlText() != null)
						|| (expected.getHtmlText() != null && sent.getHtmlText() == null)
						|| (!expected.getHtmlText().equals(sent.getHtmlText()))) {
					throwExceptioWithMessage("HTMLʸ", expected.getHtmlText(), sent.getHtmlText(),
							num);
				}
			} else if (mockMode && expected.getHtmlText() != null) {
				if (!expected.getHtmlText().equals(sent.getHtmlText())) {
					throwExceptioWithMessage("HTMLʸ", expected.getHtmlText(), sent.getHtmlText(),
							num);
				}
			}
		}

		// Return-Path
		if (!mockMode || (mockMode && expected.getReturnPath() != null)) {
			if (expected.getReturnPath() != null && sent.getReturnPath() != null) {
				if (!expected.getReturnPath().equals(sent.getReturnPath())) {
					throwExceptioWithMessage("Return-Pathɥ쥹", expected.getReturnPath()
							.toUnicodeString(), sent.getReturnPath().toUnicodeString(), num);
				}
			} else if ((expected.getReturnPath() != null && sent.getReturnPath() == null)
					|| (expected.getReturnPath() == null && sent.getReturnPath() != null)) {
				throw new AssertionFailedException();
			}
		}

		// From
		if (!mockMode || (mockMode && expected.getFrom() != null)) {
			if (expected.getFrom() != null && sent.getFrom() != null) {
				if (!EqualityCheck.equals(expected.getFrom(), sent.getFrom())) {
					throwExceptioWithMessage("Fromɥ쥹", expected.getFrom().toUnicodeString(), sent
							.getFrom().toUnicodeString(), num);
				}
			} else if ((expected.getFrom() != null && sent.getFrom() == null)
					|| (expected.getFrom() == null && sent.getFrom() != null)) {
				throw new AssertionFailedException();
			}
		}

		// to
		InternetAddress[] expectedAddresses = expected.getTo();
		InternetAddress[] sentAddresses = sent.getTo();
		if (!mockMode || (mockMode && expectedAddresses.length > 0)) {
			if (expectedAddresses.length != sentAddresses.length) {
				throwExceptioWithMessage("Toɥ쥹", Integer.toString(expectedAddresses.length),
						Integer.toString(sentAddresses.length), num);
			}
			for (int i = 0; i < expectedAddresses.length; i++) {
				if (!EqualityCheck.equals(expectedAddresses[i], sentAddresses[i])) {
					throwExceptioWithMessage("Toɥ쥹", expectedAddresses[i].toUnicodeString(),
							sentAddresses[i].toUnicodeString(), num);
				}
			}
		}

		// cc
		expectedAddresses = expected.getCc();
		sentAddresses = sent.getCc();
		if (!mockMode || (mockMode && expectedAddresses.length > 0)) {
			if (expectedAddresses.length != sentAddresses.length) {
				throwExceptioWithMessage("Ccɥ쥹", Integer.toString(expectedAddresses.length),
						Integer.toString(sentAddresses.length), num);
			}
			for (int i = 0; i < expectedAddresses.length; i++) {
				if (!EqualityCheck.equals(expectedAddresses[i], sentAddresses[i])) {
					throwExceptioWithMessage("Ccɥ쥹", expectedAddresses[i].toUnicodeString(),
							sentAddresses[i].toUnicodeString(), num);
				}
			}
		}

		// bcc
		expectedAddresses = expected.getBcc();
		sentAddresses = sent.getBcc();
		if (!mockMode || (mockMode && expectedAddresses.length > 0)) {
			if (expectedAddresses.length != sentAddresses.length) {
				throwExceptioWithMessage("Bccɥ쥹", Integer.toString(expectedAddresses.length),
						Integer.toString(sentAddresses.length), num);
			}
			for (int i = 0; i < expectedAddresses.length; i++) {
				if (!EqualityCheck.equals(expectedAddresses[i], sentAddresses[i])) {
					throwExceptioWithMessage("Bccɥ쥹", expectedAddresses[i].toUnicodeString(),
							sentAddresses[i].toUnicodeString(), num);
				}
			}
		}

		// Reply-To
		if (!mockMode || (mockMode && expected.getReplyTo() != null)) {
			if (expected.getReplyTo() != null && sent.getReplyTo() != null) {
				if (!EqualityCheck.equals(expected.getReplyTo(), sent.getReplyTo())) {
					throwExceptioWithMessage("ReplyToɥ쥹",
							expected.getReplyTo().toUnicodeString(), sent.getReplyTo()
									.toUnicodeString(), num);
				}
			} else if ((expected.getReplyTo() != null && sent.getReplyTo() == null)
					|| (expected.getReplyTo() == null && sent.getReplyTo() != null)) {
				throw new AssertionFailedException();
			}
		}

		// ̾
		if (!mockMode || (mockMode && expected.getSubject().length() > 0)) {
			if (!expected.getSubject().equals(sent.getSubject())) {
				throwExceptioWithMessage("̾", expected.getSubject(), sent.getSubject(), num);
			}
		}

		// ʸ
		if (!mockMode || (mockMode && expected.getText().length() > 0)) {
			if (!expected.getText().equals(sent.getText())) {
				throwExceptioWithMessage("ʸ", expected.getText(), sent.getText(), num);
			}
		}

	}

	/**
	 * ͤƥ顼åAssertionFailedError򥹥ޤ
	 * 
	 * @param name פʤä̾
	 * @param expectedValue 
	 * @param sentValue º
	 * @param num NܤΥ᡼
	 * @throws AssertionFailedException 줿㳰
	 */
	protected void throwExceptioWithMessage(String name, String expectedValue, String sentValue,
											int num) throws AssertionFailedException {
		String message = num + "ܤΥåǡ" + name + "פפޤǤ='" + expectedValue
				+ "', ='" + sentValue + "'";

		debug(message);
		debug("verifyץϼԤޤ");
		debug("******************************************************");

		throw new AssertionFailedException(message);
	}

	/**
	 * @see com.ozacc.mail.SendMail#send(com.ozacc.mail.Mail)
	 */
	public void send(Mail mail) throws MailException {
		send(new Mail[] { mail });
	}

	/**
	 * @see com.ozacc.mail.SendMail#send(com.ozacc.mail.Mail[])
	 */
	public void send(Mail[] mails) throws MailException {
		debug("SMTP[" + host + "]³եꡣ");
		debug("SMTP[" + host + "]³եꡣ");

		Session session = Session.getInstance(new Properties());
		for (int i = 0; i < mails.length; i++) {

			Mail mail = mails[i];

			// MimeMessage
			MimeMessage message = new MimeMessage(session);
			MimeMessageBuilder builder = new MimeMessageBuilder(message);
			try {
				builder.buildMimeMessage(mail);
			} catch (UnsupportedEncodingException e) {
				throw new MailBuildException("ݡȤƤʤʸɤꤵޤ", e);
			} catch (MessagingException e) {
				throw new MailBuildException("MimeMessage˼Ԥޤ", e);
			}
			mimeMessages.add(message);

			debug("᡼եꡣ");
			sentMails.add(mail);
			debug(mail.toString());
			debug("᡼եꡣ");
		}

		debug("SMTP[" + host + "]Ȥ³Ǥեꡣ");
		debug("SMTP[" + host + "]Ȥ³Ǥեꡣ");
	}

	/**
	 * @see com.ozacc.mail.SendMail#send(javax.mail.internet.MimeMessage)
	 */
	public void send(MimeMessage mimeMessage) throws MailException {
		throw new UnsupportedOperationException("ޤMockSendMailǤϡΥ᥽åɤ򥵥ݡȤƤޤ");
	}

	/**
	 * @see com.ozacc.mail.SendMail#send(javax.mail.internet.MimeMessage[])
	 */
	public void send(MimeMessage[] mimeMessages) throws MailException {
		throw new UnsupportedOperationException("ޤMockSendMailǤϡΥ᥽åɤ򥵥ݡȤƤޤ");
	}

	/**
	 * 󥳡ǥ󥰤˻Ѥʸɤ֤ޤ
	 * 
	 * @return 󥳡ǥ󥰤˻Ѥʸ
	 */
	public String getCharset() {
		return charset;
	}

	/**
	 * ᡼η̾ʸΥ󥳡ǥ󥰤˻Ѥʸɤꤷޤ
	 * ǥեȤ ISO-2022-JP Ǥ
	 * 
	 * @param charset 󥳡ǥ󥰤˻Ѥʸ
	 */
	public void setCharset(String charset) {
		this.charset = charset;
	}

	/**
	 * åȤ줿SMTPФΥۥ̾ޤIPɥ쥹֤ޤ
	 * 
	 * @return SMTPФΥۥ̾ޤIPɥ쥹
	 */
	public String getHost() {
		return host;
	}

	/**
	 * SMTPФΥۥ̾ޤIPɥ쥹򥻥åȤޤ
	 * ǥեȤ localhost Ǥ
	 * 
	 * @param host SMTPФΥۥ̾ޤIPɥ쥹
	 */
	public void setHost(String host) {
		this.host = host;
	}

	/**
	 * @return SMTPǧڥѥ
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * SMTPФ³ǧڤɬפʾ˥ѥɤ򥻥åȤޤ
	 * 
	 * @param password SMTPǧڥѥ
	 */
	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * @return SMTPФΥݡֹ
	 */
	public int getPort() {
		return port;
	}

	/**
	 * SMTPФΥݡֹ򥻥åȤޤ
	 * 
	 * @param port SMTPФΥݡֹ
	 */
	public void setPort(int port) {
		this.port = port;
	}

	/**
	 * @return Returns the protocol.
	 */
	public String getProtocol() {
		return protocol;
	}

	/**
	 * @param protocol The protocol to set.
	 */
	public void setProtocol(String protocol) {
		this.protocol = protocol;
	}

	/**
	 * @return Return-Pathɥ쥹
	 */
	public String getReturnPath() {
		return returnPath;
	}

	/**
	 * Return-Pathɥ쥹򥻥åȤޤ
	 * 
	 * @param returnPath Return-Pathɥ쥹
	 */
	public void setReturnPath(String returnPath) {
		this.returnPath = returnPath;
	}

	/**
	 * @return SMTPǧڥ桼̾
	 */
	public String getUsername() {
		return username;
	}

	/**
	 * SMTPФ³ǧڤɬפʾ˥桼̾򥻥åȤޤ
	 * 
	 * @param username SMTPǧڥ桼̾
	 */
	public void setUsername(String username) {
		this.username = username;
	}

}