/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.impl;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.VelocityMailBuilder;
import com.ozacc.mail.impl.VelocityLogSystem;
import com.ozacc.mail.impl.XMLMailBuilderImpl;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.log.LogSystem;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLVelocityMailBuilderImpl
extends XMLMailBuilderImpl
implements VelocityMailBuilder {
    private static Log log;
    private String charset = "UTF-8";
    private LogSystem velocityLogSystem = new VelocityLogSystem();
    private Map templateCache = new HashMap();
    private boolean cacheEnabled = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ozacc.mail.impl.XMLVelocityMailBuilderImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    private boolean hasTemplateCache(String key) {
        if (this.cacheEnabled) {
            return this.templateCache.containsKey(key);
        }
        return false;
    }

    private void putTemplateCache(String key, String templateXmlText) {
        if (this.cacheEnabled) {
            log.debug((Object)("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u3092\u30ad\u30e3\u30c3\u30b7\u30e5\u3057\u307e\u3059\u3002[key='" + key + "']"));
            this.templateCache.put(key, templateXmlText);
        }
    }

    private String getTemplateCache(String key) {
        if (this.hasTemplateCache(key)) {
            log.debug((Object)("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u30ad\u30e3\u30c3\u30b7\u30e5\u3092\u8fd4\u3057\u307e\u3059\u3002[key='" + key + "']"));
            return (String)this.templateCache.get(key);
        }
        return null;
    }

    public synchronized void clearCache() {
        log.debug((Object)"\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u30ad\u30e3\u30c3\u30b7\u30e5\u3092\u30af\u30ea\u30a2\u3057\u307e\u3059\u3002");
        this.templateCache.clear();
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        if (!cacheEnabled) {
            this.clearCache();
        }
        this.cacheEnabled = cacheEnabled;
    }

    public Mail buildMail(String classPath, VelocityContext context) throws MailBuildException {
        String templateXmlText;
        if (!this.hasTemplateCache(classPath)) {
            Document doc;
            try {
                doc = this.getDocumentFromClassPath(classPath, false);
            }
            catch (SAXException e) {
                throw new MailBuildException("XML\u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new MailBuildException("XML\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
            }
            templateXmlText = this.convertDocumentIntoString(doc);
            this.putTemplateCache(classPath, templateXmlText);
        } else {
            templateXmlText = this.getTemplateCache(classPath);
        }
        try {
            return this.build(templateXmlText, context);
        }
        catch (Exception e) {
            throw new MailBuildException("\u30e1\u30fc\u30eb\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    public Mail buildMail(File file, VelocityContext context) throws MailBuildException {
        String templateXmlText;
        if (!this.hasTemplateCache(file.getAbsolutePath())) {
            Document doc;
            try {
                doc = this.getDocumentFromFile(file, false);
            }
            catch (SAXException e) {
                throw new MailBuildException("XML\u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new MailBuildException("XML\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
            }
            templateXmlText = this.convertDocumentIntoString(doc);
            this.putTemplateCache(file.getAbsolutePath(), templateXmlText);
        } else {
            templateXmlText = this.getTemplateCache(file.getAbsolutePath());
        }
        try {
            return this.build(templateXmlText, context);
        }
        catch (Exception e) {
            throw new MailBuildException("\u30e1\u30fc\u30eb\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    private Mail build(String templateXmlText, VelocityContext context) throws TransformerFactoryConfigurationError, Exception, ParseErrorException, MethodInvocationException, ResourceNotFoundException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Source XML Mail Data\n" + templateXmlText));
        }
        Velocity.setProperty((String)"runtime.log.logsystem", (Object)this.velocityLogSystem);
        Velocity.init();
        StringWriter w = new StringWriter();
        Velocity.evaluate((Context)context, (Writer)w, (String)"XML Mail Data", (String)templateXmlText);
        StringReader reader = new StringReader(w.toString());
        DocumentBuilder db = this.createDocumentBuilder();
        InputSource source = new InputSource(reader);
        Document newDoc = db.parse(source);
        if (log.isDebugEnabled()) {
            String newXmlContent = this.convertDocumentIntoString(newDoc);
            log.debug((Object)("VelocityContext-merged XML Mail Data\n" + newXmlContent));
        }
        return this.buildMail(newDoc);
    }

    private String convertDocumentIntoString(Document doc) throws TransformerFactoryConfigurationError {
        Transformer t;
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            t = tf.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new MailBuildException(e.getMessage(), e);
        }
        t.setOutputProperties(this.getOutputProperties());
        DOMSource source = new DOMSource(doc);
        StringWriter w = new StringWriter();
        StreamResult result = new StreamResult(w);
        try {
            t.transform(source, result);
        }
        catch (TransformerException e) {
            throw new MailBuildException(e.getMessage(), e);
        }
        return w.toString();
    }

    private Properties getOutputProperties() {
        Properties p = new Properties();
        p.put("encoding", this.charset);
        p.put("doctype-public", "-//OZACC//DTD MAIL//EN");
        p.put("doctype-system", "http://www.ozacc.com/library/dtd/ozacc-mail.dtd");
        return p;
    }
}

