package com.ozacc.mail.mock;

import javax.mail.internet.InternetAddress;

import com.ozacc.mail.Mail;

/**
 * ᡼뤬ƱͤǤ뤳ȤĴ٤᥽åɤ󶡡
 * <p>
 * <strong>:</strong> źեեоݤˤʤޤ
 * 
 * @since 1.1
 * 
 * @author Tomohiro Otsuka
 * @version $Id: EqualityCheck.java,v 1.3 2004/09/22 05:56:00 otsuka Exp $
 */
public class EqualityCheck {

	private EqualityCheck() {}

	/**
	 * expectedsentΥ᡼ƤƱǤ뤫ɤȽꤷޤ<br>
	 * MultipartMailΥ󥹥󥹤Ǥޤâźեեϥåޤ
	 * 
	 * @param expected
	 * @param sent
	 * @return expectedsentΥ᡼ƤƱǤ true
	 */
	public static boolean equals(Mail expected, Mail sent) {
		boolean mockMode = false;
		if (expected instanceof MockMail) {
			mockMode = true;
		}

		// ޥѡȥ᡼ξ
		if (expected.isMultipartMail()) {

			// HTML
			if (!mockMode) {
				if ((expected.getHtmlText() == null && sent.getHtmlText() != null)
						|| (expected.getHtmlText() != null && sent.getHtmlText() == null)
						|| (!expected.getHtmlText().equals(sent.getHtmlText()))) {
					return false;
				}
			} else if (mockMode && expected.getHtmlText() != null) {
				if (!expected.getHtmlText().equals(sent.getHtmlText())) {
					return false;
				}
			}
		}

		// Return-Path
		if (!mockMode || (mockMode && expected.getReturnPath() != null)) {
			if (expected.getReturnPath() != null && sent.getReturnPath() != null) {
				if (!expected.getReturnPath().equals(sent.getReturnPath())) {
					return false;
				}
			} else if ((expected.getReturnPath() != null && sent.getReturnPath() == null)
					|| (expected.getReturnPath() == null && sent.getReturnPath() != null)) {
				return false;
			}
		}

		// to
		InternetAddress[] expectedAddresses = expected.getTo();
		InternetAddress[] sentAddresses = sent.getTo();
		if (!mockMode || (mockMode && expectedAddresses.length > 0)) {
			if (expectedAddresses.length != sentAddresses.length) {
				return false;
			}
			for (int i = 0; i < expectedAddresses.length; i++) {
				if (!expectedAddresses[i].equals(sentAddresses[i])) {
					return false;
				}
			}
		}

		// cc
		expectedAddresses = expected.getCc();
		sentAddresses = sent.getCc();
		if (!mockMode || (mockMode && expectedAddresses.length > 0)) {
			if (expectedAddresses.length != sentAddresses.length) {
				return false;
			}
			for (int i = 0; i < expectedAddresses.length; i++) {
				if (!expectedAddresses[i].equals(sentAddresses[i])) {
					return false;
				}
			}
		}

		// bcc
		expectedAddresses = expected.getBcc();
		sentAddresses = sent.getBcc();
		if (!mockMode || (mockMode && expectedAddresses.length > 0)) {
			if (expectedAddresses.length != sentAddresses.length) {
				return false;
			}
			for (int i = 0; i < expectedAddresses.length; i++) {
				if (!expectedAddresses[i].equals(sentAddresses[i])) {
					return false;
				}
			}
		}

		// Reply-To
		if (!mockMode || (mockMode && expected.getReplyTo() != null)) {
			if (expected.getReplyTo() != null && sent.getReplyTo() != null) {
				if (!expected.getReplyTo().equals(sent.getReplyTo())) {
					return false;
				}
			} else if ((expected.getReplyTo() != null && sent.getReplyTo() == null)
					|| (expected.getReplyTo() == null && sent.getReplyTo() != null)) {
				return false;
			}
		}

		// ̾
		if (!mockMode || (mockMode && expected.getSubject().length() > 0)) {
			if (!expected.getSubject().equals(sent.getSubject())) {
				return false;
			}
		}

		// ʸ
		if (!mockMode || (mockMode && expected.getText().length() > 0)) {
			if (!expected.getText().equals(sent.getText())) {
				return false;
			}
		}

		return true;
	}
}