/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.impl;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.VelocityMailBuilder;
import com.ozacc.mail.impl.VelocityLogSystem;
import com.ozacc.mail.impl.XMLMailBuilderImpl;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.log.LogSystem;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLVelocityMailBuilderImpl
extends XMLMailBuilderImpl
implements VelocityMailBuilder {
    private static Log log;
    private String charset = "UTF-8";
    private LogSystem velocityLogSystem = new VelocityLogSystem();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ozacc.mail.impl.XMLVelocityMailBuilderImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public Mail buildMail(String classPath, VelocityContext context) throws MailBuildException {
        Document doc;
        try {
            doc = this.getDocumentFromClassPath(classPath, false);
        }
        catch (SAXException e) {
            throw new MailBuildException("XML\u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MailBuildException("XML\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
        try {
            return this.build(doc, context);
        }
        catch (Exception e) {
            throw new MailBuildException("\u30e1\u30fc\u30eb\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    public Mail buildMail(File file, VelocityContext context) throws MailBuildException {
        Document doc;
        try {
            doc = this.getDocumentFromFile(file, false);
        }
        catch (SAXException e) {
            throw new MailBuildException("XML\u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MailBuildException("XML\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
        try {
            return this.build(doc, context);
        }
        catch (Exception e) {
            throw new MailBuildException("\u30e1\u30fc\u30eb\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    private Mail build(Document doc, VelocityContext context) throws TransformerFactoryConfigurationError, Exception, ParseErrorException, MethodInvocationException, ResourceNotFoundException, IOException {
        String xmlContent = this.convertDocumentIntoString(doc);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Source XML Mail Data\n" + xmlContent));
        }
        Velocity.setProperty((String)"runtime.log.logsystem", (Object)this.velocityLogSystem);
        Velocity.init();
        StringWriter w = new StringWriter();
        Velocity.evaluate((Context)context, (Writer)w, (String)"XML Mail Data", (String)xmlContent);
        StringReader reader = new StringReader(w.toString());
        DocumentBuilder db = this.createDocumentBuilder();
        InputSource source = new InputSource(reader);
        Document newDoc = db.parse(source);
        if (log.isDebugEnabled()) {
            String newXmlContent = this.convertDocumentIntoString(newDoc);
            log.debug((Object)("VelocityContext-merged XML Mail Data\n" + newXmlContent));
        }
        return this.build(newDoc);
    }

    private String convertDocumentIntoString(Document doc) throws TransformerFactoryConfigurationError {
        Transformer t;
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            t = tf.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new MailBuildException(e.getMessage(), e);
        }
        t.setOutputProperties(this.getOutputProperties());
        DOMSource source = new DOMSource(doc);
        StringWriter w = new StringWriter();
        StreamResult result = new StreamResult(w);
        try {
            t.transform(source, result);
        }
        catch (TransformerException e) {
            throw new MailBuildException(e.getMessage(), e);
        }
        return w.toString();
    }

    private Properties getOutputProperties() {
        Properties p = new Properties();
        p.put("encoding", this.charset);
        p.put("doctype-public", "-//OZACC//DTD MAIL//EN");
        p.put("doctype-system", "http://www.ozacc.com/library/dtd/ozacc-mail.dtd");
        return p;
    }
}

