package com.ozacc.mail.impl;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;

import javax.mail.internet.MimeUtility;

import junit.framework.TestCase;

import org.apache.log4j.BasicConfigurator;

import com.dumbster.smtp.SimpleSmtpServer;
import com.dumbster.smtp.SmtpMessage;
import com.ozacc.mail.Mail;
import com.ozacc.mail.MailException;

/**
 * SendMailImpl饹Υƥȥ
 * <p>
 * DumbsterѤƥƥȤƤ뤬ݡȤƤʤǽ¿
 * 
 * @author Tomohiro Otsuka
 * @version $Id: SendMailImplTest.java,v 1.2 2004/09/10 07:36:29 otsuka Exp $
 */
public class SendMailImplTest extends TestCase {

	private SendMailImpl sendMail;

	private SimpleSmtpServer server;

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();

		BasicConfigurator.configure();

		int port = 2525;
		server = SimpleSmtpServer.start(port);
		sendMail = new SendMailImpl();
		sendMail.setPort(port);
	}

	/**
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		BasicConfigurator.resetConfiguration();
	}

	private String convertJisValue(String str) throws UnsupportedEncodingException {
		return new String(str.getBytes(), "JIS");
	}

	/**
	 * ñȯ᡼Υƥȡ
	 * 
	 * @throws Exception
	 */
	public void testSendMail() throws Exception {
		String from = "from@example.com";
		String fromName = "п";
		String to = "info@example.com";
		String subject = "̾";
		String text = "ƥ";

		Mail mail = new Mail();
		mail.setFrom(from, fromName);
		mail.addTo(to);
		mail.setSubject(subject);
		mail.setText(text);

		sendMail.send(mail);

		server.stop();

		assertEquals(1, server.getReceievedEmailSize());
		Iterator inbox = server.getReceivedEmail();
		SmtpMessage email = (SmtpMessage)inbox.next();

		assertEquals(mail.getTo()[0].toString(), email.getHeaderValue("To"));
		assertEquals(mail.getFrom().toString(), email.getHeaderValue("From"));

		assertEquals(mail.getSubject(), MimeUtility.decodeText(email.getHeaderValue("Subject")));
		assertEquals(mail.getText() + "\n", convertJisValue(email.getBody()));
	}

	/**
	 * ʣ᡼ΰƥȡ
	 * Ʊ³ʣåDumbster顼ǤΤǡ
	 * Ȥꤢ1ĤMail󥹥󥹤ǥƥȡ
	 * ºݤSMTP(qmail)Ǥ뤳ȤϳǧѤߡ
	 * 
	 * @throws Exception
	 */
	public void testSendMailMultiple() throws Exception {
		String from = "from@example.com";
		String fromName = "п";
		String to = "info@example.com";
		String subject = "̾";
		String text = "ƥ";

		Mail mail1 = new Mail();
		mail1.setFrom(from, fromName);
		mail1.addTo(to);
		mail1.setSubject(subject);
		mail1.setText(text);

		Mail mail2 = new Mail();
		mail2.setFrom(from, fromName);
		mail2.addTo(to);
		mail2.setSubject(subject);
		mail2.setText(text);

		Mail mail3 = new Mail();
		mail3.setFrom(from, fromName);
		mail3.addTo(to);
		mail3.setSubject(subject);
		mail3.setText(text);

		// DumbsterΥХľä顢mail1, mail2, mail3 ޤƥƥ
		sendMail.send(new Mail[] { mail1 });

		server.stop();

		// DumbsterΥХľä顢3 ˡ
		assertEquals(1, server.getReceievedEmailSize());

		Iterator inbox = server.getReceivedEmail();
		SmtpMessage email = (SmtpMessage)inbox.next();

		assertEquals(mail1.getTo()[0].toString(), email.getHeaderValue("To"));
		assertEquals(mail1.getFrom().toString(), email.getHeaderValue("From"));

		assertEquals(mail1.getSubject(), MimeUtility.decodeText(email.getHeaderValue("Subject")));
		assertEquals(mail1.getText() + "\n", convertJisValue(email.getBody()));
	}

	public void testSendMailWithReturnPath() throws Exception {
		String from = "from@example.com";
		String fromName = "п";
		String to = "info@example.com";
		String subject = "̾";
		String text = "ƥ";
		String returnPath = "return-path@example.com";

		Mail mail = new Mail();
		mail.setFrom(from, fromName);
		mail.addTo(to);
		mail.setSubject(subject);
		mail.setText(text);
		mail.setReturnPath(returnPath);
		mail.setImportance(Mail.Importance.HIGH);

		sendMail.send(mail);

		server.stop();

		assertEquals(1, server.getReceievedEmailSize());
		Iterator inbox = server.getReceivedEmail();
		SmtpMessage email = (SmtpMessage)inbox.next();

		// إå
		/*
		 Iterator itr = email.getHeaderNames();
		 while (itr.hasNext()) {
		 String name = (String)itr.next();
		 System.out.println(name + "='" + email.getHeaderValue(name) + "'");
		 }
		 */

		// DumbsterǤϡReturn-PathإåݻƤʤ
		//assertEquals(mail.getReturnPath().toString(), email.getHeaderValue("Return-Path"));
		// ٤ǧ
		assertEquals(mail.getImportance(), email.getHeaderValue("Importance"));
		assertEquals("1", email.getHeaderValue("X-Priority"));
	}

	/**
	 * ꤷƤʤsend()㳰򥹥
	 * ToCcBccǤꤹС㳰ϵʤ
	 * 
	 * @throws Exception
	 */
	public void testSendMailNoRecpient() throws Exception {
		String from = "from@example.com";
		String fromName = "п";
		String subject = "̾";
		String text = "ƥ";

		Mail mail = new Mail();
		mail.setFrom(from, fromName);
		mail.setSubject(subject);
		mail.setText(text);

		try {
			sendMail.send(mail);
			fail("This should never be called.");
		} catch (MailException expected) {
			assertEquals("MimeMessage˼Ԥޤ", expected.getMessage());
		}
	}

}