package net.souko105.flashserver.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

/**
 * o͂̃[eBeB
 * @author AKatayama
 */
public class IOUtils
{
    public static final DateFormat HEADER_DATE_FORMAT = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss 'GMT'",Locale.UK);
    public static final DateFormat COOKIE_DATE_FORMAT = new SimpleDateFormat("E, d-MMM-yyyy HH:mm:ss 'GMT'",Locale.UK);
    /**
     * Xg[Rs[܂B
     * @param in
     * @param out
     * @return Rs[oCg
     * @throws IOException
     */
    public static final int copyStream(InputStream in,OutputStream out) throws IOException    
    {
        byte[] buf = new byte[8196];
        int totalSize = 0;
        int size = 0;
        while((size = in.read(buf)) != -1 )
        {
            out.write(buf,0,size);
            totalSize += size;
        }
        return totalSize;
    }
    /**
     * pX\\/ɒu܂B
     * @param filepath
     * @return
     */
    public static final String replaceFileSeparator(String filepath)
    {
        return filepath.replace('\\','/');
    }
    /**
     * wart@C𓀂܂B
     * @param warFile
     * @param directory
     * @throws IOException
     */
    public static void extract(File warFile, File directory) throws IOException
    {
        JarInputStream jin = new JarInputStream(new FileInputStream(warFile));
        JarEntry entry=null;
        
        while((entry=jin.getNextJarEntry())!=null)
        {
            File file=new File(directory,entry.getName());
    
            if (entry.isDirectory())
            {
                if (!file.exists())
                    file.mkdirs();
            }
            else
            {
                File dir = new File(file.getParent());
                if (!dir.exists())
                    dir.mkdirs();
    
                FileOutputStream fout = null;
                try
                {
                    fout = new FileOutputStream(file);
                    byte[] buf = new byte[2048];
                    int size = 0;
                    while((size = jin.read(buf)) > 0 )
                        fout.write(buf,0,size);
                }
                finally
                {
                    fout.flush();
                    fout.close();
                    fout = null;
                }
    
                if (entry.getTime()>=0)
                    file.setLastModified(entry.getTime());
            }
        }
    }
}
