package net.souko105.flashserver.javaee.imp;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

import net.souko105.flashserver.FlashServer;
import net.souko105.flashserver.FlashServerConfig;
import net.souko105.flashserver.FlashServerConst;
import net.souko105.flashserver.javaee.servlet.FileSavingServlet;
import net.souko105.flashserver.javaee.webxml.ServletMappingTag;
import net.souko105.flashserver.javaee.webxml.ServletTag;
import net.souko105.flashserver.javaee.webxml.WebAppTag;
import net.souko105.flashserver.javaee.webxml.WebXml;
import net.souko105.flashserver.javaee.webxml.WebXmlFactory;
import net.souko105.flashserver.log.FlashServerLog;
import net.souko105.flashserver.log.FlashServerLogFactory;
import net.souko105.flashserver.util.IOUtils;
import net.souko105.flashserver.util.PathUtils;

import org.apache.jasper.servlet.JspServlet;

/**
 * WebApp̃}l[W[NX
 * webappsȉWebAvP[Vǂݍ݁A
 * ܂B 
 * @author AKatayama
 */
public class WebAppManager
{
    private static FlashServerLog log = FlashServerLogFactory.getLog(WebAppManager.class);

    private static WebAppManager manager;
    
    private String webappDirPath;
    private List contextPathList = new ArrayList();
    private List webAppList = new ArrayList();
    private static boolean init = false;
    
    private class DirFileFilter implements FileFilter{
        public boolean accept(File file){                
            return file.isDirectory();
        }
    }

    private class WarFileFilter implements FileFilter{
        public boolean accept(File file){                
            return file.getName().endsWith(".war");
        }
    }
    
    private WebAppManager()
    {
        super();
    }
    public static synchronized void init() throws WebAppInitializeException
    {
    	if(!init)
    	{
    		try
			{
	    		manager = new WebAppManager();
	    		manager.initManager();
			}
    		catch(Exception e)
			{
    			throw new WebAppInitializeException(e);
			}
    	}
    }
    private void initManager() throws Exception
    {
        String homeDirPath = FlashServerConfig.getConfig(FlashServerConst.KEY_FS_HOME);
        webappDirPath = homeDirPath+"/webapps";
        File webappDir = new File(webappDirPath);
        if(!webappDir.exists())
            return ;

        prepareWebAppDir();
        initWebAppContext();
    }
    private void prepareWebAppDir() throws IOException
    {
        File webappDir = new File(webappDirPath);
        
        File[] dirs = webappDir.listFiles(new DirFileFilter());
        
        File[] warFiles = webappDir.listFiles(new WarFileFilter());
        
        if(warFiles != null)
        {
            for(int i = 0;i < warFiles.length;i++)
            {
                if(!isExtracted(warFiles[i],dirs))
                    extractWar(warFiles[i],webappDir);
            }
        }    
        
        contextPathList = new ArrayList();
        dirs = webappDir.listFiles(new DirFileFilter());
        if(dirs != null)
        {
            for(int i = 0;i < dirs.length;i++)
                contextPathList.add("/" + dirs[i].getName());
        }
    }
    private void initWebAppContext() throws Exception
    {
        for(Iterator itr = contextPathList.iterator();itr.hasNext();)
        {
            String contextPath = (String)itr.next();
            File webxmlFile = new File(webappDirPath+contextPath+"/WEB-INF/web.xml");
            WebXml webxml = null;
            if(webxmlFile.exists())
            {
                FileInputStream fin = null;
                try
                {
	                fin = new FileInputStream(webxmlFile);
	                webxml = WebXmlFactory.createWebXml(fin);
                }
                finally
                {
                    fin.close();
                    fin = null;
                }
            }
            else
            {
                webxml = new WebXml();
                webxml.setWebApp(new WebAppTag());
            }
            setDefaultServlet(webxml,contextPath);
            
            //create WebApp
            String absoluteContextPath = webappDirPath+contextPath;
            WebAppClassLoader webAppClassLoader = createWebAppClassLoader(absoluteContextPath);
            webAppClassLoader.setParentClassLoader(Thread.currentThread().getContextClassLoader());
            WebApp webapp  = new WebApp(webxml,absoluteContextPath,contextPath,webAppClassLoader);

            this.webAppList.add(webapp);
        }
    }
    private WebAppClassLoader createWebAppClassLoader(String absoluteContextPath) throws MalformedURLException
    {
        List urlList = new ArrayList();
        //classes
        File classesDir = new File(absoluteContextPath+"/WEB-INF/classes");
        if(classesDir.exists())
        {
            String dirPath = classesDir.getAbsolutePath();
            dirPath = IOUtils.replaceFileSeparator(dirPath) + "/";
            urlList.add(new URL("file:///"+dirPath));
        }
        //WEB-INF/lib
        String webinfLibDir = absoluteContextPath+"/WEB-INF/lib";
        URL[] libs = PathUtils.createArchiveClassPaths(webinfLibDir);
        if(libs != null)
        {
            for(int i = 0;i < libs.length;i++)
                urlList.add(libs[i]);
        }
        URL[] urls = (URL[])urlList.toArray(new URL[]{});
        if(urls != null)
            return new WebAppClassLoader(urls);
        else
            return null;
    }

    /**
     * ftHgT[ubgiFileSavingServlet)̋Lqǉ܂B
     * @param webxml
     */
    private void setDefaultServlet(WebXml webxml,String contextPath)
    {
        //jsp compiler
        final String jspServletName = "jsp";
        ServletTag jspServlet = new ServletTag();
        jspServlet.setLoadOnStartup(0);
        jspServlet.setServletClass(JspServlet.class.getName());
        jspServlet.setServletName(jspServletName);
        jspServlet.addInitParam("logVerbosityLevel","WARNING");
        jspServlet.addInitParam("validating","false");        
        jspServlet.addInitParam("fork","false");
        //JSPRpCfBNg̍쐬
        jspServlet.addInitParam("scratchdir","false");
        String jspWorkDirPath = System.getProperty("java.io.tmpdir")+"/flashserverjsp"+contextPath;
        File jspWorkDir = new File(jspWorkDirPath);
        jspWorkDir.mkdirs();
        jspServlet.addInitParam("scratchdir",jspWorkDirPath); 
        String jspClassPath = System.getProperty(FlashServer.FLASHSERVER_JSP_LIBPATH);
        if(jspClassPath != null)
        	jspServlet.addInitParam("classpath",jspClassPath);
        
        ServletMappingTag jspMapping = new ServletMappingTag();
        jspMapping.setServletName(jspServletName);
        jspMapping.addUrlPattern("*.jsp");
        
        webxml.getWebApp().addServlet(jspServlet);
        webxml.getWebApp().addServletMapping(jspMapping);
        
        //file saving
        final String servletName = "file";
        ServletTag fileServlet = new ServletTag();        
        fileServlet.setLoadOnStartup(0);
        fileServlet.setServletClass(FileSavingServlet.class.getName());
        fileServlet.setServletName(servletName);
        fileServlet.addInitParam(FileSavingServlet.PARAM_APP_ROOT,this.webappDirPath);
        ServletMappingTag mapping = new ServletMappingTag();
        mapping.setServletName(servletName);
        mapping.addUrlPattern("/*");

        webxml.getWebApp().addServlet(fileServlet);
        webxml.getWebApp().addServletMapping(mapping);
        

    }
    private static boolean isExtracted(File warFile,File[] dirs)
    {
        boolean extracted = false;
        if(dirs != null)
        {
            String archiveName = getArchiveName(warFile.getName());
            for(int i =0;i < dirs.length;i++)
            {
                if(archiveName.equals(dirs[i].getName()))
                    extracted = true;
            }
        }
        return extracted;
    }
    private static String getArchiveName(String warFileName)
    {
        return warFileName.substring(0,warFileName.length()-".war".length());
    }
    private static void extractWar(File warFile, File directory) throws IOException
    {
        log.info("extract war start. filename=" + warFile.getName());

        try
        {
	        JarInputStream jin = new JarInputStream(new FileInputStream(warFile));
	        JarEntry entry=null;
	        
	        File webAppDir = new File(directory,getArchiveName(warFile.getName()));
	        webAppDir.mkdirs();
	        
	        while((entry=jin.getNextJarEntry())!=null)
	        {
	            File file=new File(webAppDir,entry.getName());
	
	            if (entry.isDirectory())
	            {
	                if (!file.exists())
	                    file.mkdirs();
	            }
	            else
	            {
	                File dir = new File(file.getParent());
	                if (!dir.exists())
	                    dir.mkdirs();
	
	                FileOutputStream fout = null;
	                try
	                {
	                    fout = new FileOutputStream(file);
	                    IOUtils.copyStream(jin,fout);
	                }
	                finally
	                {
	                    fout.flush();
	                    fout.close();
	                    fout = null;
	                }
	
	                if (entry.getTime()>=0)
	                    file.setLastModified(entry.getTime());
	            }
	        }
	        log.info("extract success.");
        }
        catch(IOException ioe)
        {
            log.info("extract fail.");
            throw ioe;
        }
    }
    public static WebAppManager getInstance(){
        return manager;
    }
    /**
     * webappsȉ̃tH_ReLXgpXƂĔFA/ĕԂ܂B
     * @return
     */
    public List getContextPathList()
    {
        return contextPathList;
    }
    /**
     * WebApp̃XgԂ܂B
     * @return
     */
    public List getWebAppList()
    {
        return webAppList;
    }
    /**
     * ReLXgpXɑ΂WebApp܂B
     * @param contextPath
     * @return YWebAppȂꍇAnull
     */
    public WebApp findWebApp(String contextPath)
    {
        for(Iterator itr = getWebAppList().iterator();itr.hasNext();)
        {
            WebApp webapp = (WebApp)itr.next();
            if(webapp.getContextPath().equals(contextPath))
                return  webapp;
        }
        return null;
    }
}
