package net.souko105.flashserver.javaee.imp;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

import org.apache.commons.collections.iterators.IteratorEnumeration;

/**
 * ServletConfigNX
 * @author AKatayama
 */
public class ServletConfigImp implements ServletConfig
{
    private Map initParameter = new HashMap();
    private String servletName;
    private ServletContext servletContext;
    public ServletConfigImp()
    {
        super();
    }
    public String getServletName()
    {
        return servletName;
    }
    public ServletContext getServletContext()
    {
        return servletContext;
    }
    public String getInitParameter(String key)
    {
        return (String)initParameter.get(key);
    }
    public Enumeration getInitParameterNames()
    {
        return new IteratorEnumeration(initParameter.keySet().iterator());
    }

    //non interface method
    public void addInitParameter(String key,String value)
    {
        initParameter.put(key,value);
    }    
    public void setServletContext(ServletContext servletContext)
    {
        this.servletContext = servletContext;
    }
    public void setServletName(String servletName)
    {
        this.servletName = servletName;
    }
}
