package net.souko105.flashserver.javaee.imp;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import net.souko105.flashserver.HttpHeaderConst;
import net.souko105.flashserver.HttpRequestBody;
import net.souko105.flashserver.HttpRequestHeader;

import org.apache.commons.collections.iterators.IteratorEnumeration;

/**
 * HttpServletRequestNX
 * @author AKatayama
 */
public class HttpServletRequestImp implements HttpServletRequest
{
    private String requestURL;
    private String servletPath;
    private String protocol = "HTTP/1.1";
    private String scheme = "http";
    private int serverPort;
    private int localPort;
    private int remotePort;
    private String remoteAddr;
    private String localAddr;
    private String remoteHost;
    private Locale locale = Locale.getDefault();
    
    private Map attribute = new HashMap();
    private HttpRequestHeader header;
    private HttpRequestBody body;
    
    private Servlet servlet;
    
    public HttpServletRequestImp()
    {
        super();
    }
    public String getHeader(String paramName)
    {
        return header.getHeader(paramName);
    }
    public Enumeration getHeaders(String arg0)
    {
        return new IteratorEnumeration(header.getHeaders().iterator());
    }
    public Enumeration getHeaderNames()
    {
        return new IteratorEnumeration(header.getHeaderName().iterator());
    }
    public int getIntHeader(String paramName){
        String val = header.getHeader(paramName);
        if (val!=null)
            return Integer.parseInt(val);
        return -1;
    }
    public String getMethod()
    {
        return header.getMethod();
    }
    public String getQueryString()
    {
        return header.getQueryString();
    }
    public Object getAttribute(String key)
    {
        return attribute.get(key);
    }
    public Enumeration getAttributeNames()
    {
        return new IteratorEnumeration(attribute.keySet().iterator());
    }
    public String getCharacterEncoding()
    {
    	String enc = body.getParameters().getCharacterEncodin();
    	return enc;
    }
    public void setCharacterEncoding(String encoding)
            throws UnsupportedEncodingException
    {
    	//check
    	URLDecoder.decode("",encoding);
    	body.getParameters().setCharacterEncoding(encoding);
    }
    public int getContentLength()
    {        
        String length = getHeader(HttpHeaderConst.CONTENTLENGTH);
        if(length == null)
            return 0;
        else
            return Integer.parseInt(length);
    }
    public String getContentType()
    {
        return header.getHeader(HttpHeaderConst.CONTENTTYPE);
    }
    public ServletInputStream getInputStream() throws IOException
    {
        final byte[] data = body.getBodyData();
        ServletInputStream sIs = new ServletInputStream(){
            private InputStream is = new ByteArrayInputStream(data);
            public int read() throws IOException{
                return is.read();
            }
        };
        return sIs;
    }
    public String getParameter(String key)
    {
        return body.getParameters().getParamter(key);
    }
    public Enumeration getParameterNames()
    {
        Iterator paramNameItr = body.getParameters().getParameterNames();
        return new IteratorEnumeration(paramNameItr);
    }
    public String[] getParameterValues(String key)
    {
        return body.getParameters().getParamterValues(key);
    }
    public Map getParameterMap()
    {
        return body.getParameters().getParamterMap();
    }
    public String getProtocol()
    {
        return protocol;
    }
    public BufferedReader getReader() throws IOException
    {
        byte[] data = body.getBodyData();
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        BufferedReader reader = new BufferedReader(new InputStreamReader(bin));
        return reader;
    }
    public void setAttribute(String key, Object value)
    {
        this.attribute.put(key,value);
    }
    public void removeAttribute(String key)
    {
        this.attribute.remove(key);
    }
    public String getContextPath()
    {
        return servlet.getServletConfig().getServletContext().getServletContextName(); 
    }
    public StringBuffer getRequestURL()
    {
        return new StringBuffer(requestURL);
    }
    public Cookie[] getCookies()
    {
        List cookieList = header.getCookieList();
        Cookie[] cookies = (Cookie[])cookieList.toArray(new Cookie[]{});
        return cookies;
    }
    /**
     * ZbV̎擾@VK쐬ɂ́AHttpHeader̃ZbVID܂B
     */
    public HttpSession getSession(boolean create)
    {
        String sessionId = getRequestedSessionId();
        ServletContext servletContext = servlet.getServletConfig().getServletContext();
        if(sessionId == null)
        {
            if(create)
            {
	            HttpSession session = SessionManager.getInstance().createNewSession(servletContext);
	            header.addCookie(HttpHeaderConst.SESSIONID_KEY,session.getId());
	            return session;
            }
            else
                return null;
        }            
        else
        {
            HttpSession session = SessionManager.getInstance().getSession(sessionId,create,servletContext);
            if(!sessionId.equals(session.getId()))
                header.addCookie(HttpHeaderConst.SESSIONID_KEY,session.getId());
            return session;
        }               
    }
    public HttpSession getSession()
    {
        return getSession(true);
    }
    public String getRequestedSessionId()
    {        
        Cookie cookie = header.getCookie(HttpHeaderConst.SESSIONID_KEY);
        if(cookie != null)
            return cookie.getValue();
        else
            return null;
    }
    public String getRequestURI()
    {
        return header.getRequestURI(); 
    }
    public String getServletPath()
    {
        return servletPath; 
    }    
    public String getScheme()
    {
        return scheme;
    }
    public String getServerName()
    {
    	String host = header.getHeader(HttpHeaderConst.HOST);
    	if(host.indexOf(":") > 0)
    		return host.substring(0,host.indexOf(":"));
    	else
    		return host;
    }
    public int getServerPort()
    {
    	return serverPort;
//    	String host = header.getHeader(HttpHeaderConst.HOST);
//    	if(host.indexOf(":") > 0)
//    	{
//    		int port = Integer.parseInt(host.substring(host.indexOf(":")+1));
//    		return port;
//    	}
//    	else
//    	{
//    		if(getScheme().equals("http"))
//    			return 80;
//    		if(getScheme().equals("https"))
//    			return 443;
//    		else
//    			throw new RuntimeException("getServerPort fail.");
//    	}
    }
    public int getLocalPort()
    {
        return localPort;
    }
    public Locale getLocale()
    {
        return locale;
    }
    public int getRemotePort()
    {
        return remotePort;
    }
    public String getLocalName()
    {
        return locale.getCountry();
    }
    public Enumeration getLocales()
    {
    	Vector vec = new Vector();
    	Locale[] locales = Locale.getAvailableLocales();
    	if(locales != null)
    	{
    		for(int i = 0;i < locales.length;i++)
    			vec.add(locales[i]);
    	}    	
        return vec.elements(); 
    }
    public RequestDispatcher getRequestDispatcher(String path)
    {
    	return servlet.getServletConfig().getServletContext().getRequestDispatcher(path);
    }
    
    
    public String getRemoteAddr()
    {
        return remoteAddr;
    }
    public String getRemoteHost()
    {
        return remoteHost;
    }
    public boolean isSecure()
    {
        return false;
    }
    public String getRealPath(String path)
    {
        return null;
    }
    public String getLocalAddr()
    {
        return localAddr;
    }
    public String getAuthType(){ return null; }
    public long getDateHeader(String name){ return 0; }
    public String getPathInfo(){ return null; }
    public String getPathTranslated(){ return null; }
    public String getRemoteUser(){ return null; }
    public boolean isUserInRole(String arg0){ return false; }
    public Principal getUserPrincipal(){ return null; }
    public boolean isRequestedSessionIdValid(){ return false; }
    public boolean isRequestedSessionIdFromCookie(){ return false; }
    public boolean isRequestedSessionIdFromURL(){ return false; }
    public boolean isRequestedSessionIdFromUrl(){ return false; }

    ///non interfacemethod
    public void setServletPath(String servletPath)
    {
        this.servletPath = servletPath;         
    }
    public void setHeader(HttpRequestHeader header)
    {
        this.header = header;
    }   
    public HttpRequestHeader getHeader()
    {
    	return this.header;
    }
    public void setBody(HttpRequestBody body)
    {
        this.body = body;
    }
    public HttpRequestBody getBody()
    {
    	return this.body;
    }
    public void setServlet(Servlet servlet)
    {
        this.servlet = servlet;        
    }
    public void setServerPort(int port)
    {
    	this.serverPort = port;
    }
    public void setLocalPort(int port)
    {
    	this.localPort = port;
    }
    public void setRemotePort(int port)
    {
    	this.remotePort = port;
    }
    public void setLocalAddr(String localAddr)
	{
		this.localAddr = localAddr;
	}
    public void setRemoteAddr(String remoteAddr)
	{
		this.remoteAddr = remoteAddr;
	}
    public void setRemoteHost(String remoteHost)
	{
		this.remoteHost = remoteHost;
	}
}