package net.souko105.flashserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.Cookie;

/**
 * HTTPX|X̃wb_[
 * @author AKatayama
 */
public class HttpResponseHeader
{
    private String version = HttpHeaderConst.HTTP_1_1;
    private int statusCode = HttpHeaderConst.SC_OK;
    private String status = HttpHeaderConst.findStatus(HttpHeaderConst.SC_OK);
    
    private Map headerFieldMap = new HashMap();
    private List headerFieldNameList = new LinkedList();
    private Map cookieMap = new HashMap();
    private List cookieNameList = new LinkedList();
    
    public HttpResponseHeader()
    {
        super();
    }
    
    public String getStatus()
    {
        return status;
    }
    public void setStatus(String status)
    {
        this.status = status;
    }
    public int getStatusCode()
    {
        return statusCode;
    }
    public void setStatusCode(int statusCode)
    {
        this.statusCode = statusCode;
    }
    public String getVersion()
    {
        return version;
    }
    public void setVersion(String version)
    {
        this.version = version;
    }
    
    public void addCookie(Cookie cookie)
    {
        if(!cookieMap.containsKey(cookie.getName()))
            cookieNameList.add(cookie.getName());
        cookieMap.put(cookie.getName(),cookie);
    }
    public String getHeader(String paramName)
    {
        return (String)headerFieldMap.get(paramName);
    }
    public void addHeader(String name,String value)
    {
        if(!headerFieldMap.containsKey(name))
            headerFieldNameList.add(name);
        headerFieldMap.put(name,value);
    }
    public List getHeaderName()
    {
        return headerFieldNameList;
    }
    public List getHeaders(){
        List list = new ArrayList();
        for(Iterator itr = headerFieldNameList.iterator();itr.hasNext();)
            list.add(headerFieldMap.get(itr.next()));
        return list;
    }    
    public void removeHeader(String paramName)
    {
        headerFieldMap.remove(paramName);
        headerFieldNameList.remove(paramName);
    }
    public boolean containsHeader(String name)
    {
        if(headerFieldMap.get(name) == null)
            return false;
        else
            return true;
    }
    public String getHeaderString()
    {
        StringBuffer buf = new StringBuffer();
        buf.append(this.version + " " + statusCode + " " + status + HttpHeaderConst.CRLF_STRING);
        for(Iterator itr = headerFieldNameList.iterator();itr.hasNext();)
        {
            String headerName = (String)itr.next();
            String headerValue = (String)headerFieldMap.get(headerName);
            buf.append(headerName + HttpHeaderConst.COLON_STRING + headerValue + HttpHeaderConst.CRLF_STRING);
        }
        for(Iterator itr = cookieNameList.iterator();itr.hasNext();)
        {
            String cookieName = (String)itr.next();
            Cookie cookie = (Cookie)cookieMap.get(cookieName);
            buf.append(HttpHeaderConst.SETCOOKIE+HttpHeaderConst.COLON_STRING);
            buf.append(cookie.getName() + "=" + cookie.getValue() +HttpHeaderConst.SEMI_COLON_STRING);
            //TODO cookie implement            
            buf.append(HttpHeaderConst.CRLF_STRING);
        }
        return buf.toString();
    }
}
