package net.souko105.flashserver;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.StringTokenizer;

/**
 * HTTPNGXgBody
 * @author AKatayama
 */
public class HttpRequestBody
{
    private HttpParameters parameters;
    private HttpRequestHeader header;
    private byte[] bodyData;
    
    public HttpRequestBody(HttpRequestHeader header)
    {
        this.header = header;
        parameters = new HttpParameters(this);
        
    }
    public HttpRequestBody(HttpRequestHeader header,byte[] bodyData)
    {
        this.header = header;
        this.bodyData = bodyData;
        parameters = new HttpParameters(this);
    }
    /**
     * HttpParameters#getParameterĂ΂ꂽɌĂ΂܂B
     */
    void initParameters()
    {
        if(header.getQueryString() != null)
            parseRequestQuery(header.getQueryString(),"UTF-8");//GETUTF-8
        if(bodyData != null && header.getMethod().equals(HttpHeaderConst.POST))
        {
            String contType = header.getHeader(HttpHeaderConst.CONTENTTYPE);
            if(contType != null && contType.equals(HttpHeaderConst.WWW_FORM_URLENCODE))
            {
            	try
            	{
            		parseRequestQuery(new String(bodyData,HttpParameters.DEFAULT_CHAR_ENCODE),parameters.getCharacterEncodin());
            	}
            	catch(Exception e)
            	{
            		throw new RuntimeException(e);
            	}
            }
        }
    }
    private void parseRequestQuery(String query,String encode)
    {
        StringTokenizer paramToken = new StringTokenizer(query,"&",false);
        
        while(paramToken.hasMoreElements())
        {
            String param = paramToken.nextToken();
            StringTokenizer token = new StringTokenizer(param,"=",false);
            String key = token.nextToken();
            String value = null;
            if(token.hasMoreTokens())
            {
                value = token.nextToken();
                try
                {
                	key = decode(key,encode);
                    value = decode(value,encode);
                }
                catch(UnsupportedEncodingException e)
                {
                    throw new IllegalArgumentException(e.getMessage());
                }
            }
            parameters.addParameter(key,value);
        }
    }
    private String decode(String value,String encode) throws UnsupportedEncodingException
    {
    	value = URLDecoder.decode(value,HttpParameters.DEFAULT_CHAR_ENCODE);
    	value = new String(value.getBytes(HttpParameters.DEFAULT_CHAR_ENCODE),encode);
    	return value;
    }
    
    public byte[] getBodyData()
    {
        return bodyData;
    }
    public HttpRequestHeader getHeader()
    {
        return header;
    }
    public HttpParameters getParameters()
    {
        return parameters;
    }
}
