/*
 * Decompiled with CFR 0.152.
 */
package net.souko105.flashserver.javaee.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.souko105.flashserver.util.IOUtils;
import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

public class FileSavingServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String PARAM_APP_ROOT = "appRootPath";
    private String appRootPath;
    private Map mimeTypeMap = new HashMap();

    public void init() throws ServletException {
        this.appRootPath = this.getInitParameter(PARAM_APP_ROOT);
        if (this.appRootPath == null) {
            throw new ServletException("InitParameter [appRootPath] not found.");
        }
        this.initMime();
    }

    protected void initMime() throws ServletException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("mime.xml");
        if (is == null) {
            throw new ServletException("mime.xml not found.");
        }
        Digester digester = new Digester();
        digester.addCallMethod("mime/mime-mapping", "addMimeType", 2);
        digester.addCallParam("mime/mime-mapping/extension", 0);
        digester.addCallParam("mime/mime-mapping/mime-type", 1);
        digester.push((Object)this);
        try {
            digester.parse(is);
        }
        catch (IOException ioe) {
            throw new ServletException("Mime digest fail. " + ioe.getMessage());
        }
        catch (SAXException se) {
            throw new ServletException("Mime parse fail. " + se.getMessage());
        }
    }

    public void addMimeType(String ext, String type) {
        this.mimeTypeMap.put(ext, type);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doIt(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doIt(req, res);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doIt(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String uri = req.getRequestURI();
        String realPath = String.valueOf(this.appRootPath) + uri;
        File fileOrDir = new File(realPath);
        if (!fileOrDir.exists()) {
            res.setStatus(404);
            return;
        }
        if (!fileOrDir.isFile()) {
            res.setStatus(404);
            return;
        }
        File file = fileOrDir;
        Date lastModifyDate = new Date(file.lastModified());
        res.setHeader("Last-Modified", IOUtils.HEADER_DATE_FORMAT.format(lastModifyDate));
        String ifModified = req.getHeader("If-Modified-Since");
        if (!this.isModifiedSince(lastModifyDate, ifModified)) {
            res.setStatus(304);
            return;
        }
        FileInputStream fin = new FileInputStream(file);
        ServletOutputStream sout = res.getOutputStream();
        try {
            int size = IOUtils.copyStream(fin, (OutputStream)sout);
            this.setContentType(res, file);
            res.setContentLength(size);
            res.setStatus(200);
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            fin.close();
            sout.flush();
            sout.close();
            throw throwable;
        }
        {
            Object var12_14 = null;
            fin.close();
            sout.flush();
            sout.close();
            return;
        }
    }

    protected boolean isModifiedSince(Date fileLastModify, String ifModifiedSince) {
        if (ifModifiedSince == null) {
            return true;
        }
        try {
            long ifModifiedTime = IOUtils.HEADER_DATE_FORMAT.parse(ifModifiedSince.trim()).getTime();
            long lastModifyTime = fileLastModify.getTime();
            return lastModifyTime > ifModifiedTime;
        }
        catch (NumberFormatException ne) {
            return true;
        }
        catch (ParseException e) {
            return true;
        }
    }

    protected void setContentType(HttpServletResponse res, File file) {
        String name = file.getName();
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex >= 0) {
            try {
                String ext = name.substring(dotIndex + 1);
                String type = (String)this.mimeTypeMap.get(ext);
                if (type == null) {
                    type = (String)this.mimeTypeMap.get(ext.toLowerCase());
                }
                if (type == null) {
                    type = (String)this.mimeTypeMap.get(ext.toUpperCase());
                }
                if (type != null) {
                    res.setContentType(type);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        res.setContentType("text/html");
    }
}

