/*
 * Decompiled with CFR 0.152.
 */
package net.souko105.flashserver.javaee.imp;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.apache.commons.collections.iterators.IteratorEnumeration;

public class HttpSessionImp
implements HttpSession {
    private String id;
    private long creationTime;
    private long lastAccessedTime;
    private ServletContext servletContext;
    private int maxInactiveInterval;
    private Map attributeMap = new HashMap();
    private boolean invalidate = false;
    private boolean isNew = true;

    public HttpSessionImp(String sessionId) {
        this.id = sessionId;
        this.creationTime = System.currentTimeMillis();
    }

    public long getCreationTime() {
        this.checkInvalidate();
        return this.creationTime;
    }

    public String getId() {
        this.checkInvalidate();
        return this.id;
    }

    public long getLastAccessedTime() {
        this.checkInvalidate();
        return this.lastAccessedTime;
    }

    public ServletContext getServletContext() {
        this.checkInvalidate();
        return this.servletContext;
    }

    public void setMaxInactiveInterval(int interval) {
        this.checkInvalidate();
        this.maxInactiveInterval = interval;
    }

    public int getMaxInactiveInterval() {
        this.checkInvalidate();
        return this.maxInactiveInterval;
    }

    public HttpSessionContext getSessionContext() {
        throw new RuntimeException("getSessionConetxt not implemented");
    }

    public Object getAttribute(String key) {
        this.checkInvalidate();
        return this.attributeMap.get(key);
    }

    public Object getValue(String key) {
        this.checkInvalidate();
        return this.getAttribute(key);
    }

    public Enumeration getAttributeNames() {
        this.checkInvalidate();
        return new IteratorEnumeration(this.attributeMap.keySet().iterator());
    }

    public String[] getValueNames() {
        this.checkInvalidate();
        return this.attributeMap.keySet().toArray(new String[0]);
    }

    public void setAttribute(String key, Object value) {
        this.checkInvalidate();
        this.attributeMap.put(key, value);
    }

    public void putValue(String key, Object value) {
        this.checkInvalidate();
        this.setAttribute(key, value);
    }

    public void removeAttribute(String key) {
        this.checkInvalidate();
        this.attributeMap.remove(key);
    }

    public void removeValue(String key) {
        this.checkInvalidate();
        this.removeAttribute(key);
    }

    public void invalidate() {
        this.invalidate = true;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isInvalidate() {
        return this.invalidate;
    }

    private void checkInvalidate() {
        if (this.invalidate) {
            throw new RuntimeException("Session invalidated.");
        }
    }

    public void setInvalidate(boolean invalidate) {
        this.invalidate = invalidate;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

