/*
 * Decompiled with CFR 0.152.
 */
package net.souko105.flashserver.javaee.imp;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.souko105.flashserver.HttpRequestBody;
import net.souko105.flashserver.HttpRequestHeader;
import net.souko105.flashserver.javaee.imp.SessionManager;
import org.apache.commons.collections.iterators.IteratorEnumeration;

public class HttpServletRequestImp
implements HttpServletRequest {
    private String requestURL;
    private String servletPath;
    private String protocol = "HTTP/1.1";
    private String scheme = "http";
    private int serverPort;
    private int localPort;
    private int remotePort;
    private String remoteAddr;
    private String localAddr;
    private String remoteHost;
    private Locale locale = Locale.getDefault();
    private Map attribute = new HashMap();
    private HttpRequestHeader header;
    private HttpRequestBody body;
    private Servlet servlet;

    public String getHeader(String paramName) {
        return this.header.getHeader(paramName);
    }

    public Enumeration getHeaders(String arg0) {
        return new IteratorEnumeration(this.header.getHeaders().iterator());
    }

    public Enumeration getHeaderNames() {
        return new IteratorEnumeration(this.header.getHeaderName().iterator());
    }

    public int getIntHeader(String paramName) {
        String val = this.header.getHeader(paramName);
        if (val != null) {
            return Integer.parseInt(val);
        }
        return -1;
    }

    public String getMethod() {
        return this.header.getMethod();
    }

    public String getQueryString() {
        return this.header.getQueryString();
    }

    public Object getAttribute(String key) {
        return this.attribute.get(key);
    }

    public Enumeration getAttributeNames() {
        return new IteratorEnumeration(this.attribute.keySet().iterator());
    }

    public String getCharacterEncoding() {
        String enc = this.body.getParameters().getCharacterEncodin();
        return enc;
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        URLDecoder.decode("", encoding);
        this.body.getParameters().setCharacterEncoding(encoding);
    }

    public int getContentLength() {
        String length = this.getHeader("Content-Length");
        if (length == null) {
            return 0;
        }
        return Integer.parseInt(length);
    }

    public String getContentType() {
        return this.header.getHeader("Content-Type");
    }

    public ServletInputStream getInputStream() throws IOException {
        byte[] data = this.body.getBodyData();
        ServletInputStream sIs = new ServletInputStream(data){
            private InputStream is;
            {
                this.is = new ByteArrayInputStream(byArray);
            }

            public int read() throws IOException {
                return this.is.read();
            }
        };
        return sIs;
    }

    public String getParameter(String key) {
        return this.body.getParameters().getParamter(key);
    }

    public Enumeration getParameterNames() {
        Iterator paramNameItr = this.body.getParameters().getParameterNames();
        return new IteratorEnumeration(paramNameItr);
    }

    public String[] getParameterValues(String key) {
        return this.body.getParameters().getParamterValues(key);
    }

    public Map getParameterMap() {
        return this.body.getParameters().getParamterMap();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public BufferedReader getReader() throws IOException {
        byte[] data = this.body.getBodyData();
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        BufferedReader reader = new BufferedReader(new InputStreamReader(bin));
        return reader;
    }

    public void setAttribute(String key, Object value) {
        this.attribute.put(key, value);
    }

    public void removeAttribute(String key) {
        this.attribute.remove(key);
    }

    public String getContextPath() {
        return this.servlet.getServletConfig().getServletContext().getServletContextName();
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.requestURL);
    }

    public Cookie[] getCookies() {
        List cookieList = this.header.getCookieList();
        Cookie[] cookies = cookieList.toArray(new Cookie[0]);
        return cookies;
    }

    public HttpSession getSession(boolean create) {
        String sessionId = this.getRequestedSessionId();
        ServletContext servletContext = this.servlet.getServletConfig().getServletContext();
        if (sessionId == null) {
            if (create) {
                HttpSession session = SessionManager.getInstance().createNewSession(servletContext);
                this.header.addCookie("JSESSIONID", session.getId());
                return session;
            }
            return null;
        }
        HttpSession session = SessionManager.getInstance().getSession(sessionId, create, servletContext);
        if (!sessionId.equals(session.getId())) {
            this.header.addCookie("JSESSIONID", session.getId());
        }
        return session;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public String getRequestedSessionId() {
        Cookie cookie = this.header.getCookie("JSESSIONID");
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    public String getRequestURI() {
        return this.header.getRequestURI();
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        String host = this.header.getHeader("Host");
        if (host.indexOf(":") > 0) {
            return host.substring(0, host.indexOf(":"));
        }
        return host;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getLocalName() {
        return this.locale.getCountry();
    }

    public Enumeration getLocales() {
        Vector<Locale> vec = new Vector<Locale>();
        Locale[] locales = Locale.getAvailableLocales();
        if (locales != null) {
            int i = 0;
            while (i < locales.length) {
                vec.add(locales[i]);
                ++i;
            }
        }
        return vec.elements();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.servlet.getServletConfig().getServletContext().getRequestDispatcher(path);
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public boolean isSecure() {
        return false;
    }

    public String getRealPath(String path) {
        return null;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public String getAuthType() {
        return null;
    }

    public long getDateHeader(String name) {
        return 0L;
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getRemoteUser() {
        return null;
    }

    public boolean isUserInRole(String arg0) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public void setHeader(HttpRequestHeader header) {
        this.header = header;
    }

    public HttpRequestHeader getHeader() {
        return this.header;
    }

    public void setBody(HttpRequestBody body) {
        this.body = body;
    }

    public HttpRequestBody getBody() {
        return this.body;
    }

    public void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    public void setServerPort(int port) {
        this.serverPort = port;
    }

    public void setLocalPort(int port) {
        this.localPort = port;
    }

    public void setRemotePort(int port) {
        this.remotePort = port;
    }

    public void setLocalAddr(String localAddr) {
        this.localAddr = localAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }
}

