/*
 * Decompiled with CFR 0.152.
 */
package net.souko105.flashserver;

import java.util.LinkedList;
import java.util.List;
import net.souko105.flashserver.SocketProcessor;
import net.souko105.flashserver.log.FlashServerLog;
import net.souko105.flashserver.log.FlashServerLogFactory;

class SocketProcessorPool {
    private static final FlashServerLog log;
    private int maxThreadPoolNum;
    private List threadList = new LinkedList();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.souko105.flashserver.SocketProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = FlashServerLogFactory.getLog(clazz);
    }

    SocketProcessorPool(int maxThreadPoolNum) {
        this.maxThreadPoolNum = maxThreadPoolNum;
        this.init();
    }

    private void init() {
        int i = 0;
        while (i < this.maxThreadPoolNum) {
            SocketProcessor processor = new SocketProcessor("socketprocessor:init" + i);
            processor.start();
            this.threadList.add(processor);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SocketProcessor getProcessor() {
        List list = this.threadList;
        synchronized (list) {
            if (this.threadList.isEmpty()) {
                SocketProcessor processor = new SocketProcessor("socketprocessor:" + System.currentTimeMillis());
                processor.start();
                log.debug("crate processor " + processor.getName());
                return processor;
            }
            SocketProcessor processor = (SocketProcessor)this.threadList.remove(0);
            log.debug("get processor " + processor.getName());
            return processor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnProcessor(SocketProcessor processor) {
        List list = this.threadList;
        synchronized (list) {
            if (this.threadList.size() < this.maxThreadPoolNum) {
                log.debug("return processor" + processor.getName());
                this.threadList.add(processor);
            } else {
                log.debug("stop processor " + processor.getName());
                processor.stopProcessor();
            }
        }
    }
}

