#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <string.h>
//#include <stdio.h>
//#include <stdlib.h>
#include <glib.h>

#include "interface.h"
#include "support.h"
#include "display.h"
#include "main.h"

void
DisplayVariousImages (GtkWidget * window, sotsuval sv)
{
  /******************************************
   * 画像の出力
   *
   ******************************************/
	
  const gint ProgMaxDays = 11;
  /* Ducks(Ahiru) */
  GtkWidget *fixed1 = (GtkWidget *) lookup_widget (window, "fixed1");
  GtkWidget *Image1 = (GtkWidget *) lookup_widget (window, "image1");
  GtkWidget *Image2 = (GtkWidget *) lookup_widget (window, "image2");
  GtkWidget *Image3 = (GtkWidget *) lookup_widget (window, "image3");
  GtkWidget *Image4 = (GtkWidget *) lookup_widget (window, "image4");
  GtkWidget *Image5 = (GtkWidget *) lookup_widget (window, "image5");
  GtkWidget *Image6 = (GtkWidget *) lookup_widget (window, "image6");
  gtk_widget_hide (Image1);
  gtk_widget_hide (Image2);
  gtk_widget_hide (Image3);
  gtk_widget_hide (Image4);
  gtk_widget_hide (Image5);
  gtk_widget_hide (Image6);
  if (sv.eDay >= 11)
    {
			gtk_fixed_move (GTK_FIXED (fixed1), Image1, 144, 208);
			gtk_widget_show (Image1);
    }
  if (sv.eDay >= 22)
    {
			gtk_fixed_move (GTK_FIXED (fixed1), Image3, 184, 208);
      gtk_widget_show (Image3);
    }
  if (sv.eDay >= 33)
    {
			gtk_fixed_move (GTK_FIXED (fixed1), Image1, 144, 216);  // 208 -> 216
			gtk_fixed_move (GTK_FIXED (fixed1), Image3, 184, 216);
			gtk_fixed_move (GTK_FIXED (fixed1), Image2, 224, 216);

			gtk_widget_show (Image2);
    }
  if (sv.eDay >= 44)
    {
		  gtk_widget_hide (Image1);
			gtk_widget_show (Image4);
    }
  if (sv.eDay >= 55)
    {
		  gtk_widget_hide (Image3);
			gtk_widget_show (Image6);
    }
  if (sv.eDay >= 66)
    {
		  gtk_widget_hide (Image2);
			gtk_widget_show (Image5);
    }

  /* Progressbar */

  GtkWidget *Progress1 = (GtkWidget *) lookup_widget (window, "progressbar1");
  if (sv.eDay < ProgMaxDays)
    {
      gtk_widget_show ((GtkWidget *) Progress1);
      gdouble pcnt;
      if (sv.eSec == 0)
	sv.eSec = 1;
      pcnt = (gdouble) sv.eSec / (gdouble) (60 * 60 * 24 * ProgMaxDays);
      gtk_progress_set_percentage ((GtkProgress *) Progress1, pcnt);
//      g_print ("pcnt->%f", pcnt);
    }
  else if (sv.eDay < ProgMaxDays * 2)
    {
      gtk_widget_show ((GtkWidget *) Progress1);
      gdouble pcnt;
      pcnt =
	(gdouble) (sv.eSec -
		   60 * 60 * 24 * ProgMaxDays) / (gdouble) (60 * 60 * 24 *
							    ProgMaxDays);
      gtk_progress_set_percentage ((GtkProgress *) Progress1, pcnt);
//      g_print ("pcnt->%f", pcnt);
    }
  else if (sv.eDay < ProgMaxDays * 3)
    {
      gtk_widget_show ((GtkWidget *) Progress1);
      gdouble pcnt;
      pcnt =
	(gdouble) (sv.eSec -
		   60 * 60 * 24 * ProgMaxDays * 2) / (gdouble) (60 * 60 * 24 *
								ProgMaxDays);
      gtk_progress_set_percentage ((GtkProgress *) Progress1, pcnt);
//      g_print ("pcnt->%f", pcnt);
    }
  else
    {
      gtk_widget_hide ((GtkWidget *) Progress1);
    }

  /* Lung(Hai) */
  GtkWidget *ImageH0 = (GtkWidget *) lookup_widget (window, "imageH0");
  GtkWidget *ImageH1 = (GtkWidget *) lookup_widget (window, "imageH1");
  GtkWidget *ImageH2 = (GtkWidget *) lookup_widget (window, "imageH2");
  GtkWidget *ImageH3 = (GtkWidget *) lookup_widget (window, "imageH3");
  GtkWidget *ImageH4 = (GtkWidget *) lookup_widget (window, "imageH4");
  GtkWidget *ImageH5 = (GtkWidget *) lookup_widget (window, "imageH5");
  GtkWidget *ImageH6 = (GtkWidget *) lookup_widget (window, "imageH6");

  if (sv.eDay < 3)
    {
      gtk_widget_show (ImageH0);
    }
  else
    {
      gtk_widget_hide (ImageH0);
    }
  if (sv.eDay >= 3 && sv.eDay < 7)
    {
      gtk_widget_show (ImageH1);
    }
  else
    {
      gtk_widget_hide (ImageH1);
    }
  if (sv.eDay >= 7 && sv.eDay < 21)
    {
      gtk_widget_show (ImageH2);
    }
  else
    {
      gtk_widget_hide (ImageH2);
    }
  if (sv.eDay >= 21 && sv.eDay < 49)
    {
      gtk_widget_show (ImageH3);
    }
  else
    {
      gtk_widget_hide (ImageH3);
    }
  if (sv.eDay >= 49 && sv.eDay < 98)
    {
      gtk_widget_show (ImageH4);
    }
  else
    {
      gtk_widget_hide (ImageH4);
    }
  if (sv.eDay >= 98 && sv.eDay < 196)
    {
      gtk_widget_show (ImageH5);
    }
  else
    {
      gtk_widget_hide (ImageH5);
    }
  if (sv.eDay >= 196)
    {
      gtk_widget_show (ImageH6);
    }
  else
    {
      gtk_widget_hide (ImageH6);
    }


}

gchar *
DisplayTodaysComment (sotsuval sv)
{
  /******************************************
   * 今日の一言
   *
   ******************************************/
  static gchar DispCmt[100];
  typedef struct _tablecmt
  {
    gint tDay;
    gchar tmsg[100];
    //gchar tmsg2[100];
  } tablecmt;

  tablecmt TableCmt[] = {
    {67, "油断は禁物です。一本だけオバケに注意してください"},
    {67, "煙草友達の喫煙の誘いには注意してください"},
    {67, "飲み会では特に注意してください"},
    {66, "卒煙して６６日目です。アヒルの王様が喜んでいます"},
    {56, "油断は禁物です。一本だけオバケに注意してください"},
    {56, "煙草友達の喫煙の誘いには注意してください"},
    {56, "飲み会では特に注意してください"},
    {55, "卒煙して５５日目です。アヒル隊長が喜んでいます"},
    {45, "油断は禁物です。一本だけオバケに注意してください"},
    {45, "煙草友達の喫煙の誘いには注意してください"},
    {45, "飲み会では特に注意してください"},
    {44, "卒煙して４４日目です。アヒル副隊長が喜んでいます"},
    {34, "油断は禁物です。一本だけオバケに注意してください"},
    {34, "煙草友達の喫煙の誘いには注意してください"},
    {34, "飲み会では特に注意してください"},
    {34, "そつえん いっかげつ おめでとぉー　がぁーがぁーがぁー"},
    {33,
     "卒煙して３３日目です。アヒルの王様がお祝いに来ました"},
    {31, "きれいな肺で、はーい元気（おやぢぎゃぐ２）"},
    {30, "人生を２度楽しめる。卒煙前と卒煙後"},
    {30,
     "油断は禁物です。一本だけオバケに注意してください"},
    {29, "吸いたくなったら、まずは大きく深呼吸です"},
    {28,
     "アヒル隊長から一言「もうすぐ一ヶ月達成です」"},
    {27, "もうタバコに無煙なわたし（おやぢぎゃぐ）"},
    {26,
     "卒煙したいという気持ちがある限り、必ずできるのです"},
    {25,
     "もし夢で煙草を吸っていたら、それはタバコ脳の断末魔"},
    {24,
     "タバコ臭いという理由だけで振られました・・・"},
    {23,
     "イライラしたら、気分転換。コーヒーか、お茶でもどーぞ"},
    {22,
     "卒煙して２２日目です。アヒル隊長がお祝いに来ました"},
    {21, "ヨシー！キター！３週間だ！エライゾー！！"},
    {20,
     "タバコの煙は有料ですが、おいしい空気は無料です"},
    {19, "タバコをやめた貴方の勇気に乾杯！"},
    {18,
     "臭い新幹線の喫煙車両、臭い空港の喫煙ルーム、さようなら"},
    {17,
     "ゆったり、ゆったり。ひとやすみ、ひとやすみ。"},
    {16,
     "大丈夫。卒煙した多くの先輩達が貴方の味方です"},
    {15,
     "一本だけ。それは絶対にダメ！一本吸ったら全て終わりです"},
    {14,
     "キターーー！！２週間だーーー！！よくやったーーー！！"},
    {13,
     "春夏秋冬、いつもおいしい空気。そして、おいしいごはん"},
    {12,
     "リラックス、リラックス。ひとやすみ、ひとやすみ。"},
    {11,
     "卒煙して１１日目です。アヒル副隊長がお祝いに来ました。"},
    {10,
     "「自分の意志で簡単にやめられない」←コレが煙草害の筆頭"},
    {9,
     "子供の頃を思い出そう。元々タバコなんて必要ないのです"},
    {8,
     "ゆったりと生活。のんびりと生活。けむりのない生活。"},
    {7,
     "よし！！一週間だ！！よくやった！！エライゾー！！"},
    {6,
     "このキツイ卒煙経験は、あなたを大きく成長させるでしょう"},
    {5,
     "タバコ＝血行不良＝皮膚への栄養不足＝皮膚カサカサ＝老化"},
    {4,
     "タバコにだまされてはいけません。ただの枯れた葉っぱです"},
    {3,
     "タバコは一時の満足、肺ガンは一生の苦しみ。やめるのは今！"},
    {3,
     "今日を乗り切れば、取り合えず一山越えたことになります"},
    {2, "根性です！今日は根性で乗り切るのです！"},
    {2,
     "ガンバレ！ガンバレ！ガンバレ！ガンバレ！ガンバレー！"},
    {2, "がんばれ、まけるな。がんばれ、まけるな。"},
    {2,
     "苦しくなったら気分転換！がんばれー！がんばれー！"},
    {1,
     "とにかく今日です！どんな手を使ってもいい！がんばれ！"},
    {1,
     "気合いだ！気合いだ！気合いだ！気合いだ！気合いだー！"},
    {1,
     "煮詰まったら、フッと肩の力を抜いてリラックスです"},
    {0,
     "さあ今日からいよいよ卒煙です！がんばりましょう！"},
    {-1, ""}
  };

  GRand *r = g_rand_new ();
  int i = 0;
  while (1)
    {
      if (sv.eDay >= TableCmt[i].tDay)
	{
	  while (sv.eDay == TableCmt[i + 1].tDay && g_rand_int (r) % 2)
	    i++;
	  strcpy (DispCmt, TableCmt[i].tmsg);
	  break;
	}
      i++;
    }
//  g_print ("sv.Month:%d", sv.Month);
  if (sv.Year == 0 && g_rand_int (r) % 2)
    {
      switch (sv.Month)
	{
	case 1:
	  strcpy (DispCmt,
		  "おめでとうございます。卒煙から１ヶ月経過しました。");
	  break;
	case 2:
	  strcpy (DispCmt,
		  "おめでとうございます。卒煙から２ヶ月経過しました。");
	  break;
	case 3:
	  strcpy (DispCmt,
		  "おめでとうございます。卒煙から３ヶ月経過しました。");
	  break;
	case 4:
	  strcpy (DispCmt,
		  "おめでとうございます。卒煙から４ヶ月経過しました。");
	  break;
	case 5:
	  strcpy (DispCmt,
		  "おめでとうございます。卒煙から５ヶ月経過しました。");
	  break;
	case 6:
	  strcpy (DispCmt,
		  "おめでとうございます。卒煙から６ヶ月経過しました。");
	  break;
	case 7:
	  strcpy (DispCmt,
		  "おめでとうございます。卒煙から７ヶ月経過しました。");
	  break;
	case 8:
	  strcpy (DispCmt,
		  "おめでとうございます。卒煙から８ヶ月経過しました。");
	  break;
	case 9:
	  strcpy (DispCmt,
		  "おめでとうございます。卒煙から９ヶ月経過しました。");
	  break;
	case 10:
	  strcpy (DispCmt,
		  "おめでとうございます。卒煙から１０ヶ月経過しました。");
	  break;
	case 11:
	  strcpy (DispCmt,
		  "おめでとうございます。卒煙から１１ヶ月経過しました。");
	  break;
	}
    }
  if (sv.Year == 1 && g_rand_int (r) % 2)
    {
      strcpy (DispCmt,
	      "～ ご卒煙おめでとうございます ～");
    }


  return DispCmt;
}

gchar *
DisplayCountNotSmoked (sotsuval sv)
{
  /******************************************
   * 吸わなかった本数
   * "999999本 99999.99m エベレスト１３個分"
   ******************************************/
  static gchar cns[100];
  gfloat honsu;
  gfloat nagasa;
  memset (cns, 0x00, sizeof (cns));

  gchar DispLen[50];
  typedef struct _tablelen
  {
    gfloat tlen;
    gchar tmsg[50];
  } tablelen;

  tablelen TableLen[] = {
    {800000.00, "成層圏を脱しました！"},
    {565400.00, "国道１号線"},
    {500000.00, "アマゾン川河口幅"},
    {367000.00, "信濃川"},
    {300000.00, "月最大のクレーター"},
    {120000.00, "デス・スター"},
    {53850.00, "青函トンネル全長"},
    {50490.00, "ユーロトンネル海底部"},
    {42195.00, "フルマラソン完走！"},
    {33300.00, "東京タワー１００本！"},
    {27200.00, "東京－横浜"},
    {26455.00, "八甲田トンネル"},
    {20580.00, "音が１分間に進む距離"},
    {14980.00, "奈良の大仏１０００体"},
    {10911.00, "マリアナ海溝"},
    {10000.00, "秋芳洞"},
    {9610.00, "アクアトンネル"},
    {9367.00, "瀬戸大橋総延長"},
    {8848.00, "エベレスト"},
    {8611.00, "Ｋ２"},
    {8516.00, "ローツェ"},
    {8020.00, "日本海溝最深部"},
    {6959.00, "南アメリカ最高峰"},
    {6194.00, "北アメリカ最高峰"},
    {5895.00, "アフリカ最高峰"},
    {5156.00, "アララト山"},
    {4897.00, "南極最高峰"},
    {4807.00, "ヨーロッパ最高峰"},
    {4424.00, "エベレスト５合目"},
    {4295.00, "ハワイ最高峰"},
    {4000.00, "成田空港Ａ滑走路"},
    {3975.00, "アイガー"},
    {3927.00, "１里"},
    {3911.00, "明石海峡大橋全長"},
    {3776.00, "富士山"},
    {3750.00, "関西国際空港連絡橋"},
    {3614.00, "関門鉄道トンネル下り"},
    {3604.00, "関門鉄道トンネル上り"},
    {3398.40, "富士山９合目"},
    {3330.00, "東京タワー１０本"},
    {3240.00, "エッフェル塔１０本"},
    {3180.00, "槍ヶ岳"},
    {3067.00, "御嶽山"},
    {3020.80, "富士山８合目"},
    {3015.00, "立山"},
    {2643.20, "富士山７合目"},
    {2630.00, "宇宙戦艦ヤマト１０艦"},
    {2620.00, "ホワイトベース１０艦"},
    {2555.00, "日本坂トンネル新"},
    {2530.00, "諏訪富士"},
    {2486.00, "男体山"},
    {2479.00, "スチールドラゴンの全長"},
    {2380.00, "日本坂トンネル旧左"},
    {2370.00, "日本坂トンネル旧右"},
    {2300.00, "地獄谷温泉標高"},
    {2290.00, "大雪山"},
    {2265.60, "富士山６合目"},
    {2236.00, "鳥海山"},
    {2228.00, "オーストラリア最高峰"},
    {2191.00, "恵那山"},
    {2077.00, "十勝岳"},
    {1982.00, "石鎚山天狗岳"},
    {1970.00, "ゴールデンゲート橋"},
    {1936.00, "屋久島"},
    {1888.00, "富士山５合目"},
    {1883.00, "富士見峠（群馬）"},
    {1852.00, "１海里"},
    {1834.00, "ブルックリン橋"},
    {1828.00, "赤城山"},
    {1819.00, "磐梯山"},
    {1790.00, "安房峠"},
    {1770.00, "夜叉神峠"},
    {1750.00, "三河港大橋"},
    {1734.00, "岩戸大橋"},
    {1729.00, "大山"},
    {1721.00, "利尻岳"},
    {1700.00, "高天ヶ原湿原"},
    {1672.00, "野麦峠"},
    {1665.00, "東京タワー５本"},
    {1660.00, "羅臼岳"},
    {1629.00, "大鳴門橋"},
    {1620.00, "バイカル湖最大深度"},
    {1609.34, "１マイル"},
    {1592.00, "阿蘇山"},
    {1584.00, "八甲田山"},
    {1523.00, "新富士川大橋"},
    {1510.40, "富士山４合目"},
    {1500.00, "上高地"},
    {1498.00, "奈良の大仏１００体"},
    {1486.00, "雲仙岳"},
    {1470.00, "タンガニーカ湖水深"},
    {1467.00, "船堀橋"},
    {1460.00, "クフ王のピラミッド１０個"},
    {1438.00, "箱根山"},
    {1436.00, "スプリング８"},
    {1425.00, "池間橋"},
    {1413.00, "石狩河口大橋"},
    {1405.00, "ペンタゴンの全周"},
    {1400.00, "尾瀬ヶ原"},
    {1377.00, "伊吹山"},
    {1359.00, "雲仙普賢岳"},
    {1346.00, "野辺山駅海抜"},
    {1332.00, "東京タワー４本"},
    {1300.00, "野辺山高原"},
    {1269.00, "中禅寺湖の標高"},
    {1219.00, "世界最長の滑り台"},
    {1200.00, "草津温泉標高"},
    {1190.00, "六本木ヒルズ５本"},
    {1189.00, "ドドンパの全長"},
    {1170.00, "名港中央大橋"},
    {1132.80, "富士山３合目"},
    {1124.80, "サンダードルフィンの全長"},
    {1117.00, "桜島"},
    {1100.00, "南備讃瀬戸大橋"},
    {1068.00, "関門橋"},
    {1030.00, "通天閣１０本"},
    {1020.00, "鶴見つばさ橋"},
    {1000.00, "乙女峠（神奈川）"},
    {999.00, "東京タワー３本"},
    {990.00, "北備讃瀬戸大橋"},
    {978.00, "エンジェルフォール"},
    {970.00, "自由の女神１０体"},
    {952.00, "六本木ヒルズ４本"},
    {948.00, "トゥゲラ滝"},
    {931.10, "六甲山"},
    {930.00, "黒部ダム５個"},
    {924.00, "開聞岳"},
    {897.40, "蓬莱橋"},
    {890.00, "多々羅大橋"},
    {884.80, "エベレスト１合目"},
    {876.00, "筑波山"},
    {860.00, "横浜ベイブリッジ"},
    {848.00, "比叡山"},
    {833.00, "大江山"},
    {800.00, "Burj Dubai（仮）"},
    {798.00, "レインボーブリッジ"},
    {764.00, "三原山"},
    {755.20, "富士山２合目"},
    {749.00, "奈良の大仏５０体"},
    {744.00, "黒部ダム４個"},
    {739.00, "ヨセミテ滝"},
    {732.00, "有珠山"},
    {730.00, "クフ王のピラミッド５個"},
    {714.00, "六本木ヒルズ３本"},
    {710.00, "コルコバードの丘"},
    {700.00, "サラワクチェンバー"},
    {695.00, "鳳来寺山"},
    {666.00, "東京タワー２本"},
    {654.50, "国会議事堂１０個"},
    {650.00, "海ほたる"},
    {642.00, "生駒山"},
    {640.00, "天保山大橋"},
    {628.80, "ＫＴＨＩテレビ塔"},
    {627.00, "若戸大橋"},
    {610.00, "新東京タワー（予定）"},
    {600.00, "打ち上げ花火３０号の高さ"},
    {599.00, "高尾山"},
    {584.00, "クフ王のピラミッド４個"},
    {580.00, "サザーランド滝"},
    {564.00, "京都駅１番ホーム"},
    {562.00, "ボールズ・ピラミッド"},
    {553.33, "世界最高の独立建築物"},
    {550.00, "Lupu daqiao"},
    {549.00, "ケベック橋"},
    {546.00, "新尾道大橋"},
    {537.00, "オスタンキノタワー"},
    {527.00, "コロセウム外周"},
    {526.00, "於茂登岳"},
    {524.00, "ホワイトベース２艦"},
    {520.00, "津波の世界記録"},
    {516.00, "カレル橋"},
    {513.00, "白蓮洞の縦穴"},
    {510.00, "シンデレラ城１０城"},
    {509.00, "台北１０１"},
    {503.00, "与那覇岳"},
    {492.86, "ドラコン世界記録"},
    {490.00, "生口橋"},
    {486.00, "仁徳天皇陵"},
    {485.00, "自由の女神５体"},
    {476.00, "六本木ヒルズ２本"},
    {475.00, "シアーズタワー（避雷針付）"},
    {468.00, "上海テレビ塔"},
    {458.45, "ヤーレ・バイキング号"},
    {455.00, "対馬オメガ局電波標識塔"},
    {452.00, "ペトロナスツインタワー"},
    {442.00, "シアーズタワー"},
    {438.00, "クフ王のピラミッド３個"},
    {426.00, "ジブラルタロック"},
    {425.00, "応神天皇陵"},
    {423.00, "田沢湖の深さ"},
    {422.00, "讃岐富士"},
    {417.00, "ＷＴＣ（ＮＹ）"},
    {402.00, "昭和新山"},
    {400.00, "陸上トラック１周"},
    {381.00, "エンパイヤステートビル"},
    {380.00, "ニッケル社大煙突"},
    {378.50, "日精丸"},
    {377.60, "富士山１合目"},
    {376.00, "ゴロンドリナス洞窟"},
    {375.00, "竜神大吊橋"},
    {372.00, "黒部ダム２個"},
    {365.00, "ベルリンテレビ塔"},
    {360.00, "百舌鳥陵山"},
    {350.00, "エアーズロック"},
    {348.00, "高雄タワー"},
    {343.00, "音が１秒間に進む距離"},
    {342.00, "奈良の若草山"},
    {335.00, "東京駅丸の内駅舎"},
    {333.00, "東京タワー"},
    {330.00, "横須賀基地のドック"},
    {327.25, "国会議事堂５個"},
    {324.00, "エッフェル塔"},
    {321.00, "プリ・アリ・アラブホテル"},
    {320.00, "もみじ谷橋"},
    {319.00, "クライスラービル"},
    {314.20, "クイーンエリザベス号"},
    {310.59, "余部橋梁"},
    {310.00, "アゼリーテレビタワー"},
    {305.00, "新木津川大橋"},
    {300.00, "鶴の舞橋"},
    {298.00, "明石海峡大橋主塔"},
    {297.00, "大三島橋"},
    {296.00, "横浜ランドマークタワー"},
    {293.50, "クイーンエリザベス２世号"},
    {292.00, "クフ王のピラミッド２個"},
    {288.00, "シーファーストセンター"},
    {285.00, "チチカカ湖水深"},
    {281.00, "ペンタゴンの一辺"},
    {280.00, "日本一長いラーメン"},
    {276.00, "東京駅の長さ"},
    {275.00, "ボンデュガール水道橋"},
    {270.00, "羽衣の滝"},
    {268.00, "タイタニック号"},
    {266.50, "盧溝橋"},
    {263.00, "宇宙戦艦ヤマト"},
    {262.00, "ホワイトベース"},
    {260.00, "西郷大橋"},
    {259.00, "ロックフェラーセンター"},
    {256.00, "りんくうゲートタワー"},
    {255.00, "シンデレラ城５城"},
    {254.00, "新浜寺大橋"},
    {252.00, "大阪ＷＴＣ"},
    {250.00, "東京タワー特別展望台"},
    {248.00, "東京ミッドタウン"},
    {247.00, "ミッドランドスクエア"},
    {246.00, "ヒンデンブルグ号"},
    {245.00, "ＪＲセントラルタワーズ"},
    {243.00, "東京都庁舎"},
    {240.00, "サンシャイン６０"},
    {239.00, "代々木ビル"},
    {238.00, "六本木ヒルズ"},
    {235.00, "オペラシティ"},
    {234.00, "福岡タワー"},
    {230.00, "ソウルタワー"},
    {220.00, "フーバーダム"},
    {216.00, "新宿センタービル"},
    {214.50, "スキージャンプの最長"},
    {210.00, "宇宙船ディスカバリ号"},
    {209.00, "モンパルナスタワー"},
    {204.10, "最長のウェディングドレス"},
    {203.20, "新宿野村ビル"},
    {200.00, "層雲峡岩壁"},
    {199.20, "聖路加国際病院タワー"},
    {199.00, "畝傍山"},
    {195.00, "スカイタワー西東京"},
    {193.00, "日本テレビタワー"},
    {192.00, "ゲートウェイアーチ"},
    {189.00, "国道１７４号線全長"},
    {186.00, "黒部ダム"},
    {182.00, "オーク１番街ビル"},
    {180.00, "名古屋テレビ塔"},
    {178.00, "サグラダ・ファミリア（未完）"},
    {176.00, "高瀬ダム"},
    {174.00, "サンジャシント記念柱"},
    {173.00, "梅田スカイビル"},
    {172.80, "タイフーン級原潜"},
    {170.00, "フリーダイビング最高深度"},
    {169.00, "ワシントンモニュメント"},
    {166.50, "東京タワー五合目"},
    {165.00, "国連ビル（ＮＹ）"},
    {162.50, "ムササビ公式滑空距離"},
    {160.00, "シャトル組立工場"},
    {157.00, "ケルンの大聖堂"},
    {156.00, "霞ヶ関ビル"},
    {155.00, "渡月橋全長"},
    {153.00, "海峡ゆめタワー"},
    {152.00, "天香具山"},
    {150.00, "東京タワー展望台"},
    {149.80, "奈良の大仏１０体"},
    {147.20, "札幌テレビ塔"},
    {146.00, "クフ王のピラミッド"},
    {144.00, "大鳴門橋主塔"},
    {143.00, "セリオン"},
    {142.00, "ストラスブール大聖堂"},
    {141.00, "ヒヨケザル最大滑空距離"},
    {140.00, "キングギドラ平成"},
    {137.00, "クフ王のピラミッド現状"},
    {136.00, "サン・ピエトロ大聖堂"},
    {135.00, "ロンドン・アイ"},
    {134.00, "東山スカイタワー"},
    {133.00, "大倉山ジャンプ台"},
    {131.00, "京都タワー"},
    {126.00, "レインボーブリッジ主塔"},
    {125.00, "千葉ポートタワー"},
    {123.00, "エキスポタワー"},
    {120.00, "甲子園本塁センター間"},
    {118.00, "三十三間堂"},
    {115.00, "お台場大観覧車"},
    {113.50, "鎌倉の大仏１０体"},
    {112.50, "天保山大観覧車"},
    {112.00, "世界最大のセコイア"},
    {111.00, "セント・ポール大聖堂"},
    {110.60, "サターン５号"},
    {110.00, "国際宇宙ステーション"},
    {109.73, "アメフトグラウンド"},
    {109.09, "１町"},
    {108.00, "神戸ポートタワー"},
    {107.00, "ドゥオモ"},
    {106.00, "横浜マリンタワー"},
    {105.00, "サッカーグラウンド"},
    {103.80, "琵琶湖最大深度"},
    {103.00, "通天閣"},
    {102.00, "博多ポートタワー"},
    {100.00, "キングギドラ昭和"},
    {99.40, "シーウルフ級原潜"},
    {98.48, "槍投げ世界記録"},
    {97.00, "自由の女神"},
    {95.00, "ビッグベン"},
    {93.50, "スチールドラゴンの落差"},
    {91.00, "バベルの塔（推定）"},
    {90.38, "札幌テレビ塔展望台"},
    {90.00, "ノートルダム寺院"},
    {88.00, "愛・地球博の大観覧車"},
    {87.30, "成田空港新管制塔"},
    {86.74, "ハンマー投げ世界記録"},
    {85.40, "日本一の津波の高さ"},
    {85.00, "朱雀大路の幅"},
    {84.00, "ヤフードーム"},
    {83.20, "ルイジアナ・スーパードーム"},
    {83.09, "大阪ドーム"},
    {80.00, "デーモン小暮閣下"},
    {79.42, "東京ドームのビッグ・オー"},
    {79.00, "オシンコシンの滝"},
    {77.40, "えべっさんの大観覧車"},
    {76.00, "秦の始皇帝陵"},
    {75.00, "ジャンボジェット全長"},
    {74.08, "円盤投げ世界記録"},
    {71.00, "楽山大仏"},
    {70.00, "太陽の塔"},
    {68.00, "ガラタ塔"},
    {67.50, "世界一大きなドア"},
    {67.00, "オペラハウス"},
    {66.60, "スプルース・グース"},
    {65.45, "国会議事堂"},
    {65.00, "タジ・マハール"},
    {64.00, "初代通天閣"},
    {63.00, "根尾の滝"},
    {62.00, "ジェセル王の階段ピラミッド"},
    {60.00, "トイレットペーパー"},
    {59.60, "ビグ・ザム"},
    {58.00, "スーパーカミオカンデ"},
    {56.00, "新日本丸メインマスト"},
    {55.00, "ピサの斜塔"},
    {54.80, "東寺五重塔"},
    {54.00, "川崎マリエン"},
    {53.80, "なんだろう橋"},
    {53.00, "Ｈ２Ａロケット"},
    {52.00, "ナイアガラの滝"},
    {51.00, "シンデレラ城"},
    {50.00, "パリ凱旋門"},
    {49.30, "日本最高のはしご車"},
    {49.00, "東大寺大仏殿"},
    {48.00, "出雲ドーム"},
    {47.00, "いよてつ高島屋くるりん"},
    {46.35, "姫路城天守閣"},
    {45.00, "ウルトラの父"},
    {43.70, "日御碕灯台"},
    {43.00, "太陽の船"},
    {41.80, "高崎白衣大観音"},
    {41.20, "余部鉄橋の高さ"},
    {40.00, "ウルトラマン"},
    {38.00, "スペースマウンテン"},
    {37.00, "スペースシャトル"},
    {36.60, "ライト兄弟初飛行距離"},
    {36.50, "世界最大のクラゲ"},
    {36.00, "東照宮五重塔"},
    {35.40, "百尺観音（現状）"},
    {35.00, "薬師寺の西塔"},
    {34.10, "ピーナッツ投げ世界記録"},
    {33.60, "薬師寺の東塔"},
    {32.00, "ウシュマル遺跡ピラミッド"},
    {31.40, "ポロブドゥール寺院"},
    {31.20, "瑠璃光寺五重塔"},
    {31.00, "清水寺三重塔"},
    {30.80, "Ｍ－３ＳＩＩロケット"},
    {30.00, "シロナガスクジラ"},
    {28.90, "下駄飛ばし世界記録"},
    {28.00, "越前大仏"},
    {27.43, "野球の塁間距離"},
    {27.35, "新幹線先頭車両"},
    {27.00, "ストーンマウンテンの彫刻"},
    {26.00, "ディプロドクス"},
    {25.30, "縄文杉"},
    {25.10, "高野山大門"},
    {25.00, "グレートマジンガー"},
    {24.41, "日本水準原点"},
    {24.22, "蒲生の大クス"},
    {24.00, "立った鎌倉大仏（推定）"},
    {23.82, "フォックスバットＢ"},
    {23.77, "テニスコート"},
    {23.12, "砲丸投げ世界記録"},
    {22.50, "ナガスクジラ"},
    {22.00, "平城宮跡朱雀門"},
    {21.48, "蒸気機関車Ｃ６２炭水車付"},
    {21.10, "ＺＺガンダム"},
    {21.00, "ルーブル美術館のピラミッド"},
    {20.00, "道頓堀グリコのネオン"},
    {19.80, "ダイオウイカ"},
    {19.00, "フルトレーラー"},
    {18.70, "Ｚガンダム"},
    {18.44, "ピッチャーとホーム間距離"},
    {18.29, "三段跳び世界記録"},
    {18.00, "ガンダム(RX-78)"},
    {17.70, "世界最大のサボテン"},
    {17.50, "ガンキャノン(RX-77)"},
    {17.00, "シャア専用ザク"},
    {16.00, "諏訪大社の御柱"},
    {14.98, "奈良の大仏"},
    {14.68, "坂本龍馬像台座有"},
    {14.50, "アナコンダ"},
    {14.00, "マッコウクジラ"},
    {13.60, "平等院鳳凰堂"},
    {13.30, "ティラノサウルス"},
    {13.00, "出雲大社注連縄"},
    {12.50, "金閣寺"},
    {12.00, "竿灯（大人用標準）"},
    {11.37, "妖怪一反木綿"},
    {11.35, "鎌倉の大仏"},
    {11.10, "東照宮陽明門"},
    {10.60, "ジンベイザメ"},
    {10.20, "鉄人２８号"},
    {10.00, "蒸気機関車Ｄ５１"},
    {9.93, "土渕海峡"},
    {9.70, "長崎平和祈念像"},
    {8.95, "走り幅跳び世界記録"},
    {8.88, "大山カラス天狗像"},
    {8.42, "金剛力士立像吽形"},
    {8.36, "金剛力士立像阿形"},
    {8.20, "すばる望遠鏡の口径"},
    {8.00, "西郷隆盛像鹿児島"},
    {7.50, "小林幸子孔雀の衣装"},
    {7.20, "樽沢トンネル"},
    {7.00, "楽山大仏の耳"},
    {6.70, "ブガッティ・ロワイヤル４１"},
    {6.60, "イルカのジャンプ"},
    {6.37, "アポロ月着陸船"},
    {6.25, "アミメニシキヘビ"},
    {6.14, "棒高跳び世界記録"},
    {6.00, "尾長鶏の尻尾"},
    {5.90, "クロコダイル"},
    {5.80, "キリンのジョージ"},
    {5.40, "日本最大のヒマワリ"},
    {5.25, "坂本龍馬像台座無"},
    {5.03, "レクサスＬＳ"},
    {5.00, "日本一の鬼瓦"},
    {4.68, "フォーミュラ１"},
    {4.55, "大相撲土俵直径"},
    {4.50, "天保山"},
    {4.43, "フェラーリＦ４０"},
    {4.20, "マカジキ"},
    {4.00, "ティラノサウルス"},
    {3.96, "アフリカゾウ"},
    {3.71, "西郷隆盛像上野"},
    {3.42, "高枝切り鋏"},
    {3.40, "軽自動車の全長"},
    {3.27, "知恩院の鐘"},
    {3.00, "ラグビークロスバー"},
    {2.85, "アカカンガルー♂全長"},
    {2.75, "キタアフリカダチョウ"},
    {2.72, "人間の身長世界記録"},
    {2.45, "走り高跳び世界記録"},
    {2.43, "バレーボールのネット"},
    {2.25, "コモドオオトカゲ♂"},
    {2.14, "ミロのビーナス"},
    {2.10, "ラクダ"},
    {2.09, "ジャイアント馬場"},
    {2.02, "曙　太郎"},
    {1.95, "仮面ライダー"},
    {1.93, "リンカーン大統領"},
    {1.90, "男子立ち高飛び世界記録"},
    {1.85, "大相撲関取の平均身長"},
    {1.82, "１間"},
    {1.80, "鉛筆１０本"},
    {1.68, "シーラカンス"},
    {1.65, "ペガサス星矢"},
    {1.55, "郵便差出箱１号土台付き"},
    {1.52, "女子立ち高飛び世界記録"},
    {1.46, "Ｂ０版の長辺"},
    {1.44, "新幹線のレール幅"},
    {1.35, "郵便差出箱１号"},
    {1.29, "ドラえもん"},
    {1.20, "平均台の高さ"},
    {1.07, "線路の幅（狭軌）"},
    {1.06, "クレヨンしんちゃん"},
    {1.00, "新札１億円の高さ"},
    {0.85, "イチローのバット"},
    {0.40, "ノミのジャンプ"},
    {0.25, "バスケットボール"},
    {0.18, "鉛筆"},
    {0.11, "ダチョウの卵"},
    {0.00, "ガンバレ－"},
  };

  honsu = sv.CCount;
  nagasa = sv.CLen;

  int i = 0;
  while (1)
    {
      if (nagasa >= TableLen[i].tlen)
	{
	  strcpy (DispLen, TableLen[i].tmsg);
	  break;
	}
      i++;
    }

  if (myParam.DBC == TRUE)	// 箱数表示
    {
		  if ((gint) honsu % 200 == 0 && honsu != 0)
	    {
	      gint carton = (gint) (honsu / 200);
	      sprintf (cns, " %dカートン %.2fm %s", carton, nagasa, DispLen);
	    }
		  else if ((gint) honsu % 20 == 0 && honsu != 0)
	    {
	      gint carton = (gint) (honsu / 20);
	      sprintf (cns, " %d箱 %.2fm %s", carton, nagasa, DispLen);
	    }
		  else

  	  {
  	    sprintf (cns, " %d本 %.2fm %s", (gint) honsu, nagasa, DispLen);
  	  }

		}
  else
    {
      sprintf (cns, " %d本 %.2fm %s", (gint) honsu, nagasa, DispLen);
    }
/*			 
  if (myParam.DBC == TRUE && (gint) honsu % 200 == 0 && honsu != 0)
    {
      gint carton = (gint) (honsu / 200);
      sprintf (cns, " %dカートン %.2fm %s", carton, nagasa, DispLen);
      //sprintf (cns, "%dカートン %.2fm %s", (gint)honsu % 200, nagasa, DispLen);
    }
  else
    {
      sprintf (cns, " %d本 %.2fm %s", (gint) honsu, nagasa, DispLen);
    }
*/
  return cns;
}

gchar *
DisplaySavedMoney (sotsuval sv)
{
  /******************************************
   * 節約できた金額
   * "99999999円（節税分 999999円）"
   ******************************************/
  static gchar sm[30];
  memset (sm, 0x00, sizeof (sm));

  gint Dprice = sv.SavedMoney;
  gint Dtax = sv.SavedTax;
  sprintf (sm, " %d円（節税分 %d円）", Dprice, Dtax);

  return sm;

}

gchar *
DisplayLifeSpan (sotsuval sv)
{
  /******************************************
   * 延びた寿命
   * " %d日と %d時間 %d分"
   ******************************************/
  static gchar ls[30];
  memset (ls, 0x00, sizeof (ls));

  if (myParam.TCount == 0)
    {
      return ls;
    }
  gint eday = sv.LifeSpanDay;
  gint ehour = sv.LifeSpanHour;
  gint emin = sv.LifeSpanMin;

  sprintf (ls, " %d日と %d時間 %d分", eday, ehour, emin);

  return ls;
}

gchar *
DisplayStatus (gint eday)
{
  /******************************************
   * ステータス
   * " 大統領"
   ******************************************/
  static gchar sot[30];
  memset (sot, 0x00, sizeof (sot));

  switch (myParam.Status)
    {
    case 1:			// ソルジャー
      if (eday > 365 * 1000)
	strcpy (sot, "トトロ");
      else if (eday > 365 * 334)
	strcpy (sot, "ルパン三世");
      else if (eday > 365 * 100)
	strcpy (sot, "宇宙大神");
      else if (eday > 365 * 10)
	strcpy (sot, "ユリア");
      else if (eday > 365 * 5)
	strcpy (sot, "ルフィ");
      else if (eday > 365 * 4)
	strcpy (sot, "ロビン");
      else if (eday > 365 * 3)
	strcpy (sot, "ゾロ");
      else if (eday > 365 * 2)
	strcpy (sot, "チョッパー");
      else if (eday > 365)
	strcpy (sot, "ケンシロウ ");
      else if (eday >= 330)
	strcpy (sot, "トキ ");
      else if (eday >= 300)
	strcpy (sot, "ラオウ ");
      else if (eday >= 270)
	strcpy (sot, "カイオウ ");
      else if (eday >= 240)
	strcpy (sot, "神 ");
      else if (eday >= 210)
	strcpy (sot, "大王様 ");
      else if (eday >= 180)
	strcpy (sot, "王様 ");
      else if (eday >= 150)
	strcpy (sot, "大統領 ");
      else if (eday >= 120)
	strcpy (sot, "首相 ");
      else if (eday >= 90)
	strcpy (sot, "大臣 ");
      else if (eday >= 60)
	strcpy (sot, "元帥 ");
      else if (eday >= 30)
	strcpy (sot, "大将 ");
      else if (eday >= 26)
	strcpy (sot, "中将 ");
      else if (eday >= 22)
	strcpy (sot, "少将 ");
      else if (eday >= 20)
	strcpy (sot, "大佐 ");
      else if (eday >= 18)
	strcpy (sot, "中佐 ");
      else if (eday >= 16)
	strcpy (sot, "少佐 ");
      else if (eday >= 14)
	strcpy (sot, "大尉 ");
      else if (eday >= 12)
	strcpy (sot, "中尉 ");
      else if (eday >= 10)
	strcpy (sot, "少尉 ");
      else if (eday >= 8)
	strcpy (sot, "准尉 ");
      else if (eday >= 6)
	strcpy (sot, "曹長 ");
      else if (eday >= 5)
	strcpy (sot, "軍曹 ");
      else if (eday >= 4)
	strcpy (sot, "伍長 ");
      else if (eday >= 3)
	strcpy (sot, "兵長 ");
      else if (eday >= 2)
	strcpy (sot, "上等兵 ");
      else if (eday >= 1)
	strcpy (sot, "一等兵 ");
      else
	strcpy (sot, "二等兵 ");

      break;
    case 2:			// コスモ
      if (eday > 365 * 1000)
	strcpy (sot, "トトロ");
      else if (eday > 365 * 334)
	strcpy (sot, "ルパン三世");
      else if (eday > 365 * 100)
	strcpy (sot, "宇宙大神");
      else if (eday > 365 * 10)
	strcpy (sot, "宇宙神");
      else if (eday > 365 * 5)
	strcpy (sot, "宇宙大王");
      else if (eday > 365 * 4)
	strcpy (sot, "宇宙王");
      else if (eday > 365 * 3)
	strcpy (sot, "宇宙王子");
      else if (eday > 365 * 2)
	strcpy (sot, "大宇宙 ");
      else if (eday > 365)
	strcpy (sot, "コスモ ");
      else if (eday >= 330)
	strcpy (sot, "小宇宙 ");
      else if (eday >= 300)
	strcpy (sot, "星雲 ");
      else if (eday >= 270)
	strcpy (sot, "大銀河 ");
      else if (eday >= 240)
	strcpy (sot, "銀河 ");
      else if (eday >= 210)
	strcpy (sot, "太陽系 ");
      else if (eday >= 180)
	strcpy (sot, "月と地球 ");
      else if (eday >= 150)
	strcpy (sot, "地球 ");
      else if (eday >= 120)
	strcpy (sot, "北半球 ");
      else if (eday >= 90)
	strcpy (sot, "アジア ");
      else if (eday >= 60)
	strcpy (sot, "東アジア ");
      else if (eday >= 30)
	strcpy (sot, "日本列島 ");
      else if (eday >= 26)
	strcpy (sot, "県 ");
      else if (eday >= 22)
	strcpy (sot, "市 ");
      else if (eday >= 20)
	strcpy (sot, "農村 ");
      else if (eday >= 18)
	strcpy (sot, "集落 ");
      else if (eday >= 16)
	strcpy (sot, "農家 ");
      else if (eday >= 14)
	strcpy (sot, "鶏小屋 ");
      else if (eday >= 12)
	strcpy (sot, "ニワトリ ");
      else if (eday >= 10)
	strcpy (sot, "ヒヨコ ");
      else if (eday >= 8)
	strcpy (sot, "タマゴ ");
      else if (eday >= 6)
	strcpy (sot, "大豆 ");
      else if (eday >= 5)
	strcpy (sot, "小豆 ");
      else if (eday >= 4)
	strcpy (sot, "ゴマ粒 ");
      else if (eday >= 3)
	strcpy (sot, "分子 ");
      else if (eday >= 2)
	strcpy (sot, "原子 ");
      else if (eday >= 1)
	strcpy (sot, "陽子 ");
      else
	strcpy (sot, "素粒子 ");
      break;
    }

  return sot;
}

gchar *
DisplayElaspedTime (sotsuval sv)
{
  /******************************************
   * 卒煙からの日数
   * " %d年 %dヶ月 %d日  %d時 %d分"
   ******************************************/
  static gchar res[100];
  gint w_year, w_month, w_day, w_hour, w_minute, w_second;

  memset (res, 0x00, sizeof (res));

  w_year = sv.Year;
  w_month = sv.Month;
  w_day = sv.Day;
  w_hour = sv.Hour;
  w_minute = sv.Min;
  w_second = sv.Sec;

	if(myParam.DET == 0) {
	  sprintf (res,
		   " %d年 %dヶ月 %d日  %d時 %d分",
		   w_year, w_month, w_day, w_hour, w_minute);
	//	   " %d年 %dヶ月 %d日  %d時 %d分(%d秒)",
	//	   w_year, w_month, w_day, w_hour, w_minute, w_second);
	}else{
	  sprintf (res,
		   " %d日  %d時 %d分",
		   sv.eDay, w_hour, w_minute);
	}
  return res;
}

int
CalSotsuVal (sotsuval *sv, gint esec,
	     gint year, gint month, gint day,
	     gint hour, gint minute, gint second)
{
  /******************************************
   * 各種パラメタ計算
   * 入力: 経過秒(esec), 
   * 更新: 卒煙パラメタ(sotsuval)	
   ******************************************/
  sv->Year = 0;
  sv->Month = 0;
  sv->Day = 0;
  sv->Hour = 0;
  sv->Min = 0;
  sv->Sec = 0;
  sv->eSec = 0;
  sv->eDay = 0;
  sv->CCount = 0;
  sv->CLen = 0;
  sv->SavedMoney = 0;
  sv->SavedTax = 0;
  sv->LifeSpanDay = 0;
  sv->LifeSpanHour = 0;
  sv->LifeSpanMin = 0;

	if (esec < 0) {
			return 1;
	}
  sv->eSec = esec;
  sv->eDay = (int) (esec / 60 / 60 / 24);			
			
  //経過時間 
  gint w_year, w_month, w_day, w_hour, w_minute, w_second;

  w_second = second - 0;
  if (w_second < 0)
    {
      w_second += 60;
      minute -= 1;
    }
  w_minute = minute - myParam.DMin;
  if (w_minute < 0)
    {
      w_minute += 60;
      hour -= 1;
    }
  w_hour = hour - myParam.DHour;
  if (w_hour < 0)
    {
      w_hour += 24;
      day -= 1;
    }
  w_day = day - myParam.DDay;
  if (w_day < 0)
    {
      switch (myParam.DMonth)
      //switch (month)	// 08.05.18 bug fix(elapsed date)
	{
	case 1:
	  w_day += 31;
	  break;
	case 2:
	  if (myParam.DYear % 4 == 0)
	  //if (year % 4 == 0)	// 08.05.18 bug fix(elapsed date)
	    w_day += 29;
	  else
	    w_day += 28;
	  break;
	case 3:
	  w_day += 31;
	  break;
	case 4:
	  w_day += 30;
	  break;
	case 5:
	  w_day += 31;
	  break;
	case 6:
	  w_day += 30;
	  break;
	case 7:
	  w_day += 31;
	  break;
	case 8:
	  w_day += 31;
	  break;
	case 9:
	  w_day += 30;
	  break;
	case 10:
	  w_day += 31;
	  break;
	case 11:
	  w_day += 30;
	  break;
	case 12:
	  w_day += 31;
	  break;
/*		//08/05/18 bug fix(elapsed date)	
	case 0:
	  w_day += 31;	//08.05.17 bug fix 30->31(December)
	  break;
	case 1:
	  w_day += 31;
	  break;
	case 2:
	  if (year % 4 == 0)
	    w_day += 29;
	  else
	    w_day += 28;
	  break;
	case 3:
	  w_day += 31;
	  break;
	case 4:
	  w_day += 30;
	  break;
	case 5:
	  w_day += 31;
	  break;
	case 6:
	  w_day += 30;
	  break;
	case 7:
	  w_day += 31;
	  break;
	case 8:
	  w_day += 31;
	  break;
	case 9:
	  w_day += 30;
	  break;
	case 10:
	  w_day += 31;
	  break;
	case 11:
	  w_day += 30;
	  break;
*/
	}
      month -= 1;
    }
  w_month = (month + 1) - myParam.DMonth;
  if (w_month < 0)
    {
      w_month += 12;
      year -= 1;
    }
  w_year = (year + 1900) - myParam.DYear;
	/* DEBUG */
	/*
  g_print ("Elasp: %4d/%2d/%2d %2d:%2d:%2d\n", w_year, w_month, w_day, w_hour,
	   w_minute, w_second);
	*/
	/* DEBUG-END */
	if (w_year < 0 || w_month < 0 || w_day < 0 || w_hour < 0 || w_minute < 0 || w_second < 0) {
		return 2;
	}
  sv->Year = w_year;
  sv->Month = w_month;
  sv->Day = w_day;
  sv->Hour = w_hour;
  sv->Min = w_minute;
  sv->Sec = w_second;

  //"999999本 99999.99m エベレスト１３個分"
  static gfloat sl[] = { 0, 0.05000, 0.08500, 0.10000 };	//タバコの長さS,M,L
  gfloat honsu;
  gfloat nagasa;
  honsu = (gfloat) esec / 86400;
  honsu = honsu * (gfloat) myParam.TCount;
  nagasa = sl[myParam.TSize] * honsu;
	if (honsu < 0 || nagasa < 0) {
		return 3;
	}

  sv->CCount = honsu;
  sv->CLen = nagasa;

  //"9999日と99時間99分"
  if (myParam.TCount != 0)
    {
      gfloat lssec = (gfloat) 86400 / myParam.TCount;

      gfloat wesec = (gfloat) esec / lssec * 330;
      gint eday = (gint) (wesec / 60 / 60 / 24);
      gint ehour = (gint) (wesec / 60 / 60 - eday * 24);
      gint emin = (gint) (wesec / 60 - eday * 24 * 60 - ehour * 60);

			if (eday < 0 || ehour < 0 || emin < 0) {
				return 4;
			}
      sv->LifeSpanDay = eday;
      sv->LifeSpanHour = ehour;
      sv->LifeSpanMin = emin;
    }

  //"99999999円（節税分 999999円）"
  if (myParam.TCount != 0 && myParam.TPrice != 0)
    {

      gfloat wtprice =
	(gfloat) myParam.TPrice * ((gfloat) myParam.TCount / 20);
      gfloat smsec = 86400 / wtprice;
      gfloat Dprice = (gfloat) esec / smsec;

      gfloat Dtax = honsu / 1000 * (gfloat) myParam.TTax;
      gfloat DtaxPer =
	Dprice * ((gfloat) myParam.TTaxPer / (100 + myParam.TTaxPer));
      Dtax = Dtax + DtaxPer;
 			if ( Dprice < 0 || Dtax < 0 ) {
				return 5;
			}
      sv->SavedMoney = (gint) Dprice;
      sv->SavedTax = (gint) Dtax;
    }

	return 0;
}
